/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import junit.framework.TestCase;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.metadata.runtime.MetadataObject;

public class TestTranslationUtility
extends TestCase {
    public TestTranslationUtility(String name) {
        super(name);
    }

    public String getTestVDB() {
        return UnitTestUtil.getTestDataPath() + "/partssupplier/PartsSupplier.vdb";
    }

    public void helpTestTranslate(String vdbFile, String sql, String expectedOutput) {
        TranslationUtility util = new TranslationUtility(this.getTestVDB());
        ICommand query = util.parseCommand(sql);
        TestTranslationUtility.assertEquals((String)expectedOutput, (String)query.toString());
    }

    public void testQuery1() {
        this.helpTestTranslate(this.getTestVDB(), "select * from partssupplier.parts", "SELECT PARTS.PART_ID, PARTS.PART_NAME, PARTS.PART_COLOR, PARTS.PART_WEIGHT FROM PARTS");
    }

    public void testInsert1() {
        this.helpTestTranslate(this.getTestVDB(), "insert into partssupplier.parts (part_name, part_color) values ('P100', 'Red')", "INSERT INTO PARTS (PART_NAME, PART_COLOR) VALUES ('P100', 'Red')");
    }

    public void testUpdate1() {
        this.helpTestTranslate(this.getTestVDB(), "update partssupplier.parts set part_name = 'P100' where part_color = 'Red'", "UPDATE PARTS SET PART_NAME = 'P100' WHERE PARTS.PART_COLOR = 'Red'");
    }

    public void testDelete1() {
        this.helpTestTranslate(this.getTestVDB(), "delete from partssupplier.parts where part_color = 'Red'", "DELETE FROM PARTS WHERE PARTS.PART_COLOR = 'Red'");
    }

    public void testGetRMD() throws Exception {
        TranslationUtility util = new TranslationUtility(this.getTestVDB());
        IQuery query = (IQuery)util.parseCommand("select * from partssupplier.parts");
        IGroup group = (IGroup)query.getFrom().getItems().get(0);
        MetadataObject mid = group.getMetadataObject();
        TestTranslationUtility.assertEquals((String)"PartsSupplier.PARTSSUPPLIER.PARTS", (String)mid.getFullName());
        TestTranslationUtility.assertEquals((String)"PARTS", (String)mid.getNameInSource());
    }
}

