/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.cdk.api.EnvironmentUtility;
import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.metadata.runtime.VDBMetadataFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import java.io.Serializable;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.connector.jdbc.translator.SQLConversionVisitor;
import org.teiid.connector.jdbc.translator.TranslatedCommand;
import org.teiid.connector.jdbc.translator.Translator;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.ILanguageObject;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;
import org.teiid.dqp.internal.datamgr.impl.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.impl.FakeExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.language.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.language.TestDeleteImpl;
import org.teiid.dqp.internal.datamgr.language.TestInsertImpl;
import org.teiid.dqp.internal.datamgr.language.TestProcedureImpl;
import org.teiid.dqp.internal.datamgr.language.TestSelectImpl;
import org.teiid.dqp.internal.datamgr.language.TestUpdateImpl;
import org.teiid.dqp.internal.datamgr.language.TstLanguageBridgeFactory;

public class TestSQLConversionVisitor
extends TestCase {
    public static final ExecutionContext context = new ExecutionContextImpl("VDB", "Version", "User", (Serializable)((Object)"Payload"), (Serializable)((Object)"ExecutionPayload"), "ConnectionID", "Connector", "RequestID", "PartID", "ExecCount");
    public static final RuntimeMetadata metadata = TstLanguageBridgeFactory.metadataFactory;

    public TestSQLConversionVisitor(String name) {
        super(name);
    }

    public String getTestVDB() {
        return UnitTestUtil.getTestDataPath() + "/partssupplier/PartsSupplier.vdb";
    }

    public ICommand helpTranslate(String vdbFileName, String sql) {
        TranslationUtility util = new TranslationUtility(vdbFileName);
        return util.parseCommand(sql);
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) {
        this.helpTestVisitor(vdb, input, expectedOutput, false);
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput, boolean useMetadata) {
        this.helpTestVisitor(vdb, input, expectedOutput, useMetadata, false);
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput, boolean useMetadata, boolean usePreparedStatement) {
        ICommand obj = this.helpTranslate(vdb, input);
        try {
            this.helpTestVisitorWithCommand(expectedOutput, obj, useMetadata, usePreparedStatement);
        }
        catch (ConnectorException e) {
            throw new RuntimeException(e);
        }
    }

    private String getStringWithContext(ILanguageObject obj) throws ConnectorException {
        Properties props = new Properties();
        props.setProperty("UseCommentsInSourceQuery", Boolean.TRUE.toString());
        Translator trans = new Translator();
        trans.initialize(EnvironmentUtility.createEnvironment((Properties)props, (boolean)false));
        SQLConversionVisitor visitor = trans.getSQLConversionVisitor();
        visitor.setExecutionContext(context);
        visitor.append(obj);
        return visitor.toString();
    }

    private void helpTestVisitorWithCommand(String expectedOutput, ICommand obj, boolean useMetadata, boolean usePreparedStatement) throws ConnectorException {
        Translator trans = new Translator();
        Properties p = new Properties();
        if (usePreparedStatement) {
            p.setProperty("UseBindVariables", Boolean.TRUE.toString());
        }
        trans.initialize(EnvironmentUtility.createEnvironment((Properties)p, (boolean)false));
        TranslatedCommand tc = new TranslatedCommand((ExecutionContext)new FakeExecutionContextImpl(), trans);
        tc.translateCommand(obj);
        TestSQLConversionVisitor.assertEquals((String)"Did not get correct sql", (String)expectedOutput, (String)tc.getSql());
    }

    public void testSimple() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts", "SELECT PARTS.PART_NAME FROM PARTS");
    }

    public void testAliasInSelect() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name as x from parts", "SELECT PARTS.PART_NAME AS x FROM PARTS");
    }

    public void testAliasedGroup() {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name from parts y", "SELECT y.PART_NAME FROM PARTS AS y");
    }

    public void testAliasedGroupAndElement() {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name AS z from parts y", "SELECT y.PART_NAME AS z FROM PARTS AS y");
    }

    public void testLiteralString() {
        this.helpTestVisitor(this.getTestVDB(), "select 'x' from parts", "SELECT 'x' FROM PARTS");
    }

    public void testLiteralInteger() {
        this.helpTestVisitor(this.getTestVDB(), "select 5 from parts", "SELECT 5 FROM PARTS");
    }

    public void testLiteralFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 5.2 from parts", "SELECT 5.2 FROM PARTS");
    }

    public void testLiteralLowFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 0.012 from parts", "SELECT 0.012 FROM PARTS");
    }

    public void testLiteralLowFloat2() {
        this.helpTestVisitor(this.getTestVDB(), "select 0.00012 from parts", "SELECT 0.00012 FROM PARTS");
    }

    public void testLiteralHighFloat() {
        this.helpTestVisitor(this.getTestVDB(), "select 12345.123 from parts", "SELECT 12345.123 FROM PARTS");
    }

    public void testLiteralHighFloat2() {
        this.helpTestVisitor(this.getTestVDB(), "select 1234567890.1234567 from parts", "SELECT 1234567890.1234567 FROM PARTS");
    }

    public void testLiteralBoolean() {
        this.helpTestVisitor(this.getTestVDB(), "select {b'true'}, {b'false'} from parts", "SELECT 1, 0 FROM PARTS");
    }

    public void testLiteralDate() {
        this.helpTestVisitor(this.getTestVDB(), "select {d'2003-12-31'} from parts", "SELECT {d'2003-12-31'} FROM PARTS");
    }

    public void testLiteralTime() {
        this.helpTestVisitor(this.getTestVDB(), "select {t'23:59:59'} from parts", "SELECT {t'23:59:59'} FROM PARTS");
    }

    public void testLiteralNull() {
        this.helpTestVisitor(this.getTestVDB(), "select null from parts", "SELECT NULL FROM PARTS");
    }

    public void testLiteralTimestamp() {
        this.helpTestVisitor(this.getTestVDB(), "select {ts'2003-12-31 23:59:59.123'} from parts", "SELECT {ts'2003-12-31 23:59:59.123'} FROM PARTS");
    }

    public void testSQL89Join() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p, supplier_parts s where p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p, SUPPLIER_PARTS AS s WHERE p.PART_ID = s.PART_ID");
    }

    public void testSQL92Join() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p INNER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    public void testSelfJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p join parts p2 on p.part_id = p2.part_id", "SELECT p.PART_NAME FROM PARTS AS p INNER JOIN PARTS AS p2 ON p.PART_ID = p2.PART_ID");
    }

    public void testRightOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p right join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM SUPPLIER_PARTS AS s LEFT OUTER JOIN PARTS AS p ON p.PART_ID = s.PART_ID");
    }

    public void testLeftOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p left join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p LEFT OUTER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    public void testFullOuterJoin() {
        this.helpTestVisitor(this.getTestVDB(), "select p.part_name from parts p full join supplier_parts s on p.part_id = s.part_id", "SELECT p.PART_NAME FROM PARTS AS p FULL OUTER JOIN SUPPLIER_PARTS AS s ON p.PART_ID = s.PART_ID");
    }

    public void testCompare1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id = 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID = 'x'");
    }

    public void testCompare2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id <> 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID <> 'x'");
    }

    public void testCompare3() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id < 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID < 'x'");
    }

    public void testCompare4() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id <= 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID <= 'x'");
    }

    public void testCompare5() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id > 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID > 'x'");
    }

    public void testCompare6() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id >= 'x'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID >= 'x'");
    }

    public void testIn1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id in ('x')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID = 'x'");
    }

    public void testIn2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id in ('x', 'y')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IN ('x', 'y')");
    }

    public void testIn3() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id not in ('x', 'y')", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID NOT IN ('x', 'y')");
    }

    public void testIsNull1() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id is null", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IS NULL");
    }

    public void testIsNull2() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id is not null", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_ID IS NOT NULL");
    }

    public void testInsertNull() {
        this.helpTestVisitor(this.getTestVDB(), "insert into parts (part_id, part_name, part_color, part_weight) values ('a', null, 'c', 'd')", "INSERT INTO PARTS (PART_ID, PART_NAME, PART_COLOR, PART_WEIGHT) VALUES ('a', NULL, 'c', 'd')");
    }

    public void testUpdateNull() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = null where part_color = 'b'", "UPDATE PARTS SET PART_WEIGHT = NULL WHERE PARTS.PART_COLOR = 'b'");
    }

    public void testUpdateWhereNull() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = 'a' where part_weight = null", "UPDATE PARTS SET PART_WEIGHT = 'a' WHERE NULL <> NULL");
    }

    public void testGroupByWithFunctions() throws Exception {
        QueryMetadataInterface metadata = VDBMetadataFactory.getVDBMetadata((String)this.getTestVDB());
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("part_name"));
        From from = new From();
        from.addGroup(new GroupSymbol("parts"));
        GroupBy groupBy = new GroupBy();
        Function function = new Function("concat", new Expression[]{new ElementSymbol("part_id"), new Constant((Object)"a")});
        groupBy.addSymbol((Expression)function);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)metadata);
        Command command = QueryRewriter.rewrite((Command)query, null, (QueryMetadataInterface)metadata, null);
        ICommand result = new LanguageBridgeFactory(metadata).translate(command);
        this.helpTestVisitorWithCommand("SELECT PARTS.PART_NAME FROM PARTS GROUP BY concat(PARTS.PART_ID, 'a')", result, false, false);
    }

    public void testPreparedStatementCreationWithUpdate() {
        this.helpTestVisitor(this.getTestVDB(), "update parts set part_weight = 'a' where part_weight < 5", "UPDATE PARTS SET PART_WEIGHT = ? WHERE PARTS.PART_WEIGHT < ?", false, true);
    }

    public void testPreparedStatementCreationWithInsert() {
        this.helpTestVisitor(this.getTestVDB(), "insert into parts (part_weight) values (5)", "INSERT INTO PARTS (PART_WEIGHT) VALUES (?)", false, true);
    }

    public void testPreparedStatementCreationWithSelect() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_id not in ('x', 'y') and part_weight < 6", "SELECT PARTS.PART_NAME FROM PARTS WHERE (PARTS.PART_ID NOT IN (?, ?)) AND (PARTS.PART_WEIGHT < ?)", false, true);
    }

    public void testPreparedStatementCreationWithLike() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where part_name like '%foo'", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_NAME LIKE ?", false, true);
    }

    public void testPreparedStatementCreationWithLeftConstant() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where 'x' = 'y'", "SELECT PARTS.PART_NAME FROM PARTS WHERE 1 = ?", false, true);
    }

    public void testPreparedStatementCreationWithFunction() {
        this.helpTestVisitor(this.getTestVDB(), "select part_name from parts where concat(part_name, 'x') = concat('y', part_weight)", "SELECT PARTS.PART_NAME FROM PARTS WHERE concat(PARTS.PART_NAME, 'x') = concat('y', PARTS.PART_WEIGHT)", false, true);
    }

    public void testPreparedStatementCreationWithCase() {
        this.helpTestVisitor(this.getTestVDB(), "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_WEIGHT = CASE WHEN PARTS.PART_NAME='a' THEN 'b' ELSE 'c' END", "SELECT PARTS.PART_NAME FROM PARTS WHERE PARTS.PART_WEIGHT = CASE WHEN PARTS.PART_NAME = ? THEN 'b' ELSE 'c' END", false, true);
    }

    public void testVisitIDeleteWithComment() throws Exception {
        String expected = "DELETE /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/ FROM g1 WHERE (100 >= 200) AND (500 < 600)";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestDeleteImpl.example()));
    }

    public void testVisitIInsertWithComment() throws Exception {
        String expected = "INSERT /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/ INTO g1 (e1, e2, e3, e4) VALUES (1, 2, 3, 4)";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestInsertImpl.example((String)"g1")));
    }

    public void testVisitISelectWithComment() throws Exception {
        String expected = "SELECT /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/ g1.e1, g1.e2, g1.e3, g1.e4";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestSelectImpl.example((boolean)false)));
        expected = "SELECT /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/ DISTINCT g1.e1, g1.e2, g1.e3, g1.e4";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestSelectImpl.example((boolean)true)));
    }

    public void testVisitIUpdateWithComment() throws Exception {
        String expected = "UPDATE /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/ g1 SET e1 = 1, e2 = 1, e3 = 1, e4 = 1 WHERE 1 = 1";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestUpdateImpl.example()));
    }

    public void testVisitIProcedureWithComment() throws Exception {
        String expected = "{ /*teiid sessionid:ConnectionID, requestid:RequestID.PartID*/  call sq3(?,?)}";
        TestSQLConversionVisitor.assertEquals((String)expected, (String)this.getStringWithContext((ILanguageObject)TestProcedureImpl.example()));
    }
}

