/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.cdk.CommandBuilder;
import com.metamatrix.cdk.api.EnvironmentUtility;
import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.unittest.FakeMetadataFacade;
import com.metamatrix.query.unittest.FakeMetadataFactory;
import com.metamatrix.query.unittest.FakeMetadataObject;
import com.metamatrix.query.unittest.FakeMetadataStore;
import java.io.Serializable;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.connector.jdbc.oracle.OracleSQLTranslator;
import org.teiid.connector.jdbc.translator.TranslatedCommand;
import org.teiid.connector.jdbc.translator.Translator;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;
import org.teiid.dqp.internal.datamgr.impl.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.impl.FakeExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;

public class TestOracleSQLConversionVisitor
extends TestCase {
    private static ExecutionContext EMPTY_CONTEXT = new FakeExecutionContextImpl();

    public TestOracleSQLConversionVisitor(String name) {
        super(name);
    }

    private String getTestVDB() {
        return UnitTestUtil.getTestDataPath() + "/PartsSupplierOracle.vdb";
    }

    private void helpTestVisitor(String vdb, String input, String dbmsTimeZone, String expectedOutput) throws ConnectorException {
        this.helpTestVisitor(vdb, input, EMPTY_CONTEXT, dbmsTimeZone, expectedOutput, false);
    }

    private void helpTestVisitor(String vdb, String input, String dbmsTimeZone, String expectedOutput, boolean correctNaming) throws ConnectorException {
        this.helpTestVisitor(vdb, input, EMPTY_CONTEXT, dbmsTimeZone, expectedOutput, correctNaming);
    }

    private void helpTestVisitor(String vdb, String input, ExecutionContext context, String dbmsTimeZone, String expectedOutput, boolean correctNaming) throws ConnectorException {
        TranslationUtility util = new TranslationUtility(vdb);
        ICommand obj = util.parseCommand(input, correctNaming, true);
        this.helpTestVisitor(obj, util.createRuntimeMetadata(), context, dbmsTimeZone, expectedOutput);
    }

    private void helpTestVisitor(QueryMetadataInterface metadata, String input, ExecutionContext context, String dbmsTimeZone, String expectedOutput) throws ConnectorException {
        CommandBuilder commandBuilder = new CommandBuilder(metadata);
        ICommand obj = commandBuilder.getCommand(input);
        RuntimeMetadataImpl runtimeMetadata = new RuntimeMetadataImpl(metadata);
        this.helpTestVisitor(obj, (RuntimeMetadata)runtimeMetadata, context, dbmsTimeZone, expectedOutput);
    }

    private void helpTestVisitor(ICommand obj, RuntimeMetadata metadata, ExecutionContext context, String dbmsTimeZone, String expectedOutput) throws ConnectorException {
        OracleSQLTranslator translator = new OracleSQLTranslator();
        Properties p = new Properties();
        if (dbmsTimeZone != null) {
            p.setProperty("DatabaseTimeZone", dbmsTimeZone);
        }
        translator.initialize(EnvironmentUtility.createEnvironment((Properties)p, (boolean)false));
        TranslatedCommand tc = new TranslatedCommand(context, (Translator)translator);
        tc.translateCommand(obj);
        TestOracleSQLConversionVisitor.assertEquals((String)"Did not get correct sql", (String)expectedOutput, (String)tc.getSql());
    }

    public void defer_testFunctionsInGroupBy() throws Exception {
        String input = "SELECT substring(PART_NAME, 2, 1) FROM PARTS Group By substring(PART_NAME, 2, 1)";
        String output = "SELECT substr(PARTS.PART_NAME, 2, 1) FROM PARTS GROUP BY substr(PARTS.PART_NAME, 2, 1)";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testDateStuff() throws Exception {
        String input = "SELECT ((CASE WHEN month(datevalue) < 10 THEN ('0' || convert(month(datevalue), string)) ELSE convert(month(datevalue), string) END || CASE WHEN dayofmonth(datevalue) < 10 THEN ('0' || convert(dayofmonth(datevalue), string)) ELSE convert(dayofmonth(datevalue), string) END) || convert(year(datevalue), string)), SUM(intkey) FROM bqt1.SMALLA GROUP BY datevalue";
        String output = "SELECT CASE WHEN (CASE WHEN (CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END IS NULL) OR (CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END IS NULL) THEN NULL ELSE concat(CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END, CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END) END IS NULL) OR (to_char(EXTRACT(YEAR FROM SmallA.DateValue)) IS NULL) THEN NULL ELSE concat(CASE WHEN (CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END IS NULL) OR (CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END IS NULL) THEN NULL ELSE concat(CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(MONTH FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(MONTH FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END, CASE WHEN EXTRACT(DAY FROM SmallA.DateValue) < 10 THEN CASE WHEN to_char(EXTRACT(DAY FROM SmallA.DateValue)) IS NULL THEN NULL ELSE concat('0', to_char(EXTRACT(DAY FROM SmallA.DateValue))) END ELSE to_char(EXTRACT(DAY FROM SmallA.DateValue)) END) END, to_char(EXTRACT(YEAR FROM SmallA.DateValue))) END, SUM(SmallA.IntKey) FROM SmallA GROUP BY SmallA.DateValue";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void defer_testDateStuffGroupBy() throws Exception {
        String input = "SELECT ((CASE WHEN month(datevalue) < 10 THEN ('0' || convert(month(datevalue), string)) ELSE convert(month(datevalue), string) END || CASE WHEN dayofmonth(datevalue) < 10 THEN ('0' || convert(dayofmonth(datevalue), string)) ELSE convert(dayofmonth(datevalue), string) END) || convert(year(datevalue), string)), SUM(intkey) FROM bqt1.SMALLA GROUP BY month(datevalue), dayofmonth(datevalue), year(datevalue)";
        String output = "SELECT ((CASE WHEN EXTRACT(MONTH FROM SmallA.DateValue) < 10 THEN ('0' || to_char(EXTRACT(MONTH FROM SmallA.DateValue))) ELSE to_char(EXTRACT(MONTH FROM SmallA.DateValue)) END || CASE WHEN TO_NUMBER(TO_CHAR(SmallA.DateValue, 'DD')) < 10 THEN ('0' || to_char(TO_NUMBER(TO_CHAR(SmallA.DateValue, 'DD')))) ELSE to_char(TO_NUMBER(TO_CHAR(SmallA.DateValue, 'DD'))) END) || to_char(EXTRACT(YEAR FROM SmallA.DateValue))), SUM(SmallA.IntKey) FROM SmallA GROUP BY EXTRACT(MONTH FROM SmallA.DateValue), TO_NUMBER(TO_CHAR(SmallA.DateValue, 'DD')), EXTRACT(YEAR FROM SmallA.DateValue)";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testCharFunction() throws Exception {
        String input = "SELECT char(CONVERT(PART_ID, INTEGER)) FROM PARTS";
        String output = "SELECT chr(to_number(PARTS.PART_ID)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testLcaseFunction() throws Exception {
        String input = "SELECT lcase(PART_NAME) FROM PARTS";
        String output = "SELECT lower(PARTS.PART_NAME) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testUcaseFunction() throws Exception {
        String input = "SELECT ucase(PART_NAME) FROM PARTS";
        String output = "SELECT upper(PARTS.PART_NAME) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testIfnullFunction() throws Exception {
        String input = "SELECT ifnull(PART_NAME, 'x') FROM PARTS";
        String output = "SELECT nvl(PARTS.PART_NAME, 'x') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testLogFunction() throws Exception {
        String input = "SELECT log(CONVERT(PART_ID, INTEGER)) FROM PARTS";
        String output = "SELECT ln(to_number(PARTS.PART_ID)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testLog10Function() throws Exception {
        String input = "SELECT log10(CONVERT(PART_ID, INTEGER)) FROM PARTS";
        String output = "SELECT log(10, to_number(PARTS.PART_ID)) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionInteger() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, integer) FROM PARTS";
        String output = "SELECT to_number(PARTS.PART_ID) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionChar() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, char) FROM PARTS";
        String output = "SELECT PARTS.PART_ID FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionBoolean() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, boolean) FROM PARTS";
        String output = "SELECT decode(PARTS.PART_ID, 'true', 1, 'false', 0) FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionDate() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, date) FROM PARTS";
        String output = "SELECT to_date(PARTS.PART_ID, 'YYYY-MM-DD') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionTime() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, time) FROM PARTS";
        String output = "SELECT to_date(('1970-01-01 ' || to_char(PARTS.PART_ID, 'HH24:MI:SS')), 'YYYY-MM-DD HH24:MI:SS') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testConvertFunctionTimestamp() throws Exception {
        String input = "SELECT convert(PARTS.PART_ID, timestamp) FROM PARTS";
        String output = "SELECT to_timestamp(PARTS.PART_ID, 'YYYY-MM-DD HH24:MI:SS.FF') FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testExtractFunctionTimestamp() throws Exception {
        String input = "SELECT month(TIMESTAMPVALUE) FROM BQT1.Smalla";
        String output = "SELECT EXTRACT(MONTH FROM SmallA.TimestampValue) FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testAliasedGroup() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select y.part_name from parts as y", null, "SELECT y.PART_NAME FROM PARTS y");
    }

    public void testDateLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {d'2002-12-31'} FROM parts", null, "SELECT {d'2002-12-31'} FROM PARTS");
    }

    public void testTimeLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {t'13:59:59'} FROM parts", null, "SELECT {ts'1970-01-01 13:59:59'} FROM PARTS");
    }

    public void testTimestampLiteral() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select {ts'2002-12-31 13:59:59'} FROM parts", null, "SELECT {ts'2002-12-31 13:59:59.0'} FROM PARTS");
    }

    public void testUnionOrderByWithThreeBranches() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id id FROM parts UNION ALL select part_name FROM parts UNION ALL select part_id FROM parts ORDER BY id", null, "(SELECT g_2.PART_ID AS c_0 FROM PARTS g_2 UNION ALL SELECT g_1.PART_NAME AS c_0 FROM PARTS g_1) UNION ALL SELECT g_0.PART_ID AS c_0 FROM PARTS g_0 ORDER BY c_0", true);
    }

    public void testUnionOrderBy() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id FROM parts UNION ALL select part_name FROM parts ORDER BY part_id", null, "SELECT g_1.PART_ID AS c_0 FROM PARTS g_1 UNION ALL SELECT g_0.PART_NAME AS c_0 FROM PARTS g_0 ORDER BY c_0", true);
    }

    public void testUnionOrderBy2() throws Exception {
        this.helpTestVisitor(this.getTestVDB(), "select part_id as p FROM parts UNION ALL select part_name FROM parts ORDER BY p", null, "SELECT PARTS.PART_ID AS p FROM PARTS UNION ALL SELECT PARTS.PART_NAME FROM PARTS ORDER BY p");
    }

    public void testUpdateWithFunction() throws Exception {
        String input = "UPDATE bqt1.smalla SET intkey = intkey + 1";
        String output = "UPDATE SmallA SET IntKey = (SmallA.IntKey + 1)";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testDUAL() throws Exception {
        String input = "SELECT something FROM DUAL";
        String output = "SELECT something FROM DUAL";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testROWNUM() throws Exception {
        String input = "SELECT part_name, rownum FROM parts";
        String output = "SELECT PARTS.PART_NAME, ROWNUM FROM PARTS";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testROWNUM2() throws Exception {
        String input = "SELECT part_name FROM parts where rownum < 100";
        String output = "SELECT PARTS.PART_NAME FROM PARTS WHERE ROWNUM < 100";
        this.helpTestVisitor(this.getTestVDB(), input, null, output);
    }

    public void testOracleCommentPayload() throws Exception {
        String input = "SELECT part_name, rownum FROM parts";
        String output = "SELECT /*+ ALL_ROWS */ PARTS.PART_NAME, ROWNUM FROM PARTS";
        String hint = "/*+ ALL_ROWS */";
        ExecutionContextImpl context = new ExecutionContextImpl(null, null, null, null, (Serializable)((Object)hint), null, "", null, null, null);
        this.helpTestVisitor(this.getTestVDB(), input, (ExecutionContext)context, null, output, false);
    }

    public void testCase3845() throws Exception {
        String input = "SELECT (DoubleNum * 1.0) FROM BQT1.Smalla";
        String output = "SELECT (SmallishA.DoubleNum * 1.0) FROM SmallishA";
        FakeMetadataFacade metadata = this.exampleCase3845();
        this.helpTestVisitor((QueryMetadataInterface)metadata, input, EMPTY_CONTEXT, null, output);
    }

    private FakeMetadataFacade exampleCase3845() {
        FakeMetadataObject bqt1 = FakeMetadataFactory.createPhysicalModel((String)"BQT1");
        FakeMetadataObject bqt1SmallA = FakeMetadataFactory.createPhysicalGroup((String)"BQT1.SmallA", (FakeMetadataObject)bqt1);
        bqt1SmallA.putProperty("nameInSource", (Object)"SmallishA");
        FakeMetadataObject doubleNum = FakeMetadataFactory.createElement((String)"BQT1.SmallA.DoubleNum", (FakeMetadataObject)bqt1SmallA, (String)"double", (int)0);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(bqt1);
        store.addObject(bqt1SmallA);
        store.addObject(doubleNum);
        return new FakeMetadataFacade(store);
    }

    public void helpTestVisitor(String vdb, String input, String expectedOutput) throws ConnectorException {
        this.helpTestVisitor(vdb, input, null, expectedOutput);
    }

    public void testRowLimit2() throws Exception {
        String input = "select intkey from bqt1.smalla limit 100";
        String output = "SELECT * FROM (SELECT SmallA.IntKey FROM SmallA) WHERE ROWNUM <= 100";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testRowLimit3() throws Exception {
        String input = "select intkey from bqt1.smalla limit 50, 100";
        String output = "SELECT * FROM (SELECT VIEW_FOR_LIMIT.*, ROWNUM ROWNUM_ FROM (SELECT SmallA.IntKey FROM SmallA) VIEW_FOR_LIMIT WHERE ROWNUM <= 150) WHERE ROWNUM_ > 50";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testLimitWithNestedInlineView() throws Exception {
        String input = "select max(intkey), stringkey from (select intkey, stringkey from bqt1.smalla order by intkey limit 100) x group by intkey";
        String output = "SELECT MAX(x.intkey), x.stringkey FROM (SELECT * FROM (SELECT SmallA.IntKey, SmallA.StringKey FROM SmallA ORDER BY intkey) WHERE ROWNUM <= 100) x GROUP BY x.intkey";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testExceptAsMinus() throws Exception {
        String input = "select intkey, intnum from bqt1.smalla except select intnum, intkey from bqt1.smallb";
        String output = "SELECT SmallA.IntKey, SmallA.IntNum FROM SmallA MINUS SELECT SmallB.IntNum, SmallB.IntKey FROM SmallB";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), input, EMPTY_CONTEXT, null, output);
    }

    public void testConcat2_useLiteral() throws Exception {
        String sql = "select concat2(stringnum,'_xx') from BQT1.Smalla";
        String expected = "SELECT concat(nvl(SmallA.StringNum, ''), '_xx') FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    public void testConcat2() throws Exception {
        String sql = "select concat2(stringnum, stringnum) from BQT1.Smalla";
        String expected = "SELECT CASE WHEN SmallA.StringNum IS NULL THEN NULL ELSE concat(nvl(SmallA.StringNum, ''), nvl(SmallA.StringNum, '')) END FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    public void testConcat() throws Exception {
        String sql = "select concat(stringnum, stringkey) from BQT1.Smalla";
        String expected = "SELECT CASE WHEN (SmallA.StringNum IS NULL) OR (SmallA.StringKey IS NULL) THEN NULL ELSE concat(SmallA.StringNum, SmallA.StringKey) END FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }

    public void testConcat_withLiteral() throws Exception {
        String sql = "select stringnum || '1' from BQT1.Smalla";
        String expected = "SELECT CASE WHEN SmallA.StringNum IS NULL THEN NULL ELSE concat(SmallA.StringNum, '1') END FROM SmallA";
        this.helpTestVisitor((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), sql, EMPTY_CONTEXT, null, expected);
    }
}

