/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.util;

import com.metamatrix.common.types.DataTypeManager;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.connector.jdbc.JDBCQueryExecution;
import org.teiid.connector.language.IExpression;
import org.teiid.connector.language.ISelect;
import org.teiid.dqp.internal.datamgr.language.LiteralImpl;
import org.teiid.dqp.internal.datamgr.language.QueryImpl;
import org.teiid.dqp.internal.datamgr.language.SelectImpl;
import org.teiid.dqp.internal.datamgr.language.SelectSymbolImpl;

public class TestJDBCExecutionHelper
extends TestCase {
    public TestJDBCExecutionHelper(String name) {
        super(name);
    }

    public void testGetColumnDataTypes() {
        Class[] expectedResults = new Class[2];
        ArrayList<SelectSymbolImpl> symbols = new ArrayList<SelectSymbolImpl>();
        symbols.add(new SelectSymbolImpl("c1", (IExpression)new LiteralImpl((Object)"3", DataTypeManager.DefaultDataClasses.STRING)));
        expectedResults[0] = DataTypeManager.DefaultDataClasses.STRING;
        symbols.add(new SelectSymbolImpl("c2", (IExpression)new LiteralImpl((Object)new Integer(5), DataTypeManager.DefaultDataClasses.INTEGER)));
        expectedResults[1] = DataTypeManager.DefaultDataClasses.INTEGER;
        SelectImpl select = new SelectImpl(symbols, false);
        QueryImpl query = new QueryImpl((ISelect)select, null, null, null, null, null);
        Class[] results = query.getColumnTypes();
        TestJDBCExecutionHelper.assertEquals((Object)results[0], (Object)expectedResults[0]);
        TestJDBCExecutionHelper.assertEquals((Object)results[1], (Object)expectedResults[1]);
    }

    public void helpTestTrimString(String value, String expected) {
        String actual = JDBCQueryExecution.trimString((String)value);
        TestJDBCExecutionHelper.assertEquals((String)("Did not get a match, expected=[" + expected + "', actual=[" + actual + "]"), (String)expected, (String)actual);
    }

    public void testTrimEmpty() {
        this.helpTestTrimString("", "");
    }

    public void testTrimNoWhitespace() {
        this.helpTestTrimString("abc", "abc");
    }

    public void testTrimSome() {
        this.helpTestTrimString("abc  ", "abc");
    }

    public void testDontTrimLeft() {
        this.helpTestTrimString("   abc  ", "   abc");
    }

    public void testDontTrimInternal() {
        this.helpTestTrimString("a b c  ", "a b c");
    }
}

