/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.util.ResultSetUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Collections;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCase3473
extends TestCase {
    private static final String DQP_CONFIG_FILE = UnitTestUtil.getTestDataPath() + "/3473/3473.properties";
    static Connection conn = null;
    static String primaryUrl = "jdbc:metamatrix:test@" + DQP_CONFIG_FILE + ";version=1";
    static String serverUrl = primaryUrl + ";logLevel=1;partialResultsMode=false";
    private static MMDatabaseMetaData dbmd = null;
    public static final short ALWAYS_NULL = 0;
    public static final short NEVER_NULL = 1;
    public static final short MAY_BE_NULL = 2;
    private static final boolean REPLACE_EXPECTED = false;
    private static final boolean WRITE_ACTUAL_RESULTS_TO_FILE = false;
    private static final boolean PRINT_RESULTSETS_TO_CONSOLE = false;
    private static final int MAX_COL_WIDTH = 65;
    private FileOutputStream actualOut = null;
    private BufferedReader expectedIn = null;
    private PrintStream stream = null;

    public TestCase3473(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("TestMM3473");
        suite.addTestSuite(TestCase3473.class);
        return new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                Class.forName("com.metamatrix.jdbc.EmbeddedDriver");
                conn = DriverManager.getConnection(serverUrl);
                dbmd = (MMDatabaseMetaData)conn.getMetaData();
            }

            protected void tearDown() throws Exception {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ce) {
                    1.fail((String)("Unable to close MMConnection." + ce.getMessage()));
                }
            }
        };
    }

    private void initResultSetStreams(String testName) {
        File expected = new File(UnitTestUtil.getTestDataPath() + "/3473/" + testName + ".expected");
        try {
            this.expectedIn = new BufferedReader(new FileReader(expected));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        PrintStream defaultStream = null;
        this.stream = ResultSetUtil.getPrintStream((OutputStream)this.actualOut, (BufferedReader)this.expectedIn, defaultStream);
    }

    private void closeResultSetTestStreams() throws IOException {
        this.stream.close();
        if (this.actualOut != null) {
            this.actualOut.close();
        }
        if (this.expectedIn != null) {
            this.expectedIn.close();
        }
    }

    public void checkColumn(String expectedName, short nullable, Class type, String metadataName, Object value) {
        if (nullable == 0) {
            TestCase3473.assertNull((String)("Column " + expectedName + " should always be null but was: " + value), (Object)value);
        }
        if (nullable == 1) {
            TestCase3473.assertNotNull((String)("Column " + expectedName + " should never be null but was"), (Object)value);
        }
        if (value != null) {
            TestCase3473.assertTrue((String)("Column " + expectedName + " is of wrong type"), (boolean)value.getClass().isAssignableFrom(type));
        }
        TestCase3473.assertEquals((String)"Got incorrect column name", (String)expectedName, (String)metadataName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCrossReference() throws Exception {
        this.initResultSetStreams("testGetCrossReference");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getCrossReference1");
            rs = dbmd.getCrossReference(null, null, "test.all_databases", null, null, "test.all_models");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getCrossReference2");
        rs = dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getCrossReference3");
        rs = dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getCrossReference4");
        rs = dbmd.getCrossReference(null, null, null, null, null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        TestCase3473.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetImportedKeys() throws Exception {
        this.initResultSetStreams("testGetImportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getImportedKeys1");
            rs = dbmd.getImportedKeys(null, null, "test.all_models");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getImportedKeys2");
        rs = dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getImportedKeys3");
        rs = dbmd.getImportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        TestCase3473.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetExportedKeys() throws Exception {
        this.initResultSetStreams("testGetExportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getExportedKeys(null, null, "test.all_models");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getExportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        TestCase3473.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPrimaryKeys() throws Exception {
        this.initResultSetStreams("testGetPrimaryKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getPrimaryKeys(null, null, "test.all_models");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = dbmd.getPrimaryKeys(null, "Foo%", "test.all_models");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getPrimaryKeys("foo", "Foo%", "test.all_models");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        TestCase3473.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    public void testGetTables() throws Exception {
        this.initResultSetStreams("testGetTables");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, null, null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getTables(null, "%foo", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getTables("foo", "%foo", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        TestCase3473.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }
}

