/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.util.ResultSetUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMMDatabaseMetaData {
    private static final String DQP_CONFIG_FILE = UnitTestUtil.getTestDataPath() + "/bqt/bqt.properties";
    static Connection conn = null;
    static String primaryUrl = "jdbc:metamatrix:QT_Ora9DS@" + DQP_CONFIG_FILE + ";version=1";
    static String serverUrl = primaryUrl + ";logLevel=1;partialResultsMode=false";
    MMDatabaseMetaData dbmd = null;
    private Map expectedMap = new HashMap();
    private static final int NO_LIMIT = 0;
    private static final String KEY_WORDS = "OPTION, SHOWPLAN, DEBUG";
    private static final int ResultSet_HOLD_CURSORS_OVER_COMMIT = 1;
    private static final int ResultSet_CLOSE_CURSORS_AT_COMMIT = 2;
    public static final short ALWAYS_NULL = 0;
    public static final short NEVER_NULL = 1;
    public static final short MAY_BE_NULL = 2;
    private static final boolean REPLACE_EXPECTED = false;
    private static final boolean WRITE_ACTUAL_RESULTS_TO_FILE = false;
    private static final boolean PRINT_RESULTSETS_TO_CONSOLE = false;
    private static final int MAX_COL_WIDTH = 65;
    private FileOutputStream actualOut = null;
    private BufferedReader expectedIn = null;
    private PrintStream stream = null;

    @Before
    public void setUp() throws Exception {
        this.dbmd = new MMDatabaseMetaData((BaseDriver)DriverManager.getDriver(serverUrl), (MMConnection)conn);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (conn != null) {
            conn.close();
        }
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        Class.forName(EmbeddedDriver.class.getName());
        conn = DriverManager.getConnection(serverUrl);
    }

    @Test
    public void testMethodsWithoutParams() throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        this.expectedMap = this.getExpected();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.expectedMap.containsKey(methods[i].getName())) continue;
            Object actualValue = null;
            Object expectedValue = null;
            Object expectedReturn = this.expectedMap.get(methods[i].getName());
            Object[] params = null;
            if (methods[i].getName().equalsIgnoreCase(DQP_CONFIG_FILE)) {
                if (expectedReturn instanceof List) {
                    List returned = (List)expectedReturn;
                    params = (Object[])returned.get(1);
                    expectedValue = returned.get(0);
                    actualValue = methods[i].invoke((Object)this.dbmd, params);
                } else {
                    expectedValue = expectedReturn;
                    actualValue = methods[i].invoke((Object)this.dbmd, new Object[0]);
                }
            }
            Assert.assertEquals((String)(" Expected doesn't match with actual for method - " + methods[i].getName()), expectedValue, (Object)actualValue);
        }
    }

    @Test
    public void testMethodsWithExceptions() throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        this.expectedMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.expectedMap.containsKey(methods[i].getName())) continue;
            methods[i].invoke((Object)this.dbmd, new Object[0]);
        }
    }

    @Test
    public void testSupportResultSetConcurrency() throws Exception {
        boolean returned = true;
        String functionName = "supportResultSetConcurrency";
        Object[] params = new Object[]{new Integer(1003), new Integer(1007)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004), new Integer(1007)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004), new Integer(1008)};
        returned = false;
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1003), new Integer(1008)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportResultSetHoldability() throws Exception {
        boolean returned = false;
        String functionName = "supportResultSetHoldability";
        Object[] params = new Object[]{new Integer(1)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(2)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportResultSetType() throws Exception {
        boolean returned = true;
        String functionName = "supportResultSetType";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        returned = false;
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportsTransactionIsolationLevel() throws Exception {
        boolean returned = false;
        String functionName = "supportsTransactionIsolationLevel";
        Object[] params = new Object[]{new Integer(1)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testDeletesAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "deletesAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testInsertsAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "insertsAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testUpdatesAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "updatesAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOwnUpdatesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "ownUpdatesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOwnInsertsAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "ownInsertsAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersUpdatesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersUpdatesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersInsertsAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersInsertsAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersDeletesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersDeletesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportsConvert1() throws Exception {
        Assert.assertEquals((String)"Expected doesn't match with actual for method - supportsConvert()", (Object)true, (Object)this.dbmd.supportsConvert());
    }

    @Test
    public void testSupportsConvert2() throws Exception {
        this.helpTestSupportsConverts(1, 1, true);
        this.helpTestSupportsConverts(1, 12, true);
        this.helpTestSupportsConverts(1, -1, true);
        this.helpTestSupportsConverts(1, -7, true);
        this.helpTestSupportsConverts(1, 5, true);
        this.helpTestSupportsConverts(1, -6, true);
        this.helpTestSupportsConverts(1, 4, true);
        this.helpTestSupportsConverts(1, -5, true);
        this.helpTestSupportsConverts(1, 6, true);
        this.helpTestSupportsConverts(1, 7, true);
        this.helpTestSupportsConverts(1, 8, true);
        this.helpTestSupportsConverts(1, 2, true);
        this.helpTestSupportsConverts(1, 3, true);
        this.helpTestSupportsConverts(1, 91, true);
        this.helpTestSupportsConverts(1, 92, true);
        this.helpTestSupportsConverts(1, 93, true);
        this.helpTestSupportsConverts(91, 4, false);
        this.helpTestSupportsConverts(1, -5, true);
        this.helpTestSupportsConverts(1, 6, true);
        this.helpTestSupportsConverts(1, 7, true);
    }

    private void initResultSetStreams(String testName) throws FileNotFoundException {
        File expected = new File(UnitTestUtil.getTestDataPath() + "/TestMMDatabaseMetaData/" + testName + ".expected");
        this.expectedIn = new BufferedReader(new FileReader(expected));
        PrintStream defaultStream = null;
        this.stream = ResultSetUtil.getPrintStream((OutputStream)this.actualOut, (BufferedReader)this.expectedIn, defaultStream);
    }

    private void closeResultSetTestStreams() throws IOException {
        this.stream.close();
        if (this.actualOut != null) {
            this.actualOut.close();
        }
        if (this.expectedIn != null) {
            this.expectedIn.close();
        }
    }

    public void checkColumn(String expectedName, short nullable, Class type, String metadataName, Object value) {
        if (nullable == 0) {
            Assert.assertNull((String)("Column " + expectedName + " should always be null but was: " + value), (Object)value);
        }
        if (nullable == 1) {
            Assert.assertNotNull((String)("Column " + expectedName + " should never be null but was"), (Object)value);
        }
        if (value != null) {
            Assert.assertTrue((String)("Column " + expectedName + " is of wrong type"), (boolean)value.getClass().isAssignableFrom(type));
        }
        Assert.assertEquals((String)"Got incorrect column name", (Object)expectedName, (Object)metadataName);
    }

    public void checkNullConstant(Object value) {
        Assert.assertNotNull((String)"Got null nullability constant", (Object)value);
        Assert.assertTrue((String)("Nullability constant is wrong type: " + value.getClass()), (boolean)value.getClass().equals(Integer.class));
        Integer intValue = (Integer)value;
        Assert.assertTrue((String)("Got invalid nullability constant: " + value), (intValue == 0 || intValue == 1 || intValue == 2 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUcaseMatchReturnsNoRows() throws Exception {
        this.initResultSetStreams("testGetColumnsSingleMatchQuery");
        ResultSet rs = null;
        try {
            Statement stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT Name FROM System.Groups WHERE UCASE(ModelName) = 'SYSTEM'");
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)25L, (long)count);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetColumnsSingleMatch() throws Exception {
        this.initResultSetStreams("testGetColumnsSingleMatch");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getColumns(null, null, "System.VirtualDatabases", "Name");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCatalogs() throws Exception {
        this.initResultSetStreams("testGetCatalogs");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getCatalogs();
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCrossReference() throws Exception {
        this.initResultSetStreams("testGetCrossReference");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getCrossReference1");
            rs = dbmd.getCrossReference(null, null, "BQT1.SmallA", null, null, "BQT1.SmallB");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getCrossReference2");
        rs = this.dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getCrossReference3");
        rs = this.dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetImportedKeys() throws Exception {
        this.initResultSetStreams("testGetImportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getImportedKeys1");
            rs = dbmd.getImportedKeys(null, null, "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getImportedKeys2");
        rs = this.dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getImportedKeys3");
        rs = this.dbmd.getImportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetExportedKeys() throws Exception {
        this.initResultSetStreams("testGetExportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getExportedKeys(null, null, "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getExportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetIndexInfo() throws Exception {
        this.initResultSetStreams("testGetIndexInfo");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getIndexInfo(null, null, "System.KeyElements", true, true);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getIndexInfo(null, "Foo%", "%", true, false);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getIndexInfo("foo", "Foo%", "%", true, false);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPrimaryKeys() throws Exception {
        this.initResultSetStreams("testGetPrimaryKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getPrimaryKeys(null, null, "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getPrimaryKeys(null, "Foo%", "BQT1.SmallA");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getPrimaryKeys("foo", "Foo%", "BQT1.SmallA");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcedureColumns() throws Exception {
        this.initResultSetStreams("testGetProcedureColumns");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getProcedureColumns(null, null, null, null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getProcedureColumns(null, "Foo%", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getProcedureColumns("foo", "Foo%", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcedures() throws Exception {
        this.initResultSetStreams("testGetProcedures");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getProcedures(null, null, null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getProcedures(null, "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getProcedures("foo", "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSchemas() throws Exception {
        this.initResultSetStreams("testGetSchemas");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getSchemas();
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        this.initResultSetStreams("testGetColumns");
        DatabaseMetaData dbmd = conn.getMetaData();
        this.stream.println("getColumns1");
        ResultSet rs = dbmd.getColumns(null, null, null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumns2() throws Exception {
        this.initResultSetStreams("testGetColumns2");
        DatabaseMetaData dbmd = conn.getMetaData();
        this.stream.println("getColumns2");
        ResultSet rs = dbmd.getColumns(null, "QT_Ora%", "%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumns3() throws Exception {
        this.initResultSetStreams("testGetColumns3");
        DatabaseMetaData dbmd = conn.getMetaData();
        this.stream.println("getColumns3");
        ResultSet rs = dbmd.getColumns(null, "Foo%", "%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumns4() throws Exception {
        this.initResultSetStreams("testGetColumns4");
        DatabaseMetaData dbmd = conn.getMetaData();
        this.stream.println("getColumns4");
        ResultSet rs = dbmd.getColumns("foo", "Foo%", "%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumnPrivileges() throws Exception {
        this.initResultSetStreams("testGetColumnPrivileges");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumnPrivileges(null, "Parts", "%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs = dbmd.getColumnPrivileges(null, "%foo", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getColumnPrivileges("foo", "%foo", null, null);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumnPrivilegesResultSetMetaData() throws Exception {
        this.initResultSetStreams("testGetColumnPrivilegesResultSetMetaData");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumnPrivileges(null, "Parts", "%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetTablePrivileges() throws Exception {
        this.initResultSetStreams("testGetTablePrivileges");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTablePrivileges(null, "Parts", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetTablePrivilegesResultSetMetaData() throws Exception {
        this.initResultSetStreams("testGetTablePrivilegesResultSetMetaData");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTablePrivileges(null, "Parts", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTables_specificTable() throws Exception {
        this.initResultSetStreams("testGetTables_specificTable");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, "SYSTEM.VIRTUALDATABASES", null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTables_specificTableTypes() throws Exception {
        this.initResultSetStreams("testGetTables_specificTableTypes");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            String[] tables = new String[]{"Table"};
            rs = dbmd.getTables(null, null, null, tables);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTables_specificTableMultipleTypes() throws Exception {
        this.initResultSetStreams("testGetTables_specificTableMultipleTypes");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            String[] tables = new String[]{"Table", "View"};
            rs = dbmd.getTables(null, null, null, tables);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    @Test
    public void testGetTables() throws Exception {
        this.initResultSetStreams("testGetTables");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, null, null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getTables(null, "%foo", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getTables("foo", "%foo", null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTables_allTables() throws Exception {
        this.initResultSetStreams("testGetTables_allTables");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, null, null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTableTypes() throws Exception {
        this.initResultSetStreams("testGetTableTypes");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTableTypes();
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTypeInfo_TotalNumber() throws Exception {
        this.initResultSetStreams("testGetTypeInfo_TotalNumber");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTypeInfo();
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTypeInfo_specificType_Integer() throws Exception {
        this.initResultSetStreams("testGetTypeInfo_specificType_Integer");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTypeInfo();
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    @Test
    public void testGetUDTs() throws Exception {
        this.initResultSetStreams("testGetUDTs");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getUDTs(null, null, "%blob%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getUDTs(null, "%foo", "%blob%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getUDTs("foo", "%foo", "%blob%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetUDTs_specificTypeName() throws Exception {
        this.initResultSetStreams("testGetUDTs_specificTypeName");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getUDTs(null, null, "%blob%", null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.closeResultSetTestStreams();
        }
    }

    @Test
    public void testGetVersionColumns() throws Exception {
        this.initResultSetStreams("testGetVersionColumns");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getVersionColumns(null, null, null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs = dbmd.getVersionColumns(null, "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = dbmd.getVersionColumns("foo", "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBestRowIdentifier() throws Exception {
        this.initResultSetStreams("testGetBestRowIdentifier");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getBestRowIdentifier(null, null, "SYSTEM.VIRTUALDATABASES", 0, true);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getBestRowIdentifier(null, "%foo", null, 1, true);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getBestRowIdentifier("foo", "%foo", null, 1, true);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetSuperTables() throws Exception {
        this.initResultSetStreams("testSuperTables");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSuperTables(null, "Parts", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetSuperTypes() throws Exception {
        this.initResultSetStreams("testGetSuperTypes");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSuperTypes(null, "Parts", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    @Test
    public void testGetColumnsWithEscape() throws Exception {
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet columns = dbmd.getColumns(null, "QT\\_Ora9DS", "BQT1.SmallA", "IntKey");
        columns.next();
        Assert.assertEquals((Object)"QT_Ora9DS", (Object)columns.getString(2));
        Assert.assertFalse((boolean)columns.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCrossReferenceWithEscape() throws Exception {
        this.initResultSetStreams("testGetCrossReference");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getCrossReference1");
            rs = dbmd.getCrossReference(null, "QT\\_Ora9DS", "BQT1.SmallA", null, null, "BQT1.SmallB");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getCrossReference2");
        rs = this.dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getCrossReference3");
        rs = this.dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetExportedKeysWithEscape() throws Exception {
        this.initResultSetStreams("testGetExportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getExportedKeys(null, "QT\\_Ora9DS", "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getExportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetImportedKeysWithEscape() throws Exception {
        this.initResultSetStreams("testGetImportedKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.stream.println("getImportedKeys1");
            rs = dbmd.getImportedKeys(null, "QT\\_Ora9DS", "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.stream.println("getImportedKeys2");
        rs = this.dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        this.stream.println("getImportedKeys3");
        rs = this.dbmd.getImportedKeys("foo", "Foo%", "%");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetIndexInfoWithEscape() throws Exception {
        this.initResultSetStreams("testGetIndexInfo");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getIndexInfo(null, "QT\\_Ora9DS", "System.KeyElements", true, true);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getIndexInfo(null, "Foo%", "%", true, false);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getIndexInfo("foo", "Foo%", "%", true, false);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPrimaryKeysWithEscape() throws Exception {
        this.initResultSetStreams("testGetPrimaryKeys");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getPrimaryKeys(null, "QT\\_Ora9DS", "BQT1.SmallA");
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getPrimaryKeys(null, "Foo%", "BQT1.SmallA");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getPrimaryKeys("foo", "Foo%", "BQT1.SmallA");
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProceduresWithEscape() throws Exception {
        this.initResultSetStreams("testGetProcedures");
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getProcedures(null, "QT\\_Ora9DS", null);
            ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = this.dbmd.getProcedures(null, "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        rs.close();
        rs = this.dbmd.getProcedures("foo", "Foo%", null);
        ResultSetUtil.printResultSet((ResultSet)rs, (int)65, (boolean)true, (PrintStream)this.stream);
        Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)this.stream));
        rs.close();
        this.closeResultSetTestStreams();
    }

    private void helpTestSupportsConverts(int from, int to, boolean result) throws Exception {
        Assert.assertEquals((String)"Expected doesn't match with actual for method - supportsConvert()", (Object)result, (Object)this.dbmd.supportsConvert(from, to));
    }

    private void helpTestMethodsWithParams(String methodName, boolean returned, Object[] params) throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            Object actual = methods[i].invoke((Object)this.dbmd, params);
            Assert.assertEquals((String)("Expected doesn't match with actual for method - " + methodName), (Object)new Boolean(returned), (Object)actual);
        }
    }

    private Map getExpected() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("allProceduresAreCallable", Boolean.TRUE);
        expected.put("allTablesAreSelectable", Boolean.TRUE);
        expected.put("doesMaxRowSizeIncludeBlobs", Boolean.FALSE);
        expected.put("isCatalogAtStart", Boolean.FALSE);
        expected.put("isReadOnly", Boolean.FALSE);
        expected.put("locatorsUpdateCopy", Boolean.FALSE);
        expected.put("nullPlusNonNullIsNull", Boolean.TRUE);
        expected.put("nullsAreSortedAtEnd", Boolean.FALSE);
        expected.put("nullsAreSortedAtStart", Boolean.FALSE);
        expected.put("nullsAreSortedHigh", Boolean.FALSE);
        expected.put("nullsAreSortedLow", Boolean.TRUE);
        expected.put("storesLowerCaseIdentifiers", Boolean.FALSE);
        expected.put("storesLowerCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseIdentifiers", Boolean.TRUE);
        expected.put("storesMixedCaseQuotedIdentifiers", Boolean.TRUE);
        expected.put("storesUpperCaseIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsAlterTableWithAddColumn", Boolean.FALSE);
        expected.put("supportsAlterTableWithDropColumn", Boolean.FALSE);
        expected.put("supportsANSI92EntryLevelSQL", Boolean.FALSE);
        expected.put("supportsANSI92FullSQL", Boolean.FALSE);
        expected.put("supportsANSI92IntermediateSQL", Boolean.FALSE);
        expected.put("supportsBatchUpdates", Boolean.TRUE);
        expected.put("supportsCatalogsInDataManipulation", Boolean.FALSE);
        expected.put("supportsCatalogsInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInProcedureCalls", Boolean.FALSE);
        expected.put("supportsCatalogsInTableDefinitions", Boolean.FALSE);
        expected.put("supportsColumnAliasing", Boolean.TRUE);
        expected.put("supportsCorrelatedSubqueries", Boolean.TRUE);
        expected.put("supportsCoreSQLGrammar", Boolean.FALSE);
        expected.put("supportsDataDefinitionAndDataManipulationTransactions", Boolean.FALSE);
        expected.put("supportsDataManipulationTransactionsOnly", Boolean.FALSE);
        expected.put("supportsDifferentTableCorrelationNames", Boolean.FALSE);
        expected.put("supportsExpressionsInOrderBy", Boolean.FALSE);
        expected.put("supportsExtendedSQLGrammar", Boolean.FALSE);
        expected.put("supportsFullOuterJoins", Boolean.TRUE);
        expected.put("supportsGetGeneratedKeys", Boolean.FALSE);
        expected.put("supportsGroupBy", Boolean.TRUE);
        expected.put("supportsGroupByBeyondSelect", Boolean.TRUE);
        expected.put("supportsGroupByUnrelated", Boolean.FALSE);
        expected.put("supportsIntegrityEnhancementFacility", Boolean.FALSE);
        expected.put("supportsLikeEscapeClause", Boolean.TRUE);
        expected.put("supportsLimitedOuterJoins", Boolean.TRUE);
        expected.put("supportsMinimumSQLGrammar", Boolean.TRUE);
        expected.put("supportsMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("supportsMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossCommit", Boolean.FALSE);
        expected.put("supportsMultipleResultSets", Boolean.FALSE);
        expected.put("supportsMultipleOpenResults", Boolean.FALSE);
        expected.put("supportsMultipleTransactions", Boolean.TRUE);
        expected.put("supportsNamedParameters", Boolean.FALSE);
        expected.put("supportsNonNullableColumns", Boolean.TRUE);
        expected.put("supportsOpenCursorsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossCommit", Boolean.TRUE);
        expected.put("supportsOpenStatementsAcrossRollback", Boolean.TRUE);
        expected.put("supportsOrderByUnrelated", Boolean.FALSE);
        expected.put("supportsOuterJoins", Boolean.TRUE);
        expected.put("supportsPositionedDelete", Boolean.FALSE);
        expected.put("supportsPositionedUpdate", Boolean.FALSE);
        expected.put("supportsSavepoints", Boolean.FALSE);
        expected.put("supportsSchemasInDataManipulation", Boolean.TRUE);
        expected.put("supportsSchemasInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInProcedureCalls", Boolean.TRUE);
        expected.put("supportsSchemasInTableDefinitions", Boolean.FALSE);
        expected.put("supportsSelectForUpdate", Boolean.FALSE);
        expected.put("supportsStatementPooling", Boolean.FALSE);
        expected.put("supportsStoredProcedures", Boolean.TRUE);
        expected.put("supportsSubqueriesInComparisons", Boolean.TRUE);
        expected.put("supportsSubqueriesInExists", Boolean.TRUE);
        expected.put("supportsSubqueriesInIns", Boolean.TRUE);
        expected.put("supportsSubqueriesInQuantifieds", Boolean.TRUE);
        expected.put("supportsTableCorrelationNames", Boolean.TRUE);
        expected.put("supportsTransactions", Boolean.TRUE);
        expected.put("supportsUnion", Boolean.TRUE);
        expected.put("supportsUnionAll", Boolean.TRUE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("usesLocalFiles", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("getDatabaseMinorVersion", new Integer(ApplicationInfo.getInstance().getMinorReleaseVersion()));
        expected.put("getDatabaseMajorVersion", new Integer(ApplicationInfo.getInstance().getMajorReleaseVersion()));
        expected.put("getJDBCMajorVersion", new Integer(3));
        expected.put("getJDBCMinorVersion", new Integer(0));
        expected.put("getDefaultTransactionIsolation", new Integer(0));
        expected.put("getDriverMajorVersion", new Integer(ApplicationInfo.getInstance().getMajorReleaseVersion()));
        expected.put("getDriverMinorVersion", new Integer(ApplicationInfo.getInstance().getMinorReleaseVersion()));
        expected.put("getMaxBinaryLiteralLength", new Integer(0));
        expected.put("getMaxCatalogNameLength", new Integer(0));
        expected.put("getMaxCharLiteralLength", new Integer(0));
        expected.put("getMaxColumnNameLength", new Integer(255));
        expected.put("getMaxColumnsInGroupBy", new Integer(0));
        expected.put("getMaxColumnsInIndex", new Integer(0));
        expected.put("getMaxColumnsInOrderBy", new Integer(0));
        expected.put("getMaxColumnsInSelect", new Integer(0));
        expected.put("getMaxColumnsInTable", new Integer(0));
        expected.put("getMaxConnections", new Integer(0));
        expected.put("getMaxCursorNameLength", new Integer(0));
        expected.put("getMaxIndexLength", new Integer(0));
        expected.put("getMaxProcedureNameLength", new Integer(255));
        expected.put("getMaxRowSize", new Integer(0));
        expected.put("getMaxSchemaNameLength", new Integer(0));
        expected.put("getMaxStatementLength", new Integer(0));
        expected.put("getMaxStatements", new Integer(0));
        expected.put("getMaxTableNameLength", new Integer(255));
        expected.put("getMaxTablesInSelect", new Integer(0));
        expected.put("getMaxUserNameLength", new Integer(255));
        expected.put("getSQLStateType", new Integer(2));
        expected.put("getCatalogSeparator", "");
        expected.put("getCatalogTerm", "");
        expected.put("getDatabaseProductName", "MetaMatrix Query");
        expected.put("getDatabaseProductVersion", "5.5");
        expected.put("getDriverName", "MetaMatrix Query JDBC Driver");
        expected.put("getDriverVersion", ApplicationInfo.getInstance().getMajorReleaseVersion() + "." + ApplicationInfo.getInstance().getMinorReleaseVersion());
        expected.put("getExtraNameCharacters", ".@");
        expected.put("getIdentifierQuoteString", "\"");
        expected.put("getNumericFunctions", "ABS, ACOS, ASIN, ATAN, ATAN2, BITAND, BITNOT, BITOR, BITXOR, CEILING, COS, COT, DEGREES, EXP, FLOOR, FORMATBIGDECIMAL, FORMATBIGINTEGER, FORMATDOUBLE, FORMATFLOAT, FORMATINTEGER, FORMATLONG, LOG, LOG10, MOD, PARSEBIGDECIMAL, PARSEBIGINTEGER, PARSEDOUBLE, PARSEFLOAT, PARSEINTEGER, PARSELONG, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN");
        expected.put("getProcedureTerm", "StoredProcedure");
        expected.put("getSchemaTerm", "VirtualDatabase");
        expected.put("getSearchStringEscape", "\\");
        expected.put("getSQLKeywords", KEY_WORDS);
        expected.put("getStringFunctions", "ASCII, CHR, CHAR, CONCAT, CONCAT2, INITCAP, INSERT, LCASE, LEFT, LENGTH, LOCATE, LOWER, LPAD, LTRIM, REPEAT, REPLACE, RIGHT, RPAD, RTRIM, SUBSTRING, TRANSLATE, UCASE, UPPER");
        expected.put("getSystemFunctions", "CAST, COALESCE, CONVERT, DECODESTRING, DECODEINTEGER, IFNULL, NULLIF, NVL, LOOKUP");
        expected.put("getTimeDateFunctions", "CURDATE, CURTIME, NOW, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, FORMATDATE, FORMATTIME, FORMATTIMESTAMP, FROM_UNIXTIME, HOUR, MINUTE, MONTH, MONTHNAME, PARSEDATE, PARSETIME, PARSETIMESTAMP, QUARTER, SECOND, TIMESTAMPADD, TIMESTAMPDIFF, WEEK, YEAR");
        expected.put("getUserName", null);
        expected.put("getConnection", conn);
        return expected;
    }
}

