/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.integration;

import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerFactory;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.metadata.runtime.VDBMetadataFactory;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.TestOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.util.CommandContext;
import java.sql.SQLXML;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class BaseQueryTest
extends TestCase {
    public BaseQueryTest(String name) {
        super(name);
    }

    public static QueryMetadataInterface createMetadata(String vdbFile) {
        return VDBMetadataFactory.getVDBMetadata((String)vdbFile);
    }

    public static QueryMetadataInterface createMetadata(String vdbFile, String systemVDBFile) {
        return VDBMetadataFactory.getVDBMetadata((String[])new String[]{vdbFile, systemVDBFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorPlan createPlan(QueryMetadataInterface metadata, String sql, CapabilitiesFinder capFinder, boolean debug) throws Exception {
        Command command = TestOptimizer.helpGetCommand((String)sql, (QueryMetadataInterface)metadata, null);
        AnalysisRecord analysisRecord = new AnalysisRecord(false, debug, debug);
        ProcessorPlan plan = null;
        try {
            plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, (CommandContext)this.createCommandContext(null, command));
        }
        finally {
            if (debug) {
                System.out.println(analysisRecord.getDebugLog());
            }
        }
        return plan;
    }

    protected void doProcess(ProcessorPlan plan, ProcessorDataManager dataManager, List[] expectedResults, boolean debug) throws Exception {
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        TupleSourceID tsID = bufferMgr.createTupleSource(plan.getOutputElements(), null, "test", BufferManager.TupleSourceType.FINAL);
        CommandContext context = this.createCommandContext(tsID, null);
        context.setProcessDebug(debug);
        QueryProcessor processor = new QueryProcessor(plan, context, bufferMgr, dataManager);
        processor.process();
        IndexedTupleSource ts = bufferMgr.getTupleSource(tsID);
        int count = bufferMgr.getFinalRowCount(tsID);
        if (debug) {
            System.out.println("\nResults:\n" + bufferMgr.getTupleSchema(tsID));
            IndexedTupleSource ts2 = bufferMgr.getTupleSource(tsID);
            for (int j = 0; j < count; ++j) {
                System.out.println("" + j + ": " + ts2.nextTuple());
            }
            ts2.closeSource();
        }
        BaseQueryTest.assertEquals((String)"Did not get expected row count: ", (int)expectedResults.length, (int)count);
        for (int i = 0; i < count; ++i) {
            List record = ts.nextTuple();
            Object value = record.get(0);
            if (value instanceof SQLXML) {
                record.set(0, ((SQLXML)value).getString());
            }
            BaseQueryTest.assertEquals(expectedResults[i].get(0), record.get(0));
        }
        ts.closeSource();
        bufferMgr.removeTupleSource(tsID);
    }

    protected void doProcessNoResultsCheck(ProcessorPlan plan, ProcessorDataManager dataManager, int expectedRowCount, boolean debug) throws Exception {
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        TupleSourceID tsID = bufferMgr.createTupleSource(plan.getOutputElements(), null, "test", BufferManager.TupleSourceType.FINAL);
        CommandContext context = this.createCommandContext(tsID, null);
        QueryProcessor processor = new QueryProcessor(plan, context, bufferMgr, dataManager);
        processor.process();
        IndexedTupleSource ts = bufferMgr.getTupleSource(tsID);
        int count = bufferMgr.getFinalRowCount(tsID);
        if (debug) {
            System.out.println("\nResults:\n" + bufferMgr.getTupleSchema(tsID));
            IndexedTupleSource ts2 = bufferMgr.getTupleSource(tsID);
            for (int j = 0; j < count; ++j) {
                System.out.println("" + j + ": " + ts2.nextTuple());
            }
            ts2.closeSource();
        }
        BaseQueryTest.assertEquals((String)"Did not get expected row count: ", (int)expectedRowCount, (int)count);
        for (int i = 0; i < count; ++i) {
            ts.nextTuple();
        }
        ts.closeSource();
        bufferMgr.removeTupleSource(tsID);
    }

    protected CommandContext createCommandContext(TupleSourceID tsID, Command command) {
        Properties props = new Properties();
        CommandContext context = new CommandContext((Object)"0", "test", tsID, 5, "user", null, null, "myvdb", "1", props, false, false);
        return context;
    }

    public void verifyQueryPlan(String[] expectedAtomic, ProcessorPlan plan, QueryMetadataInterface md, CapabilitiesFinder capFinder) throws Exception {
        TestOptimizer.checkAtomicQueries((String[])expectedAtomic, (ProcessorPlan)plan, (QueryMetadataInterface)md, (CapabilitiesFinder)capFinder);
    }
}

