/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.integration;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.FakeCapabilitiesFinder;
import com.metamatrix.query.processor.HardcodedDataManager;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.unittest.TimestampUtil;
import com.metamatrix.server.integration.BaseQueryTest;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.teiid.connector.api.ConnectorCapabilities;
import org.teiid.connector.jdbc.oracle.OracleCapabilities;
import org.teiid.dqp.internal.datamgr.CapabilitiesConverter;

public class TestXMLTypeTranslations
extends BaseQueryTest {
    private static final boolean DEBUG = false;

    public TestXMLTypeTranslations(String name) {
        super(name);
    }

    public void testXSDTranslations() throws Exception {
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("sample", CapabilitiesConverter.convertCapabilities((ConnectorCapabilities)new OracleCapabilities()));
        QueryMetadataInterface metadata = TestXMLTypeTranslations.createMetadata(UnitTestUtil.getTestDataPath() + "/xmltypes/test.vdb");
        String sql = "select * from testdocument.testDocument";
        ProcessorPlan plan = this.createPlan(metadata, sql, (CapabilitiesFinder)finder, false);
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        HashSet<String> models = new HashSet<String>();
        models.add("sample");
        dataMgr.setValidModels(models);
        dataMgr.addData("SELECT g_0.\"timestamp\", g_0.\"double\", g_0.\"float\", convert(g_0.\"double\", biginteger), convert(g_0.\"double\", biginteger), convert(g_0.\"date\", timestamp), convert(g_0.\"double\", biginteger), convert(g_0.\"date\", timestamp), '1' FROM sample.RUNTIMEVALUE AS g_0", new List[]{Arrays.asList(TimestampUtil.createTimestamp((int)3, (int)3, (int)4, (int)5, (int)6, (int)10, (int)200), new Double(Double.NEGATIVE_INFINITY), new Float(Float.POSITIVE_INFINITY), new BigInteger("100"), new BigInteger("100"), TimestampUtil.createTimestamp((int)3, (int)3, (int)4, (int)5, (int)6, (int)7, (int)0), new BigInteger("100"), TimestampUtil.createTimestamp((int)3, (int)3, (int)4, (int)5, (int)6, (int)7, (int)0), "1")});
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><XSDTypesNS:test xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:XSDTypesNS=\"http://www.metamatrix.com/XMLSchema/DataSets/XSDTypes\"><book><datetime>1903-04-04T05:06:10.0000002</datetime><double>-INF</double><float>INF</float><gday>---100</gday><gmonth>--100</gmonth><gmonthday>--04-04</gmonthday><gyear>0100</gyear><gyearmonth>1903-04</gyearmonth><string>1</string></book></XSDTypesNS:test>")};
        this.doProcess(plan, (ProcessorDataManager)dataMgr, expected, false);
    }
}

