/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.systemmodel;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.api.AbstractMMQueryTestCase;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.junit.Before;
import org.junit.Test;

public class TestPartsDatabaseMetadata
extends AbstractMMQueryTestCase {
    private static final String DQP_PROP_FILE = UnitTestUtil.getTestDataPath() + "/partssupplier/dqp.properties";
    private static final String VDB = "PartsSupplier";
    static DatabaseMetaData dbMetadata;
    static Connection connection;

    public TestPartsDatabaseMetadata() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws SQLException {
        this.getConnection(VDB, DQP_PROP_FILE);
        dbMetadata = this.internalConnection.getMetaData();
    }

    private void checkResult(String testName, ResultSet actualResults) throws Exception {
        ResultSetMetaData resultMetadata = actualResults.getMetaData();
        String metafilename = UnitTestUtil.getTestDataPath() + File.separator + "partssupplier" + File.separator + "expected" + File.separator + testName.substring(4) + ".metadata.txt";
        this.assertResultsSetMetadataEquals(resultMetadata, new File(metafilename));
        String filename = UnitTestUtil.getTestDataPath() + File.separator + "partssupplier" + File.separator + "expected" + File.separator + testName.substring(4) + ".txt";
        this.assertResultsSetEquals(actualResults, new File(filename));
    }

    @Test
    public void testExportedKeys() throws Exception {
        this.checkResult("testExportedKeys", dbMetadata.getExportedKeys(null, VDB, "%"));
    }

    @Test
    public void testImportedKeys() throws Exception {
        this.checkResult("testImportedKeys", dbMetadata.getImportedKeys(null, VDB, "%"));
    }

    @Test
    public void testPrimaryKeys() throws Exception {
        this.checkResult("testPrimaryKeys", dbMetadata.getPrimaryKeys(null, VDB, "%"));
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", dbMetadata.getProcedures(null, VDB, "%"));
    }

    @Test
    public void testProcedureColumns() throws Exception {
        this.checkResult("testProcedureColumns", dbMetadata.getProcedureColumns(null, VDB, "%", "%"));
    }

    @Test
    public void testUDTs() throws Exception {
        this.checkResult("testUDTs", dbMetadata.getUDTs(null, VDB, "%", null));
    }

    @Test
    public void testIndexInfo() throws Exception {
        this.checkResult("testIndexInfo", dbMetadata.getIndexInfo(null, VDB, "%", true, true));
    }

    @Test
    public void testCrossReference() throws Exception {
        this.checkResult("testCrossReference", dbMetadata.getCrossReference(null, VDB, "%", null, VDB, "%"));
    }

    @Test
    public void testTypeInfo() throws Exception {
        this.checkResult("testTypeInfo", dbMetadata.getTypeInfo());
    }

    @Test
    public void testCatalogs() throws Exception {
        this.checkResult("testCatalogs", dbMetadata.getCatalogs());
    }

    @Test
    public void testSchemas() throws Exception {
        this.checkResult("testSchemas", dbMetadata.getSchemas());
    }

    @Test
    public void testTables() throws Exception {
        this.checkResult("testTables", dbMetadata.getTables(null, VDB, "%", null));
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", dbMetadata.getColumns(null, VDB, "%", "%"));
    }
}

