/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.systemmodel;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.api.AbstractMMQueryTestCase;
import java.sql.ResultSet;
import org.junit.Before;
import org.junit.Test;

public class TestResultSetMetadata
extends AbstractMMQueryTestCase {
    private static final String DQP_PROP_FILE = UnitTestUtil.getTestDataPath() + "/partssupplier/dqp.properties";
    private static final String VDB = "PartsSupplier";

    public TestResultSetMetadata() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() {
        this.getConnection(VDB, DQP_PROP_FILE);
    }

    private void executeTest(String sql, String[] expected) throws Exception {
        this.execute(sql);
        ResultSet rs = this.internalResultSet;
        this.assertResultsSetMetadataEquals(rs.getMetaData(), expected);
    }

    private void executePreparedTest(String sql, String[] expected) throws Exception {
        this.execute(sql, new Object[0]);
        ResultSet rs = this.internalResultSet;
        this.assertResultsSetMetadataEquals(rs.getMetaData(), expected);
    }

    @Test
    public void testCount() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tPartsSupplier\tnull"};
        this.executeTest("select count(*) from parts", expected);
    }

    @Test
    public void testStar() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_NAME\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull"};
        this.executeTest("select * from parts", expected);
    }

    @Test
    public void testTempGroupStar() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tFOO\tPartsSupplier\tnull", "PART_NAME\t12\tstring\tjava.lang.String\t1\tFOO\tPartsSupplier\tnull", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tFOO\tPartsSupplier\tnull", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tFOO\tPartsSupplier\tnull"};
        this.executeTest("select * from (select * from parts) foo", expected);
    }

    @Test
    public void testCountAndElement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tPartsSupplier\tnull", "part_name\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull"};
        this.executeTest("select count(*), part_name from parts group by part_name", expected);
    }

    @Test
    public void testStar_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "PART_ID\t12\tstring\tjava.lang.String\t0\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_NAME\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_COLOR\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull", "PART_WEIGHT\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull"};
        this.executePreparedTest("select * from parts", expected);
    }

    @Test
    public void testCount_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tPartsSupplier\tnull"};
        this.executePreparedTest("select count(*) from parts", expected);
    }

    @Test
    public void testCountAndElement_PreparedStatement() throws Exception {
        String[] expected = new String[]{"ColumnName\tColumnType\tColumnTypeName\tColumnClassName\tisNullable\tTableName\tSchemaName\tCatalogName", "count\t4\tinteger\tjava.lang.Integer\t1\tnull\tPartsSupplier\tnull", "part_name\t12\tstring\tjava.lang.String\t1\tPartsSupplier.PARTSSUPPLIER.PARTS\tPartsSupplier\tnull"};
        this.executePreparedTest("select count(*), part_name from parts group by part_name", expected);
    }
}

