/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.systemmodel;

import com.metamatrix.cdk.IConnectorHost;
import com.metamatrix.cdk.api.ConnectorHost;
import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.connector.metadata.IndexConnector;
import com.metamatrix.metadata.runtime.FakeMetadataService;
import com.metamatrix.metadata.runtime.VDBMetadataFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.teiid.connector.api.Connector;

public class TestSystemPhysicalModel
extends TestCase {
    static FakeMetadataService metadataService = null;
    static IConnectorHost host = null;

    static IConnectorHost loadConnectorHost() throws Exception {
        TranslationUtility utility = new TranslationUtility(VDBMetadataFactory.getVDBMetadata((URL)Thread.currentThread().getContextClassLoader().getResource("System.vdb")));
        ConnectorHost host = new ConnectorHost((Connector)new IndexConnector(), null, utility);
        metadataService = new FakeMetadataService(Thread.currentThread().getContextClassLoader().getResource("System.vdb"));
        host.addResourceToConnectorEnvironment("dqp.metadata", (Object)metadataService);
        host.setSecurityContext("testName", "testVersion", "testUser", null);
        return host;
    }

    static void oneTimeTearDown() throws Exception {
        if (metadataService != null) {
            metadataService.clear();
        }
    }

    static void oneTimeSetUp() throws Exception {
        host = TestSystemPhysicalModel.loadConnectorHost();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestSystemPhysicalModel.class);
        return TestSystemPhysicalModel.createOnceRunSuite(suite);
    }

    public static TestSetup createOnceRunSuite(TestSuite suite) {
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TestSystemPhysicalModel.oneTimeSetUp();
            }

            protected void tearDown() throws Exception {
                TestSystemPhysicalModel.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private void execute(String query) throws Exception {
        this.execute(query, null);
    }

    private void execute(String query, String[] expected) throws Exception {
        List results = host.executeCommand(query);
        if (expected != null) {
            int i = 0;
            for (ArrayList result : results) {
                String resultStr = this.concat(result);
                TestSystemPhysicalModel.assertEquals((String)expected[i++], (String)resultStr);
            }
        }
    }

    private String concat(ArrayList list) {
        StringBuilder sb = new StringBuilder();
        for (Object msg : list) {
            sb.append(msg);
        }
        return sb.toString();
    }

    public void testSystemPhysical_ACCESS_PATTERNS_FULLNAME() throws Exception {
        String[] expected = new String[]{};
        this.execute("select FULLNAME from SystemPhysical.ACCESS_PATTERNS", expected);
    }

    public void testSystemPhysical_ACCESS_PATTERNS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_UUID_OF_TABLE() throws Exception {
        this.execute(" select UUID_OF_TABLE from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ACCESS_PATTERNS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.ACCESS_PATTERNS");
    }

    public void testSystemPhysical_ALL_KEYS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_KEY_TYPE() throws Exception {
        this.execute(" select KEY_TYPE from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_UUID_OF_TABLE() throws Exception {
        this.execute(" select UUID_OF_TABLE from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ALL_KEYS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.ALL_KEYS");
    }

    public void testSystemPhysical_ANNOTATIONS_ANNOTATED_UUID() throws Exception {
        this.execute(" select ANNOTATED_UUID from SystemPhysical.ANNOTATIONS");
    }

    public void testSystemPhysical_ANNOTATIONS_DESCRIPTION() throws Exception {
        this.execute(" select DESCRIPTION from SystemPhysical.ANNOTATIONS");
    }

    public void testSystemPhysical_COLUMNS_CHAR_OCTET_LENGTH() throws Exception {
        this.execute(" select CHAR_OCTET_LENGTH from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_DATATYPE_UUID() throws Exception {
        this.execute(" select DATATYPE_UUID from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_DEFAULT_VALUE() throws Exception {
        this.execute(" select DEFAULT_VALUE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_FORMAT() throws Exception {
        this.execute(" select FORMAT from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_AUTO_INCREMENTED() throws Exception {
        this.execute(" select IS_AUTO_INCREMENTED from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_CASE_SENSITIVE() throws Exception {
        this.execute(" select IS_CASE_SENSITIVE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_CURRENCY() throws Exception {
        this.execute(" select IS_CURRENCY from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_LENGTH_FIXED() throws Exception {
        this.execute(" select IS_LENGTH_FIXED from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_SELECTABLE() throws Exception {
        this.execute("select IS_SELECTABLE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_IS_SIGNED() throws Exception {
        this.execute(" select IS_SIGNED from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_LENGTH() throws Exception {
        this.execute(" select LENGTH from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_MAX_VALUE() throws Exception {
        this.execute(" select MAX_VALUE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_MIN_VALUE() throws Exception {
        this.execute(" select MIN_VALUE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_NULL_TYPE() throws Exception {
        this.execute(" select NULL_TYPE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_PARENT_NAME() throws Exception {
        this.execute(" select PARENT_NAME from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_PARENT_PATH() throws Exception {
        this.execute(" select PARENT_PATH from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_PARENT_UUID() throws Exception {
        this.execute(" select PARENT_UUID from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_POSITION() throws Exception {
        this.execute(" select POSITION from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_PRECISION() throws Exception {
        this.execute(" select PRECISION from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_RADIX() throws Exception {
        this.execute(" select RADIX from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_RUNTIME_TYPE_NAME() throws Exception {
        this.execute(" select RUNTIME_TYPE_NAME from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_SCALE() throws Exception {
        this.execute(" select SCALE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_SEARCH_TYPE() throws Exception {
        this.execute(" select SEARCH_TYPE from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_SUPPORTS_UPDATES() throws Exception {
        this.execute(" select SUPPORTS_UPDATES from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_COLUMNS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.COLUMNS");
    }

    public void testSystemPhysical_DATATYPES_BASETYPE_NAME() throws Exception {
        this.execute(" select BASETYPE_NAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_BASETYPE_URL() throws Exception {
        this.execute(" select BASETYPE_URL from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_IS_AUTO_INCREMENTED() throws Exception {
        this.execute(" select IS_AUTO_INCREMENTED from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_IS_BUILTIN() throws Exception {
        this.execute(" select IS_BUILTIN from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_IS_CASE_SENSITIVE() throws Exception {
        this.execute(" select IS_CASE_SENSITIVE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_IS_SIGNED() throws Exception {
        this.execute(" select IS_SIGNED from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_JAVA_CLASS_NAME() throws Exception {
        this.execute(" select JAVA_CLASS_NAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_LENGTH() throws Exception {
        this.execute(" select LENGTH from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_NULL_TYPE() throws Exception {
        this.execute(" select NULL_TYPE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_PRECISION() throws Exception {
        this.execute(" select PRECISION from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_RADIX() throws Exception {
        this.execute(" select RADIX from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_RUNTIME_TYPE_NAME() throws Exception {
        this.execute(" select RUNTIME_TYPE_NAME from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_SCALE() throws Exception {
        this.execute(" select SCALE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_SEARCH_TYPE() throws Exception {
        this.execute(" select SEARCH_TYPE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_TYPE() throws Exception {
        this.execute(" select TYPE from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_URL() throws Exception {
        this.execute(" select URL from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPES_VARIETY() throws Exception {
        this.execute(" select VARIETY from SystemPhysical.DATATYPES");
    }

    public void testSystemPhysical_DATATYPE_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.DATATYPE_TYPE_ENUM");
    }

    public void testSystemPhysical_DATATYPE_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.DATATYPE_TYPE_ENUM");
    }

    public void testSystemPhysical_DATATYPE_VARIETY_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.DATATYPE_VARIETY_ENUM");
    }

    public void testSystemPhysical_DATATYPE_VARIETY_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.DATATYPE_VARIETY_ENUM");
    }

    public void testSystemPhysical_DELETE_TRANS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.DELETE_TRANS");
    }

    public void testSystemPhysical_DELETE_TRANS_TRANSFORMATION() throws Exception {
        this.execute(" select TRANSFORMATION from SystemPhysical.DELETE_TRANS");
    }

    public void testSystemPhysical_DELETE_TRANS_TRANSFORMED_PATH() throws Exception {
        this.execute(" select TRANSFORMED_PATH from SystemPhysical.DELETE_TRANS");
    }

    public void testSystemPhysical_DELETE_TRANS_TRANSFORMED_UUID() throws Exception {
        this.execute(" select TRANSFORMED_UUID from SystemPhysical.DELETE_TRANS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_UUID_OF_PRIMARY_KEY() throws Exception {
        this.execute(" select UUID_OF_PRIMARY_KEY from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_UUID_OF_TABLE() throws Exception {
        this.execute(" select UUID_OF_TABLE from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_FOREIGN_KEYS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.FOREIGN_KEYS");
    }

    public void testSystemPhysical_INDEXES_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INDEXES_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.INDEXES");
    }

    public void testSystemPhysical_INSERT_TRANS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.INSERT_TRANS");
    }

    public void testSystemPhysical_INSERT_TRANS_TRANSFORMATION() throws Exception {
        this.execute(" select TRANSFORMATION from SystemPhysical.INSERT_TRANS");
    }

    public void testSystemPhysical_INSERT_TRANS_TRANSFORMED_PATH() throws Exception {
        this.execute(" select TRANSFORMED_PATH from SystemPhysical.INSERT_TRANS");
    }

    public void testSystemPhysical_INSERT_TRANS_TRANSFORMED_UUID() throws Exception {
        this.execute(" select TRANSFORMED_UUID from SystemPhysical.INSERT_TRANS");
    }

    public void testSystemPhysical_KEY_COLUMNS_COLUMN_UUID() throws Exception {
        this.execute(" select COLUMN_UUID from SystemPhysical.KEY_COLUMNS");
    }

    public void testSystemPhysical_KEY_COLUMNS_KEY_TYPE() throws Exception {
        this.execute(" select KEY_TYPE from SystemPhysical.KEY_COLUMNS");
    }

    public void testSystemPhysical_KEY_COLUMNS_KEY_UUID() throws Exception {
        this.execute(" select KEY_UUID from SystemPhysical.KEY_COLUMNS");
    }

    public void testSystemPhysical_KEY_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.KEY_TYPE_ENUM");
    }

    public void testSystemPhysical_KEY_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.KEY_TYPE_ENUM");
    }

    public void testSystemPhysical_MODELS_IS_PHYSICAL() throws Exception {
        this.execute(" select IS_PHYSICAL from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_IS_VISIBLE() throws Exception {
        this.execute(" select IS_VISIBLE from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_MAX_SET_SIZE() throws Exception {
        this.execute(" select MAX_SET_SIZE from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_MODEL_TYPE() throws Exception {
        this.execute(" select MODEL_TYPE from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_SUPPORTS_DISTINCT() throws Exception {
        this.execute(" select SUPPORTS_DISTINCT from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_SUPPORTS_JOIN() throws Exception {
        this.execute(" select SUPPORTS_JOIN from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_SUPPORTS_ORDER_BY() throws Exception {
        this.execute(" select SUPPORTS_ORDER_BY from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_SUPPORTS_OUTER_JOIN() throws Exception {
        this.execute(" select SUPPORTS_OUTER_JOIN from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_SUPPORTS_WHERE_ALL() throws Exception {
        this.execute(" select SUPPORTS_WHERE_ALL from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODELS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.MODELS");
    }

    public void testSystemPhysical_MODEL_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.MODEL_TYPE_ENUM");
    }

    public void testSystemPhysical_MODEL_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.MODEL_TYPE_ENUM");
    }

    public void testSystemPhysical_NULL_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.NULL_TYPE_ENUM");
    }

    public void testSystemPhysical_NULL_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.NULL_TYPE_ENUM");
    }

    public void testSystemPhysical_PRIMARY_KEYS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_MODEL_NAME() throws Exception {
        this.execute(" select * from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_UUID_OF_TABLE() throws Exception {
        this.execute(" select UUID_OF_TABLE from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PRIMARY_KEYS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.PRIMARY_KEYS");
    }

    public void testSystemPhysical_PROCS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_FUNCTION() throws Exception {
        this.execute(" select FUNCTION from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_PROC_TYPE() throws Exception {
        this.execute(" select PROC_TYPE from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_RESULT_SET_UUID() throws Exception {
        this.execute(" select RESULT_SET_UUID from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROCS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.PROCS");
    }

    public void testSystemPhysical_PROC_PARAMS_DATATYPE_UUID() throws Exception {
        this.execute(" select DATATYPE_UUID from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_DIRECTION() throws Exception {
        this.execute(" select DIRECTION from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_IS_OPTIONAL() throws Exception {
        this.execute(" select IS_OPTIONAL from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_LENGTH() throws Exception {
        this.execute(" select LENGTH from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_NULL_TYPE() throws Exception {
        this.execute(" select NULL_TYPE from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_POSITION() throws Exception {
        this.execute(" select POSITION from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_PRECISION() throws Exception {
        this.execute(" select PRECISION from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_PROC_NAME() throws Exception {
        this.execute(" select PROC_NAME from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_PROC_UUID() throws Exception {
        this.execute(" select PROC_UUID from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_RADIX() throws Exception {
        this.execute(" select RADIX from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_RUNTIME_TYPE_NAME() throws Exception {
        this.execute(" select RUNTIME_TYPE_NAME from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_SCALE() throws Exception {
        this.execute(" select SCALE from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAMS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.PROC_PARAMS");
    }

    public void testSystemPhysical_PROC_PARAM_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.PROC_PARAM_TYPE_ENUM");
    }

    public void testSystemPhysical_PROC_PARAM_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PROC_PARAM_TYPE_ENUM");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_PROC_NAME() throws Exception {
        this.execute(" select PROC_NAME from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_PROC_UUID() throws Exception {
        this.execute(" select PROC_UUID from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_RESULT_SETS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.PROC_RESULT_SETS");
    }

    public void testSystemPhysical_PROC_TRANS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.PROC_TRANS");
    }

    public void testSystemPhysical_PROC_TRANS_TRANSFORMATION() throws Exception {
        this.execute(" select TRANSFORMATION from SystemPhysical.PROC_TRANS");
    }

    public void testSystemPhysical_PROC_TRANS_TRANSFORMED_PATH() throws Exception {
        this.execute(" select TRANSFORMED_PATH from SystemPhysical.PROC_TRANS");
    }

    public void testSystemPhysical_PROC_TRANS_TRANSFORMED_UUID() throws Exception {
        this.execute(" select TRANSFORMED_UUID from SystemPhysical.PROC_TRANS");
    }

    public void testSystemPhysical_PROC_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.PROC_TYPE_ENUM");
    }

    public void testSystemPhysical_PROC_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.PROC_TYPE_ENUM");
    }

    public void testSystemPhysical_PROPERTIES_PROPERTIED_UUID() throws Exception {
        this.execute(" select PROPERTIED_UUID from SystemPhysical.PROPERTIES");
    }

    public void testSystemPhysical_PROPERTIES_PROP_NAME() throws Exception {
        this.execute(" select PROP_NAME from SystemPhysical.PROPERTIES");
    }

    public void testSystemPhysical_PROPERTIES_PROP_VALUE() throws Exception {
        this.execute(" select PROP_VALUE from SystemPhysical.PROPERTIES");
    }

    public void testSystemPhysical_SEARCH_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.SEARCH_TYPE_ENUM");
    }

    public void testSystemPhysical_SEARCH_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.SEARCH_TYPE_ENUM");
    }

    public void test_SystemPhysical_SELECT_TRANS_OBJECT_TYPE() throws Exception {
        this.execute("select OBJECT_TYPE from SystemPhysical.SELECT_TRANS");
    }

    public void test_SystemPhysical_SELECT_TRANS_TRANSFORMATION() throws Exception {
        this.execute("select TRANSFORMATION from SystemPhysical.SELECT_TRANS");
    }

    public void test_SystemPhysical_SELECT_TRANS_TRANSFORMED_PATH() throws Exception {
        this.execute("select TRANSFORMED_PATH from SystemPhysical.SELECT_TRANS");
    }

    public void test_SystemPhysical_SELECT_TRANS_TRANSFORMED_UUID() throws Exception {
        this.execute("select TRANSFORMED_UUID from SystemPhysical.SELECT_TRANS");
    }

    public void testSystemPhysical_TABLES_CARDINALITY() throws Exception {
        this.execute(" select CARDINALITY from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_IS_PHYSICAL() throws Exception {
        this.execute(" select IS_PHYSICAL from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_IS_SYSTEM() throws Exception {
        this.execute(" select IS_SYSTEM from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_IS_VIRTUAL() throws Exception {
        this.execute(" select IS_VIRTUAL from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_SUPPORTS_UPDATE() throws Exception {
        this.execute(" select SUPPORTS_UPDATE from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_TABLE_TYPE() throws Exception {
        this.execute("select TABLE_TYPE from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLES_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.TABLES");
    }

    public void testSystemPhysical_TABLE_TYPE_ENUM_CODE() throws Exception {
        this.execute(" select CODE from SystemPhysical.TABLE_TYPE_ENUM");
    }

    public void testSystemPhysical_TABLE_TYPE_ENUM_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.TABLE_TYPE_ENUM");
    }

    public void testSystemPhysical_UNIQUE_KEYS_FULLNAME() throws Exception {
        this.execute(" select FULLNAME from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_MODEL_NAME() throws Exception {
        this.execute(" select MODEL_NAME from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_NAME_IN_SOURCE() throws Exception {
        this.execute(" select NAME_IN_SOURCE from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_NAME() throws Exception {
        this.execute(" select NAME from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_PATH() throws Exception {
        this.execute(" select PATH from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_TABLE_NAME() throws Exception {
        this.execute(" select TABLE_NAME from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_UUID_OF_TABLE() throws Exception {
        this.execute(" select UUID_OF_TABLE from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UNIQUE_KEYS_UUID() throws Exception {
        this.execute(" select UUID from SystemPhysical.UNIQUE_KEYS");
    }

    public void testSystemPhysical_UPDATE_TRANS_OBJECT_TYPE() throws Exception {
        this.execute(" select OBJECT_TYPE from SystemPhysical.UPDATE_TRANS");
    }

    public void testSystemPhysical_UPDATE_TRANS_TRANSFORMATION() throws Exception {
        this.execute(" select TRANSFORMATION from SystemPhysical.UPDATE_TRANS");
    }

    public void testSystemPhysical_UPDATE_TRANS_TRANSFORMED_PATH() throws Exception {
        this.execute(" select TRANSFORMED_PATH from SystemPhysical.UPDATE_TRANS");
    }

    public void testSystemPhysical_UPDATE_TRANS_TRANSFORMED_UUID() throws Exception {
        this.execute(" select TRANSFORMED_UUID from SystemPhysical.UPDATE_TRANS");
    }

    public void testSystemPhysical_VDB_INFO_NAME() throws Exception {
        String[] expected = new String[]{"NAME", "testName"};
        this.execute(" select NAME from SystemPhysical.VDB_INFO", expected);
    }

    public void testSystemPhysical_VDB_INFO_VERSION() throws Exception {
        String[] expected = new String[]{"VERSION", "testVersion"};
        this.execute("select VERSION from SystemPhysical.VDB_INFO", expected);
    }

    public void testRepeatedQueries() throws Exception {
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
        this.execute(" select parent_name, name as n from columns order by n");
    }
}

