/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.systemmodel;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.api.AbstractMMQueryTestCase;
import org.junit.Before;
import org.junit.Test;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String DQP_PROP_FILE = UnitTestUtil.getTestDataPath() + "/partssupplier/dqp.properties";
    private static final String VDB = "PartsSupplier";

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() {
        this.getConnection(VDB, DQP_PROP_FILE);
    }

    @Test
    public void testDefect23534() {
        String[] expected = new String[]{"SCOPE[short]\tCOLUMN_NAME[string]\tDATA_TYPE[short]\tTYPE_NAME[string]\tPRECISION[integer]\tLENGTH[integer]\tSCALE[integer]\tPSEUDO_COLUMN[short]"};
        this.executeAndAssertResults("SELECT OA_SCOPE as \"SCOPE\" , COLUMN_NAME,  DATA_TYPE, TYPE_NAME, OA_PRECISION as \"PRECISION\", OA_LENGTH as \"LENGTH\", OA_SCALE as \"SCALE\", PSEUDO_COLUMN FROM System.ODBC.OA_COLUMNS  WHERE TABLE_NAME = N'AUTHORS' AND TABLE_OWNER = N's1' AND (OA_COLUMNTYPE = 2 OR OA_COLUMNTYPE = 3) AND (OA_SCOPE is null OR OA_SCOPE >= 1) AND (OA_NULLABLE = 0 OR OA_NULLABLE = 1) ORDER BY \"SCOPE\"", expected);
    }

    @Test
    public void testModels() {
        String[] expected = new String[]{"Name[string]\tIsPhysical[boolean]\tSupportsWhereAll[boolean]\tSupportsOrderBy[boolean]\tSupportsJoin[boolean]\tSupportsDistinct[boolean]\tSupportsOuterJoin[boolean]\tMaxSetSize[integer]\tUID[string]\tDescription[string]\tPrimaryMetamodelURI[string]", "PartsSupplier\ttrue\ttrue\ttrue\ttrue\ttrue\ttrue\t100\tmmuuid:19c7f380-73d8-1edc-a81c-ecf397b10590\tnull\thttp://www.metamatrix.com/metamodels/Relational", "System\tfalse\ttrue\ttrue\ttrue\ttrue\ttrue\t0\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tSystem\thttp://www.metamatrix.com/metamodels/Relational"};
        this.executeAndAssertResults("select* from System.Models", expected);
    }

    @Test
    public void testKeys() {
        String[] expected = new String[]{"ModelName[string]\tGroupFullName[string]\tName[string]\tDescription[string]\tNameInSource[string]\tType[string]\tIsIndexed[boolean]\tGroupName[string]\tGroupUpperName[string]\tRefKeyUID[string]\tUID[string]", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.PARTS\tPK_PARTS\tnull\tnull\tPrimary\tfalse\tPARTS\tPARTS\tnull\tmmuuid:07db4240-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SHIP_VIA\tPK_SHIP_VIA\tnull\tnull\tPrimary\tfalse\tSHIP_VIA\tSHIP_VIA\tnull\tmmuuid:18aa3cc0-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.STATUS\tPK_STATUS\tnull\tnull\tPrimary\tfalse\tSTATUS\tSTATUS\tnull\tmmuuid:25a8a740-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tPK_SUPPLIER\tnull\tnull\tPrimary\tfalse\tSUPPLIER\tSUPPLIER\tnull\tmmuuid:375c8380-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tPK_SUPPLIER_PARTS\tnull\tnull\tPrimary\tfalse\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tnull\tmmuuid:455e5440-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tFK_SPLIER_STATS\tnull\tFK_SPLIER_STATS\tForeign\tfalse\tSUPPLIER\tSUPPLIER\tmmuuid:25a8a740-73ff-1edc-a81c-ecf397b10590\tmmuuid:5ac43c00-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tFK_SPLIER_PRTS_PRTS\tnull\tFK_SPLIER_PRTS_PRTS\tForeign\tfalse\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tmmuuid:07db4240-73ff-1edc-a81c-ecf397b10590\tmmuuid:66ddc4c0-73ff-1edc-a81c-ecf397b10590", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tFK_SPLY_PRTS_SPLY\tnull\tFK_SPLY_PRTS_SPLY\tForeign\tfalse\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tmmuuid:375c8380-73ff-1edc-a81c-ecf397b10590\tmmuuid:66ddc4c1-73ff-1edc-a81c-ecf397b10590"};
        this.executeAndAssertResults("select* from System.Keys order by UID", expected);
    }

    @Test
    public void testGroups() {
        String[] expected = new String[]{"ModelName[string]\tFullName[string]\tName[string]\tType[string]\tNameInSource[string]\tIsPhysical[boolean]\tUpperName[string]\tSupportsUpdates[boolean]\tUID[string]\tCardinality[integer]\tDescription[string]\tIsSystem[boolean]\tIsMaterialized[boolean]", "System\tSystem.Models\tModels\tTable\tnull\tfalse\tMODELS\tfalse\tmmuuid:0193bfc0-e013-1ddf-aa2e-88f814a79e93\t0\tnull\ttrue\tfalse", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SHIP_VIA\tSHIP_VIA\tTable\tSHIP_VIA\ttrue\tSHIP_VIA\ttrue\tmmuuid:0f4e9b80-73ff-1edc-a81c-ecf397b10590\t4\tnull\tfalse\tfalse", "System\tSystem.ModelProperties\tModelProperties\tTable\tnull\tfalse\tMODELPROPERTIES\tfalse\tmmuuid:135f7080-c370-1de7-b515-bad6cb0abb8d\t0\tnull\ttrue\tfalse", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.STATUS\tSTATUS\tTable\tSTATUS\ttrue\tSTATUS\ttrue\tmmuuid:1f297200-73ff-1edc-a81c-ecf397b10590\t3\tnull\tfalse\tfalse", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER\tTable\tSUPPLIER\ttrue\tSUPPLIER\ttrue\tmmuuid:2c371ec0-73ff-1edc-a81c-ecf397b10590\t16\tnull\tfalse\tfalse", "System\tSystem.ProcedureProperties\tProcedureProperties\tTable\tnull\tfalse\tPROCEDUREPROPERTIES\tfalse\tmmuuid:2ec88080-c5b1-1de7-b515-bad6cb0abb8d\t0\tnull\ttrue\tfalse", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSUPPLIER_PARTS\tTable\tSUPPLIER_PARTS\ttrue\tSUPPLIER_PARTS\ttrue\tmmuuid:3deafb00-73ff-1edc-a81c-ecf397b10590\t227\tnull\tfalse\tfalse", "System\tSystem.ODBC.OA_TABLES\tOA_TABLES\tTable\tnull\tfalse\tOA_TABLES\tfalse\tmmuuid:54cbf440-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_COLUMNS\tOA_COLUMNS\tTable\tnull\tfalse\tOA_COLUMNS\tfalse\tmmuuid:54cbf446-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_PROC\tOA_PROC\tTable\tnull\tfalse\tOA_PROC\tfalse\tmmuuid:55b0d600-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_PROCCOLUMNS\tOA_PROCCOLUMNS\tTable\tnull\tfalse\tOA_PROCCOLUMNS\tfalse\tmmuuid:56a4fa00-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_TYPES\tOA_TYPES\tTable\tnull\tfalse\tOA_TYPES\tfalse\tmmuuid:57991e00-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_STATISTICS\tOA_STATISTICS\tTable\tnull\tfalse\tOA_STATISTICS\tfalse\tmmuuid:57991e10-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.ODBC.OA_FKEYS\tOA_FKEYS\tTable\tnull\tfalse\tOA_FKEYS\tfalse\tmmuuid:587dffc0-2ca5-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.DataTypeElementProperties\tDataTypeElementProperties\tTable\tnull\tfalse\tDATATYPEELEMENTPROPERTIES\tfalse\tmmuuid:64bdb6c0-c7fe-1de7-ad1c-f3ce4292824e\t0\tnull\ttrue\tfalse", "System\tSystem.Elements\tElements\tTable\tnull\tfalse\tELEMENTS\tfalse\tmmuuid:6c04a1c0-0d14-1de0-be14-9d00a629c112\t0\tnull\ttrue\tfalse", "System\tSystem.VirtualDatabases\tVirtualDatabases\tTable\tnull\tfalse\tVIRTUALDATABASES\tfalse\tmmuuid:7ce634df-2953-1de6-8a38-9d76e1f90f2e\t0\tnull\ttrue\tfalse", "System\tSystem.KeyProperties\tKeyProperties\tTable\tnull\tfalse\tKEYPROPERTIES\tfalse\tmmuuid:8f87b840-10f8-1ff5-a438-98ce9bfae8da\t0\tnull\ttrue\tfalse", "System\tSystem.JDBC.ReferenceKeyColumns\tReferenceKeyColumns\tTable\tnull\tfalse\tREFERENCEKEYCOLUMNS\tfalse\tmmuuid:9d4fe980-2c99-1f8d-a539-a73e664462a1\t0\tnull\ttrue\tfalse", "System\tSystem.DataTypeElements\tDataTypeElements\tTable\tnull\tfalse\tDATATYPEELEMENTS\tfalse\tmmuuid:b22df900-c6f1-1de7-b515-bad6cb0abb8d\t0\tnull\ttrue\tfalse", "System\tSystem.ElementProperties\tElementProperties\tTable\tnull\tfalse\tELEMENTPROPERTIES\tfalse\tmmuuid:b4c43500-c514-1de7-b515-bad6cb0abb8d\t0\tnull\ttrue\tfalse", "System\tSystem.ProcedureParams\tProcedureParams\tTable\tnull\tfalse\tPROCEDUREPARAMS\tfalse\tmmuuid:b86f5f40-1107-1de0-8701-e0b030c0afb8\t0\tnull\ttrue\tfalse", "System\tSystem.Groups\tGroups\tTable\tnull\tfalse\tGROUPS\tfalse\tmmuuid:c5c23382-e000-1ddf-aa2e-88f814a79e93\t0\tnull\ttrue\tfalse", "System\tSystem.DataTypes\tDataTypes\tTable\tnull\tfalse\tDATATYPES\tfalse\tmmuuid:c5c23386-e000-1ddf-aa2e-88f814a79e93\t0\tnull\ttrue\tfalse", "System\tSystem.DataTypeProperties\tDataTypeProperties\tTable\tnull\tfalse\tDATATYPEPROPERTIES\tfalse\tmmuuid:c68bf240-c894-1de7-ad1c-f3ce4292824e\t0\tnull\ttrue\tfalse", "System\tSystem.Keys\tKeys\tTable\tnull\tfalse\tKEYS\tfalse\tmmuuid:d0e3fe00-0d1f-1de0-be14-9d00a629c112\t0\tnull\ttrue\tfalse", "System\tSystem.KeyElements\tKeyElements\tTable\tnull\tfalse\tKEYELEMENTS\tfalse\tmmuuid:ee7d0140-0efb-1de0-8c1f-ee86b9bb7e7f\t0\tnull\ttrue\tfalse", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.PARTS\tPARTS\tTable\tPARTS\ttrue\tPARTS\ttrue\tmmuuid:f6276601-73fe-1edc-a81c-ecf397b10590\t16\tnull\tfalse\tfalse", "System\tSystem.GroupProperties\tGroupProperties\tTable\tnull\tfalse\tGROUPPROPERTIES\tfalse\tmmuuid:f97f87c0-c47f-1de7-b515-bad6cb0abb8d\t0\tnull\ttrue\tfalse", "System\tSystem.Procedures\tProcedures\tTable\tnull\tfalse\tPROCEDURES\tfalse\tmmuuid:fd2b3700-0f9d-1de0-8701-e0b030c0afb8\t0\tnull\ttrue\tfalse"};
        this.executeAndAssertResults("select* from System.Groups order by UID", expected);
    }

    @Test
    public void testDataTypeElements() {
        String[] expected = new String[]{"DataTypeName[string]\tName[string]\tPosition[integer]\tScale[integer]\tElementLength[integer]\tUID[string]"};
        this.executeAndAssertResults("select* from System.DataTypeElements", expected);
    }

    @Test
    public void testDataTypes() {
        String[] expected = new String[]{"Name[string]\tIsStandard[boolean]\tIsPhysical[boolean]\tTypeName[string]\tJavaClass[string]\tScale[integer]\tTypeLength[integer]\tNullType[string]\tIsSigned[boolean]\tIsAutoIncremented[boolean]\tIsCaseSensitive[boolean]\tPrecision[integer]\tRadix[integer]\tSearchType[string]\tUID[string]\tRuntimeType[string]\tBaseType[string]\tDescription[string]", "ENTITIES\tfalse\tfalse\tENTITIES\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:20360100-e742-1e20-8c26-a038c6ed7576\tstring\tENTITY\tnull", "ENTITY\tfalse\tfalse\tENTITY\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:9fece300-e71a-1e20-8c26-a038c6ed7576\tstring\tNCName\tnull", "ID\tfalse\tfalse\tID\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:88b13dc0-e702-1e20-8c26-a038c6ed7576\tstring\tNCName\tnull", "IDREF\tfalse\tfalse\tIDREF\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:dd33ff40-e6df-1e20-8c26-a038c6ed7576\tstring\tNCName\tnull", "IDREFS\tfalse\tfalse\tIDREFS\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:3c99f780-e72d-1e20-8c26-a038c6ed7576\tstring\tIDREF\tnull", "NCName\tfalse\tfalse\tNCName\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:ac00e000-e676-1e20-8c26-a038c6ed7576\tstring\tName\tnull", "NMTOKEN\tfalse\tfalse\tNMTOKEN\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:4ca2ae00-3a95-1e20-921b-eeee28353879\tstring\ttoken\tnull", "NMTOKENS\tfalse\tfalse\tNMTOKENS\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:4b0f8500-e6a6-1e20-8c26-a038c6ed7576\tstring\tNMTOKEN\tnull", "NOTATION\tfalse\tfalse\tNOTATION\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:3dcaf900-e8dc-1e2a-b433-fb67ea35c07e\tstring\tanySimpleType\tnull", "Name\tfalse\tfalse\tName\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:e66c4600-e65b-1e20-8c26-a038c6ed7576\tstring\ttoken\tnull", "QName\tfalse\tfalse\tQName\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:eeb5d780-e8c3-1e2a-b433-fb67ea35c07e\tstring\tanySimpleType\tnull", "XMLLiteral\tfalse\tfalse\tXMLLiteral\tcom.metamatrix.common.types.XMLType\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:43f5274e-55e1-1f87-ba1c-eea49143eb32\txml\tstring\tnull", "anyURI\tfalse\tfalse\tanyURI\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:6247ec80-e8a4-1e2a-b433-fb67ea35c07e\tstring\tanySimpleType\tnull", "base64Binary\tfalse\tfalse\tbase64Binary\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:b4c99380-ebc6-1e2a-9319-8eaa9b2276c7\tstring\tanySimpleType\tnull", "bigdecimal\tfalse\tfalse\tbigdecimal\tjava.math.BigDecimal\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:f2249740-a078-1e26-9b08-d6079ebe1f0d\tbigdecimal\tdecimal\tnull", "biginteger\tfalse\tfalse\tbiginteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:822b9a40-a066-1e26-9b08-d6079ebe1f0d\tbiginteger\tdecimal\tnull", "blob\tfalse\tfalse\tblob\tcom.metamatrix.common.types.BlobType\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:5a793100-1836-1ed0-ba0f-f2334f5fbf95\tblob\tbase64Binary\tnull", "boolean\tfalse\tfalse\tboolean\tjava.lang.Boolean\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:dc476100-c483-1e24-9b01-c8207cd53eb7\tboolean\tanySimpleType\tnull", "byte\tfalse\tfalse\tbyte\tjava.lang.Byte\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:26dc1cc0-b9c8-1e21-b812-969c8fc8b016\tbyte\tshort\tnull", "char\tfalse\tfalse\tchar\tjava.lang.Character\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:62472700-a064-1e26-9b08-d6079ebe1f0d\tchar\tstring\tnull", "clob\tfalse\tfalse\tclob\tcom.metamatrix.common.types.ClobType\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:559646c0-4941-1ece-b22b-f49159d22ad3\tclob\tstring\tnull", "date\tfalse\tfalse\tdate\tjava.sql.Date\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:65dcde00-c4ab-1e24-9b01-c8207cd53eb7\tdate\tanySimpleType\tnull", "dateTime\tfalse\tfalse\tdateTime\tjava.sql.Timestamp\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:5c69dec0-b3ea-1e2a-9a03-beb8638ffd21\ttimestamp\tanySimpleType\tnull", "decimal\tfalse\tfalse\tdecimal\tjava.math.BigDecimal\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:569dfa00-c456-1e24-9b01-c8207cd53eb7\tbigdecimal\tanySimpleType\tnull", "double\tfalse\tfalse\tdouble\tjava.lang.Double\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:1f18b140-c4a3-1e24-9b01-c8207cd53eb7\tdouble\tanySimpleType\tnull", "duration\tfalse\tfalse\tduration\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:28d98540-b3e7-1e2a-9a03-beb8638ffd21\tstring\tanySimpleType\tnull", "float\tfalse\tfalse\tfloat\tjava.lang.Float\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:d86b0d00-c48a-1e24-9b01-c8207cd53eb7\tfloat\tanySimpleType\tnull", "gDay\tfalse\tfalse\tgDay\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:860b7dc0-b3f8-1e2a-9a03-beb8638ffd21\tbiginteger\tanySimpleType\tnull", "gMonth\tfalse\tfalse\tgMonth\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:187f5580-b3fb-1e2a-9a03-beb8638ffd21\tbiginteger\tanySimpleType\tnull", "gMonthDay\tfalse\tfalse\tgMonthDay\tjava.sql.Timestamp\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:6e604140-b3f5-1e2a-9a03-beb8638ffd21\ttimestamp\tanySimpleType\tnull", "gYear\tfalse\tfalse\tgYear\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:b02c7600-b3f2-1e2a-9a03-beb8638ffd21\tbiginteger\tanySimpleType\tnull", "gYearMonth\tfalse\tfalse\tgYearMonth\tjava.sql.Timestamp\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:17d08040-b3ed-1e2a-9a03-beb8638ffd21\ttimestamp\tanySimpleType\tnull", "hexBinary\tfalse\tfalse\thexBinary\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:d9998500-ebba-1e2a-9319-8eaa9b2276c7\tstring\tanySimpleType\tnull", "int\tfalse\tfalse\tint\tjava.lang.Integer\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:33add3c0-b98d-1e21-b812-969c8fc8b016\tinteger\tlong\tnull", "integer\tfalse\tfalse\tinteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:45da3500-e78f-1e20-8c26-a038c6ed7576\tbiginteger\tdecimal\tnull", "language\tfalse\tfalse\tlanguage\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:d4d980c0-e623-1e20-8c26-a038c6ed7576\tstring\ttoken\tnull", "long\tfalse\tfalse\tlong\tjava.lang.Long\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:8cdee840-b900-1e21-b812-969c8fc8b016\tlong\tinteger\tnull", "negativeInteger\tfalse\tfalse\tnegativeInteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:86d29280-b8d3-1e21-b812-969c8fc8b016\tbiginteger\tnonPositiveInteger\tnull", "nonNegativeInteger\tfalse\tfalse\tnonNegativeInteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:0e081200-b8a4-1e21-b812-969c8fc8b016\tbiginteger\tinteger\tnull", "nonPositiveInteger\tfalse\tfalse\tnonPositiveInteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:cbdd6e40-b9d2-1e21-8c26-a038c6ed7576\tbiginteger\tinteger\tnull", "normalizedString\tfalse\tfalse\tnormalizedString\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:4df43700-3b13-1e20-921b-eeee28353879\tstring\tstring\tnull", "object\tfalse\tfalse\tobject\tjava.lang.Object\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:051a0640-b4e8-1e26-9f33-b76fd9d5fa79\tobject\tbase64Binary\tnull", "positiveInteger\tfalse\tfalse\tpositiveInteger\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:1cbbd380-b9ea-1e21-b812-969c8fc8b016\tbiginteger\tnonNegativeInteger\tnull", "short\tfalse\tfalse\tshort\tjava.lang.Short\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:5bbcf140-b9ae-1e21-b812-969c8fc8b016\tshort\tint\tnull", "string\tfalse\tfalse\tstring\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:bf6c34c0-c442-1e24-9b01-c8207cd53eb7\tstring\tanySimpleType\tnull", "time\tfalse\tfalse\ttime\tjava.sql.Time\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:3b892180-c4a7-1e24-9b01-c8207cd53eb7\ttime\tanySimpleType\tnull", "timestamp\tfalse\tfalse\ttimestamp\tjava.sql.Timestamp\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:6d9809c0-a07e-1e26-9b08-d6079ebe1f0d\ttimestamp\tstring\tnull", "token\tfalse\tfalse\ttoken\tjava.lang.String\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:3425cb80-d844-1e20-9027-be6d2c3b8b3a\tstring\tnormalizedString\tnull", "unsignedByte\tfalse\tfalse\tunsignedByte\tjava.lang.Short\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:cff745c0-baa2-1e21-b812-969c8fc8b016\tshort\tunsignedShort\tnull", "unsignedInt\tfalse\tfalse\tunsignedInt\tjava.lang.Long\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:badcbd80-ba63-1e21-b812-969c8fc8b016\tlong\tunsignedLong\tnull", "unsignedLong\tfalse\tfalse\tunsignedLong\tjava.math.BigInteger\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:54b98780-ba14-1e21-b812-969c8fc8b016\tbiginteger\tnonNegativeInteger\tnull", "unsignedShort\tfalse\tfalse\tunsignedShort\tjava.lang.Integer\t0\t0\tNo Nulls\tfalse\tfalse\tfalse\t0\t0\tSearchable\tmmuuid:327093c0-ba88-1e21-b812-969c8fc8b016\tinteger\tunsignedInt\tnull"};
        this.executeAndAssertResults("select* from System.DataTypes", expected);
    }

    @Test
    public void testProcedureParams() {
        String[] expected = new String[]{"ModelName[string]\tProcedureName[string]\tName[string]\tDataType[string]\tPosition[integer]\tType[string]\tOptional[boolean]\tPrecision[integer]\tTypeLength[integer]\tScale[integer]\tRadix[integer]\tNullType[string]", "System\tSystem.describe\tDescription\tstring\t1\tResultSet\tfalse\t128\t128\t0\t10\tNo Nulls", "System\tSystem.getVDBResourcePaths\tResourcePath\tstring\t1\tResultSet\tfalse\t50\t50\t0\t10\tNullable", "System\tSystem.getBinaryVDBResource\tVdbResource\tblob\t1\tResultSet\tfalse\t0\t0\t0\t10\tNullable", "System\tSystem.getCharacterVDBResource\tVdbResource\tclob\t1\tResultSet\tfalse\t0\t0\t0\t10\tNullable", "System\tSystem.getUpdatedCharacterVDBResource\tVdbResource\tclob\t1\tResultSet\tfalse\t0\t0\t0\t10\tNullable", "System\tSystem.describe\tentity\tstring\t1\tIn\tfalse\t0\t0\t0\t10\tNo Nulls", "System\tSystem.getVDBResourcePaths\tisBinary\tboolean\t2\tResultSet\tfalse\t1\t1\t0\t10\tNullable", "System\tSystem.getBinaryVDBResource\tresourcePath\tstring\t1\tIn\tfalse\t50\t50\t0\t10\tNo Nulls", "System\tSystem.getCharacterVDBResource\tresourcePath\tstring\t1\tIn\tfalse\t50\t50\t0\t10\tNo Nulls", "System\tSystem.getUpdatedCharacterVDBResource\tresourcePath\tstring\t1\tIn\tfalse\t50\t50\t0\t10\tNo Nulls", "System\tSystem.getUpdatedCharacterVDBResource\ttokenReplacements\tobject\t3\tIn\tfalse\t0\t0\t0\t10\tNo Nulls", "System\tSystem.getUpdatedCharacterVDBResource\ttokens\tobject\t2\tIn\tfalse\t0\t0\t0\t10\tNo Nulls"};
        this.executeAndAssertResults("select * from System.ProcedureParams order by Name", expected);
    }

    @Test
    public void testProcedures() {
        String[] expected = new String[]{"ModelName[string]\tName[string]\tNameInSource[string]\tReturnsResults[boolean]\tModelUID[string]\tUID[string]\tDescription[string]\tFullName[string]", "System\tdescribe\tnull\ttrue\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tmmuuid:93687100-1916-1e87-8525-f813a949866a\tnull\tSystem.describe", "System\tgetBinaryVDBResource\tnull\ttrue\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tmmuuid:b85dbd44-39d9-1f33-9f26-c47bba154acc\tnull\tSystem.getBinaryVDBResource", "System\tgetCharacterVDBResource\tnull\ttrue\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tmmuuid:b85dbd40-39d9-1f33-9f26-c47bba154acc\tnull\tSystem.getCharacterVDBResource", "System\tgetUpdatedCharacterVDBResource\tnull\ttrue\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tmmuuid:b9429f00-39d9-1f33-9f26-c47bba154acc\tnull\tSystem.getUpdatedCharacterVDBResource", "System\tgetVDBResourcePaths\tnull\ttrue\tmmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e\tmmuuid:b9429f06-39d9-1f33-9f26-c47bba154acc\tnull\tSystem.getVDBResourcePaths"};
        this.executeAndAssertResults("select* from System.Procedures", expected);
    }

    @Test
    public void testGroupProperties() {
        String[] expected = new String[]{"ModelName[string]\tGroupFullName[string]\tName[string]\tValue[string]\tGroupName[string]\tGroupUpperName[string]\tUID[string]"};
        this.executeAndAssertResults("select* from System.GroupProperties", expected);
    }

    @Test
    public void testModelProperties() {
        String[] expected = new String[]{"ModelName[string]\tName[string]\tValue[string]\tUID[string]"};
        this.executeAndAssertResults("select* from System.ModelProperties", expected);
    }

    @Test
    public void testProcedureProperties() {
        String[] expected = new String[]{"ModelName[string]\tProcedureName[string]\tName[string]\tValue[string]\tUID[string]"};
        this.executeAndAssertResults("select* from System.ProcedureProperties", expected);
    }

    @Test
    public void testVirtualDatabase() {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from System.VirtualDatabases", expected);
    }

    @Test
    public void testKeyElements() {
        String[] expected = new String[]{"ModelName[string]\tGroupFullName[string]\tName[string]\tKeyName[string]\tKeyType[string]\tGroupName[string]\tGroupUpperName[string]\tRefKeyUID[string]\tUID[string]\tPosition[integer]", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_ID\tPK_PARTS\tPrimary\tPARTS\tPARTS\tnull\tmmuuid:07db4240-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SHIP_VIA\tSHIPPER_ID\tPK_SHIP_VIA\tPrimary\tSHIP_VIA\tSHIP_VIA\tnull\tmmuuid:18aa3cc0-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.STATUS\tSTATUS_ID\tPK_STATUS\tPrimary\tSTATUS\tSTATUS\tnull\tmmuuid:25a8a740-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_ID\tPK_SUPPLIER\tPrimary\tSUPPLIER\tSUPPLIER\tnull\tmmuuid:375c8380-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_STATUS\tFK_SPLIER_STATS\tForeign\tSUPPLIER\tSUPPLIER\tmmuuid:25a8a740-73ff-1edc-a81c-ecf397b10590\tmmuuid:5ac43c00-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tPART_ID\tPK_SUPPLIER_PARTS\tPrimary\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tnull\tmmuuid:455e5440-73ff-1edc-a81c-ecf397b10590\t2", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tPART_ID\tFK_SPLIER_PRTS_PRTS\tForeign\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tmmuuid:07db4240-73ff-1edc-a81c-ecf397b10590\tmmuuid:66ddc4c0-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSUPPLIER_ID\tPK_SUPPLIER_PARTS\tPrimary\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tnull\tmmuuid:455e5440-73ff-1edc-a81c-ecf397b10590\t1", "PartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSUPPLIER_ID\tFK_SPLY_PRTS_SPLY\tForeign\tSUPPLIER_PARTS\tSUPPLIER_PARTS\tmmuuid:375c8380-73ff-1edc-a81c-ecf397b10590\tmmuuid:66ddc4c1-73ff-1edc-a81c-ecf397b10590\t1"};
        this.executeAndAssertResults("select* from System.KeyElements order by GroupFullName, Name", expected);
    }

    @Test
    public void testElementProperties() {
        String[] expected = new String[]{"ModelName[string]\tGroupFullName[string]\tElementName[string]\tName[string]\tValue[string]\tGroupName[string]\tElementUpperName[string]\tGroupUpperName[string]\tUID[string]"};
        this.executeAndAssertResults("select* from System.ElementProperties", expected);
    }

    @Test
    public void testDataTypeElementProperties() {
        String[] expected = new String[]{"DataTypeName[string]\tDataTypeElementName[string]\tName[string]\tValue[string]\tUID[string]"};
        this.executeAndAssertResults("select* from System.DataTypeElementProperties", expected);
    }

    @Test
    public void testDescribe() {
        this.execute("exec System.describe(?)", new Object[]{"parts"});
        String[] expected = new String[]{"Description[string]"};
        this.assertResults(expected);
    }

    @Test
    public void testVDBResourcePathsProcedure() {
        String[] expected = new String[]{"ResourcePath[string]\tisBinary[boolean]\t", "/parts/partsmd/PartsSupplier.xmi\tfalse", "/System/System.xmi\tfalse"};
        this.execute("exec System.getVDBResourcePaths()", new Object[0]);
        this.assertResults(expected);
    }

    @Test
    public void testElements() {
        String[] expected = new String[]{"ModelName[string]\tGroupName[string]\tGroupFullName[string]\tName[string]\tPosition[integer]\tNameInSource[string]\tDataType[string]\tScale[integer]\tElementLength[integer]\tIsLengthFixed[boolean]\tSupportsSelect[boolean]\tSupportsUpdates[boolean]\tIsCaseSensitive[boolean]\tIsSigned[boolean]\tIsCurrency[boolean]\tIsAutoIncremented[boolean]\tNullType[string]\tMinRange[string]\tMaxRange[string]\tSearchType[string]\tFormat[string]\tDefaultValue[string]\tJavaClass[string]\tPrecision[integer]\tCharOctetLength[integer]\tRadix[integer]\tGroupUpperName[string]\tUpperName[string]\tUID[string]\tDescription[string]", "PartsSupplier\tPARTS\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_NAME\t2\tPART_NAME\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t255\t10\tPARTS\tPART_NAME\tmmuuid:0067e900-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tPARTS\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_COLOR\t3\tPART_COLOR\tstring\t0\t30\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t30\t10\tPARTS\tPART_COLOR\tmmuuid:015c0d00-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tPARTS\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_WEIGHT\t4\tPART_WEIGHT\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t255\t10\tPARTS\tPART_WEIGHT\tmmuuid:015c0d01-73ff-1edc-a81c-ecf397b10590\tnull", "System\tKeys\tSystem.Keys\tGroupUpperName\t9\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tGROUPUPPERNAME\tmmuuid:07268b40-c2f4-1de7-b515-bad6cb0abb8d\tnull", "PartsSupplier\tSHIP_VIA\tPartsSupplier.PARTSSUPPLIER.SHIP_VIA\tSHIPPER_ID\t1\tSHIPPER_ID\tshort\t0\t0\ttrue\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Short\t2\t0\t10\tSHIP_VIA\tSHIPPER_ID\tmmuuid:121bc540-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSHIP_VIA\tPartsSupplier.PARTSSUPPLIER.SHIP_VIA\tSHIPPER_NAME\t2\tSHIPPER_NAME\tstring\t0\t30\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t30\t10\tSHIP_VIA\tSHIPPER_NAME\tmmuuid:130fe940-73ff-1edc-a81c-ecf397b10590\tnull", "System\tDataTypes\tSystem.DataTypes\tName\t1\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tDATATYPES\tNAME\tmmuuid:15b71f00-c266-1de7-b515-bad6cb0abb8d\tnull", "PartsSupplier\tSTATUS\tPartsSupplier.PARTSSUPPLIER.STATUS\tSTATUS_ID\t1\tSTATUS_ID\tshort\t0\t0\ttrue\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Short\t2\t0\t10\tSTATUS\tSTATUS_ID\tmmuuid:201d9600-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSTATUS\tPartsSupplier.PARTSSUPPLIER.STATUS\tSTATUS_NAME\t2\tSTATUS_NAME\tstring\t0\t30\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t30\t10\tSTATUS\tSTATUS_NAME\tmmuuid:201d9601-73ff-1edc-a81c-ecf397b10590\tnull", "System\tModels\tSystem.Models\tDescription\t10\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELS\tDESCRIPTION\tmmuuid:2268b040-3a47-1edb-8606-be949cc6da52\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tPrecision\t8\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tPROCEDUREPARAMS\tPRECISION\tmmuuid:2626ed80-634e-1e44-a903-c1472e78d1c5\tnull", "System\tModelProperties\tSystem.ModelProperties\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELPROPERTIES\tMODELNAME\tmmuuid:2afa8d80-c3cd-1de7-b515-bad6cb0abb8d\tnull", "System\tModelProperties\tSystem.ModelProperties\tUID\t4\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tMODELPROPERTIES\tUID\tmmuuid:2afa8d82-c3cd-1de7-b515-bad6cb0abb8d\tnull", "PartsSupplier\tSUPPLIER\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_ID\t1\tSUPPLIER_ID\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t10\t10\tSUPPLIER\tSUPPLIER_ID\tmmuuid:2f044880-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_NAME\t2\tSUPPLIER_NAME\tstring\t0\t30\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t30\t10\tSUPPLIER\tSUPPLIER_NAME\tmmuuid:2f044881-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_STATUS\t3\tSUPPLIER_STATUS\tshort\t0\t0\ttrue\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Short\t2\t0\t10\tSUPPLIER\tSUPPLIER_STATUS\tmmuuid:2f044882-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_CITY\t4\tSUPPLIER_CITY\tstring\t0\t30\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t30\t10\tSUPPLIER\tSUPPLIER_CITY\tmmuuid:2fe92a40-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_STATE\t5\tSUPPLIER_STATE\tstring\t0\t2\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t2\t10\tSUPPLIER\tSUPPLIER_STATE\tmmuuid:2fe92a41-73ff-1edc-a81c-ecf397b10590\tnull", "System\tProcedures\tSystem.Procedures\tNameInSource\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDURES\tNAMEINSOURCE\tmmuuid:339a9a00-35fc-1dee-8e07-e3cb3008f82b\tnull", "System\tDataTypeElementProperties\tSystem.DataTypeElementProperties\tDataTypeName\t1\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tDATATYPEELEMENTPROPERTIES\tDATATYPENAME\tmmuuid:34af31c0-c88f-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeElementProperties\tSystem.DataTypeElementProperties\tDataTypeElementName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tDATATYPEELEMENTPROPERTIES\tDATATYPEELEMENTNAME\tmmuuid:34af31c1-c88f-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeElementProperties\tSystem.DataTypeElementProperties\tName\t3\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPEELEMENTPROPERTIES\tNAME\tmmuuid:34af31c2-c88f-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeElementProperties\tSystem.DataTypeElementProperties\tUID\t5\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPEELEMENTPROPERTIES\tUID\tmmuuid:34af31c3-c88f-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeElementProperties\tSystem.DataTypeElementProperties\tValue\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tDATATYPEELEMENTPROPERTIES\tVALUE\tmmuuid:35941381-c88f-1de7-ad1c-f3ce4292824e\tnull", "System\tElements\tSystem.Elements\tDescription\t30\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tDESCRIPTION\tmmuuid:36fd7640-3a50-1edb-8606-be949cc6da52\tnull", "System\tKeyElements\tSystem.KeyElements\tPosition\t10\tnull\tinteger\t0\t10\ttrue\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tKEYELEMENTS\tPOSITION\tmmuuid:39d26b40-396b-1edb-8606-be949cc6da52\tnull", "System\tProcedureProperties\tSystem.ProcedureProperties\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPROPERTIES\tMODELNAME\tmmuuid:3a5c9f42-c5f6-1de7-b515-bad6cb0abb8d\tnull", "System\tProcedureProperties\tSystem.ProcedureProperties\tProcedureName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPROPERTIES\tPROCEDURENAME\tmmuuid:3a5c9f43-c5f6-1de7-b515-bad6cb0abb8d\tnull", "System\tProcedureProperties\tSystem.ProcedureProperties\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPROPERTIES\tNAME\tmmuuid:3a5c9f45-c5f6-1de7-b515-bad6cb0abb8d\tnull", "System\tProcedureProperties\tSystem.ProcedureProperties\tUID\t5\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tPROCEDUREPROPERTIES\tUID\tmmuuid:3a5c9f46-c5f6-1de7-b515-bad6cb0abb8d\tnull", "System\tProcedureProperties\tSystem.ProcedureProperties\tValue\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPROPERTIES\tVALUE\tmmuuid:3a5c9f48-c5f6-1de7-b515-bad6cb0abb8d\tnull", "System\tModelProperties\tSystem.ModelProperties\tName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELPROPERTIES\tNAME\tmmuuid:3c881f40-c3dc-1de7-b515-bad6cb0abb8d\tnull", "System\tModelProperties\tSystem.ModelProperties\tValue\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELPROPERTIES\tVALUE\tmmuuid:3c881f41-c3dc-1de7-b515-bad6cb0abb8d\tnull", "PartsSupplier\tSUPPLIER_PARTS\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSUPPLIER_ID\t1\tSUPPLIER_ID\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t10\t10\tSUPPLIER_PARTS\tSUPPLIER_ID\tmmuuid:3ecfdcc0-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER_PARTS\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tPART_ID\t2\tPART_ID\tstring\t0\t4\ttrue\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t4\t10\tSUPPLIER_PARTS\tPART_ID\tmmuuid:3fc400c0-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER_PARTS\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tQUANTITY\t3\tQUANTITY\tshort\t0\t0\ttrue\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Short\t3\t0\t10\tSUPPLIER_PARTS\tQUANTITY\tmmuuid:3fc400c1-73ff-1edc-a81c-ecf397b10590\tnull", "PartsSupplier\tSUPPLIER_PARTS\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSHIPPER_ID\t4\tSHIPPER_ID\tshort\t0\t0\ttrue\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Short\t2\t0\t10\tSUPPLIER_PARTS\tSHIPPER_ID\tmmuuid:3fc400c2-73ff-1edc-a81c-ecf397b10590\tnull", "System\tModels\tSystem.Models\tUID\t9\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tMODELS\tUID\tmmuuid:4610fe00-b6d6-1de7-b705-ef2376c3949e\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tDataTypeName\t1\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tDATATYPEELEMENTS\tDATATYPENAME\tmmuuid:49bf3600-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tDATATYPEELEMENTS\tNAME\tmmuuid:49bf3601-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tPosition\t3\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tDATATYPEELEMENTS\tPOSITION\tmmuuid:49bf3602-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tUID\t6\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPEELEMENTS\tUID\tmmuuid:49bf3604-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tScale\t4\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tDATATYPEELEMENTS\tSCALE\tmmuuid:49bf3605-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypeElements\tSystem.DataTypeElements\tElementLength\t5\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tDATATYPEELEMENTS\tELEMENTLENGTH\tmmuuid:49bf3606-c74a-1de7-b515-bad6cb0abb8d\tnull", "System\tDataTypes\tSystem.DataTypes\tTypeLength\t7\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t(0)\tjava.lang.Integer\t10\t10\t10\tDATATYPES\tTYPELENGTH\tmmuuid:505f1740-b823-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELS\tNAME\tmmuuid:51706d40-b6d0-1de7-b705-ef2376c3949e\tnull", "System\tGroups\tSystem.Groups\tSupportsUpdates\t8\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tGROUPS\tSUPPORTSUPDATES\tmmuuid:533fa200-348c-1e06-9501-aee4d16940ab\tnull", "System\tOA_TABLES\tSystem.ODBC.OA_TABLES\tTABLE_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_TABLES\tTABLE_OWNER\tmmuuid:54cbf441-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TABLES\tSystem.ODBC.OA_TABLES\tREMARKS\t5\tnull\tstring\t0\t254\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t254\t254\t10\tOA_TABLES\tREMARKS\tmmuuid:54cbf442-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TABLES\tSystem.ODBC.OA_TABLES\tTABLE_TYPE\t4\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_TABLES\tTABLE_TYPE\tmmuuid:54cbf443-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TABLES\tSystem.ODBC.OA_TABLES\tTABLE_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_TABLES\tTABLE_NAME\tmmuuid:54cbf444-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TABLES\tSystem.ODBC.OA_TABLES\tTABLE_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_TABLES\tTABLE_QUALIFIER\tmmuuid:54cbf445-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tTABLE_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_COLUMNS\tTABLE_QUALIFIER\tmmuuid:54cbf447-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_NULLABLE\t11\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_COLUMNS\tOA_NULLABLE\tmmuuid:54cbf448-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_SCALE\t9\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_COLUMNS\tOA_SCALE\tmmuuid:54cbf449-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tTABLE_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_COLUMNS\tTABLE_NAME\tmmuuid:54cbf44a-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tREMARKS\t15\tnull\tstring\t0\t254\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t254\t254\t10\tOA_COLUMNS\tREMARKS\tmmuuid:54cbf44b-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_COLUMNTYPE\t14\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_COLUMNS\tOA_COLUMNTYPE\tmmuuid:54cbf44c-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_PRECISION\t8\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_COLUMNS\tOA_PRECISION\tmmuuid:54cbf44d-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_RADIX\t10\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_COLUMNS\tOA_RADIX\tmmuuid:54cbf44e-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_LENGTH\t7\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_COLUMNS\tOA_LENGTH\tmmuuid:54cbf44f-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tCOLUMN_NAME\t4\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_COLUMNS\tCOLUMN_NAME\tmmuuid:54cbf450-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tOA_SCOPE\t12\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_COLUMNS\tOA_SCOPE\tmmuuid:54cbf451-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tDATA_TYPE\t5\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_COLUMNS\tDATA_TYPE\tmmuuid:54cbf452-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tTYPE_NAME\t6\tnull\tstring\t0\t100\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tOA_COLUMNS\tTYPE_NAME\tmmuuid:54cbf453-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tPSEUDO_COLUMN\t13\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_COLUMNS\tPSEUDO_COLUMN\tmmuuid:54cbf454-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_COLUMNS\tSystem.ODBC.OA_COLUMNS\tTABLE_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_COLUMNS\tTABLE_OWNER\tmmuuid:54cbf455-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tElementProperties\tSystem.ElementProperties\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tMODELNAME\tmmuuid:54d5e2c2-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tGroupName\t6\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tGROUPNAME\tmmuuid:54d5e2c3-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tGroupFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tELEMENTPROPERTIES\tGROUPFULLNAME\tmmuuid:54d5e2c4-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tElementName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tELEMENTNAME\tmmuuid:54d5e2c5-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tName\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tNAME\tmmuuid:54d5e2c6-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tUID\t9\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tELEMENTPROPERTIES\tUID\tmmuuid:54d5e2c7-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tValue\t5\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tVALUE\tmmuuid:54d5e2c9-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tREMARKS\t7\tnull\tstring\t0\t254\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t254\t254\t10\tOA_PROC\tREMARKS\tmmuuid:55b0d601-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tOA_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROC\tOA_OWNER\tmmuuid:55b0d602-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tOA_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROC\tOA_QUALIFIER\tmmuuid:55b0d603-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tNUM_OUTPUT_PARAMS\t5\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROC\tNUM_OUTPUT_PARAMS\tmmuuid:55b0d604-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tNUM_INPUT_PARAMS\t4\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROC\tNUM_INPUT_PARAMS\tmmuuid:55b0d605-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tOA_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROC\tOA_NAME\tmmuuid:55b0d606-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tPROCEDURE_TYPE\t8\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_PROC\tPROCEDURE_TYPE\tmmuuid:55b0d607-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROC\tSystem.ODBC.OA_PROC\tNUM_RESULT_SETS\t6\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROC\tNUM_RESULT_SETS\tmmuuid:55b0d608-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tElementProperties\tSystem.ElementProperties\tGroupUpperName\t8\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tGROUPUPPERNAME\tmmuuid:55bac480-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tElementProperties\tSystem.ElementProperties\tElementUpperName\t7\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTPROPERTIES\tELEMENTUPPERNAME\tmmuuid:55bac481-c59f-1de7-b515-bad6cb0abb8d\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_LENGTH\t9\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROCCOLUMNS\tOA_LENGTH\tmmuuid:56a4fa01-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_PRECISION\t8\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROCCOLUMNS\tOA_PRECISION\tmmuuid:56a4fa02-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tCOLUMN_NAME\t4\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROCCOLUMNS\tCOLUMN_NAME\tmmuuid:56a4fa03-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tREMARKS\t14\tnull\tstring\t0\t254\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t254\t254\t10\tOA_PROCCOLUMNS\tREMARKS\tmmuuid:56a4fa04-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROCCOLUMNS\tOA_NAME\tmmuuid:56a4fa05-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_RADIX\t10\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROCCOLUMNS\tOA_RADIX\tmmuuid:56a4fa06-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tDATA_TYPE\t6\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_PROCCOLUMNS\tDATA_TYPE\tmmuuid:56a4fa07-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_SCALE\t11\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_PROCCOLUMNS\tOA_SCALE\tmmuuid:56a4fa08-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_SCOPE\t13\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_PROCCOLUMNS\tOA_SCOPE\tmmuuid:56a4fa09-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tTYPE_NAME\t7\tnull\tstring\t0\t100\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tOA_PROCCOLUMNS\tTYPE_NAME\tmmuuid:56a4fa0a-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROCCOLUMNS\tOA_QUALIFIER\tmmuuid:56a4fa0b-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_PROCCOLUMNS\tOA_OWNER\tmmuuid:56a4fa0c-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_NULLABLE\t12\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_PROCCOLUMNS\tOA_NULLABLE\tmmuuid:56a4fa0d-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_PROCCOLUMNS\tSystem.ODBC.OA_PROCCOLUMNS\tOA_COLUMNTYPE\t5\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_PROCCOLUMNS\tOA_COLUMNTYPE\tmmuuid:56a4fa0e-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tCREATE_PARAMS\t6\tnull\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tOA_TYPES\tCREATE_PARAMS\tmmuuid:57991e01-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tLITERAL_PREFIX\t4\tnull\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tOA_TYPES\tLITERAL_PREFIX\tmmuuid:57991e02-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tAUTO_INCREMENT\t12\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tAUTO_INCREMENT\tmmuuid:57991e03-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tOA_MONEY\t11\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tOA_MONEY\tmmuuid:57991e04-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tMINIMUM_SCALE\t13\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tMINIMUM_SCALE\tmmuuid:57991e05-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tOA_PRECISION\t3\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tOA_TYPES\tOA_PRECISION\tmmuuid:57991e06-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tDATA_TYPE\t2\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tDATA_TYPE\tmmuuid:57991e07-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tMAXIMUM_SCALE\t14\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tMAXIMUM_SCALE\tmmuuid:57991e08-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tCASE_SENSITIVE\t8\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tCASE_SENSITIVE\tmmuuid:57991e09-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tLOCAL_TYPE_NAME\t15\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_TYPES\tLOCAL_TYPE_NAME\tmmuuid:57991e0a-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tLITERAL_SUFFIX\t5\tnull\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tOA_TYPES\tLITERAL_SUFFIX\tmmuuid:57991e0b-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tUNSIGNED_ATTRIB\t10\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tUNSIGNED_ATTRIB\tmmuuid:57991e0c-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tTYPE_NAME\t1\tnull\tstring\t0\t100\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tOA_TYPES\tTYPE_NAME\tmmuuid:57991e0d-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tOA_NULLABLE\t7\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tOA_NULLABLE\tmmuuid:57991e0e-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_TYPES\tSystem.ODBC.OA_TYPES\tOA_SEARCHABLE\t9\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_TYPES\tOA_SEARCHABLE\tmmuuid:57991e0f-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tNON_UNIQUE\t4\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_STATISTICS\tNON_UNIQUE\tmmuuid:57991e11-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tOA_PAGES\t12\tnull\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tOA_STATISTICS\tOA_PAGES\tmmuuid:57991e12-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tINDEX_NAME\t6\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tINDEX_NAME\tmmuuid:57991e13-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tSEQ_IN_INDEX\t8\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_STATISTICS\tSEQ_IN_INDEX\tmmuuid:57991e14-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tOA_COLLATION\t10\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tOA_COLLATION\tmmuuid:57991e15-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tOA_CARDINALITY\t11\tnull\tstring\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tOA_STATISTICS\tOA_CARDINALITY\tmmuuid:57991e16-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tTABLE_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tTABLE_OWNER\tmmuuid:57991e17-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tCOLUMN_NAME\t9\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tCOLUMN_NAME\tmmuuid:57991e18-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tTABLE_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tTABLE_NAME\tmmuuid:57991e19-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tOA_TYPE\t7\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_STATISTICS\tOA_TYPE\tmmuuid:57991e1a-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tINDEX_QUALIFIER\t5\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tINDEX_QUALIFIER\tmmuuid:57991e1b-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tTABLE_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tTABLE_QUALIFIER\tmmuuid:57991e1c-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_STATISTICS\tSystem.ODBC.OA_STATISTICS\tFILTER_CONDITIONS\t13\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_STATISTICS\tFILTER_CONDITIONS\tmmuuid:57991e1d-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tKeyElements\tSystem.KeyElements\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYELEMENTS\tMODELNAME\tmmuuid:57c33242-ba68-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tGroupName\t6\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYELEMENTS\tGROUPNAME\tmmuuid:57c33243-ba68-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tGroupFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tKEYELEMENTS\tGROUPFULLNAME\tmmuuid:57c33244-ba68-1de7-b705-ef2376c3949e\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tKEY_SEQ\t9\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_FKEYS\tKEY_SEQ\tmmuuid:587dffc1-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tPK_NAME\t13\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tPK_NAME\tmmuuid:587dffc2-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tFKTABLE_QUALIFIER\t5\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tFKTABLE_QUALIFIER\tmmuuid:587dffc3-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tFKTABLE_NAME\t7\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tFKTABLE_NAME\tmmuuid:587dffc4-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tFKTABLE_OWNER\t6\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tFKTABLE_OWNER\tmmuuid:587dffc5-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tPKCOLUMN_NAME\t4\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tPKCOLUMN_NAME\tmmuuid:587dffc6-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tFK_NAME\t12\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tFK_NAME\tmmuuid:587dffc7-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tPKTABLE_OWNER\t2\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tPKTABLE_OWNER\tmmuuid:587dffc8-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tUPDATE_RULE\t10\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_FKEYS\tUPDATE_RULE\tmmuuid:587dffc9-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tDELETE_RULE\t11\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tOA_FKEYS\tDELETE_RULE\tmmuuid:587dffca-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tFKCOLUMN_NAME\t8\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tFKCOLUMN_NAME\tmmuuid:587dffcb-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tPKTABLE_NAME\t3\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tPKTABLE_NAME\tmmuuid:587dffcc-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tOA_FKEYS\tSystem.ODBC.OA_FKEYS\tPKTABLE_QUALIFIER\t1\tnull\tstring\t0\t128\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t128\t128\t10\tOA_FKEYS\tPKTABLE_QUALIFIER\tmmuuid:587dffcd-2ca5-1f8d-a539-a73e664462a1\tnull", "System\tKeyElements\tSystem.KeyElements\tKeyName\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYELEMENTS\tKEYNAME\tmmuuid:58a81400-ba68-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tRefKeyUID\t8\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tKEYELEMENTS\tREFKEYUID\tmmuuid:58a81402-ba68-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tUID\t9\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tKEYELEMENTS\tUID\tmmuuid:58a81403-ba68-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tGroupUpperName\t7\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYELEMENTS\tGROUPUPPERNAME\tmmuuid:58a81404-ba68-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tTypeLength\t9\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t(0)\tjava.lang.Integer\t10\t10\t10\tPROCEDUREPARAMS\tTYPELENGTH\tmmuuid:5e0fac00-634e-1e44-a903-c1472e78d1c5\tnull", "System\tProcedures\tSystem.Procedures\tDescription\t7\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t225\t255\t10\tPROCEDURES\tDESCRIPTION\tmmuuid:61164b00-3ab4-1edb-8606-be949cc6da52\tnull", "System\tDataTypeProperties\tSystem.DataTypeProperties\tDataType\t1\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tDATATYPEPROPERTIES\tDATATYPE\tmmuuid:6609d102-c90a-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeProperties\tSystem.DataTypeProperties\tName\t2\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPEPROPERTIES\tNAME\tmmuuid:6609d103-c90a-1de7-ad1c-f3ce4292824e\tnull", "System\tDataTypeProperties\tSystem.DataTypeProperties\tValue\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tDATATYPEPROPERTIES\tVALUE\tmmuuid:6609d106-c90a-1de7-ad1c-f3ce4292824e\tnull", "System\tModels\tSystem.Models\tSupportsWhereAll\t3\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tSUPPORTSWHEREALL\tmmuuid:6b529981-b67c-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tSupportsOrderBy\t4\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tSUPPORTSORDERBY\tmmuuid:6c377b40-b67c-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tSupportsJoin\t5\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tSUPPORTSJOIN\tmmuuid:6c377b42-b67c-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tSupportsDistinct\t6\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tSUPPORTSDISTINCT\tmmuuid:6c377b43-b67c-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tSupportsOuterJoin\t7\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tSUPPORTSOUTERJOIN\tmmuuid:6c377b44-b67c-1de7-b705-ef2376c3949e\tnull", "System\tProcedures\tSystem.Procedures\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDURES\tMODELNAME\tmmuuid:7a19a9c2-b863-1de7-b705-ef2376c3949e\tnull", "System\tProcedures\tSystem.Procedures\tName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDURES\tNAME\tmmuuid:7a19a9c3-b863-1de7-b705-ef2376c3949e\tnull", "System\tProcedures\tSystem.Procedures\tModelUID\t5\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tPROCEDURES\tMODELUID\tmmuuid:7a19a9c6-b863-1de7-b705-ef2376c3949e\tnull", "System\tProcedures\tSystem.Procedures\tReturnsResults\t4\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tPROCEDURES\tRETURNSRESULTS\tmmuuid:7afe8b81-b863-1de7-b705-ef2376c3949e\tnull", "System\tProcedures\tSystem.Procedures\tUID\t6\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tPROCEDURES\tUID\tmmuuid:7afe8b83-b863-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tMODELNAME\tmmuuid:7b0da102-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tGroupName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tGROUPNAME\tmmuuid:7b0da103-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tGroupFullName\t3\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tELEMENTS\tGROUPFULLNAME\tmmuuid:7b0da104-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tName\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tNAME\tmmuuid:7b0da105-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tPosition\t5\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tPOSITION\tmmuuid:7b0da106-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tDataType\t7\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tELEMENTS\tDATATYPE\tmmuuid:7bf282c3-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tScale\t8\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tSCALE\tmmuuid:7bf282c4-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tElementLength\t9\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tELEMENTLENGTH\tmmuuid:7bf282c5-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tIsLengthFixed\t10\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tISLENGTHFIXED\tmmuuid:7bf282c7-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tSupportsSelect\t11\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tSUPPORTSSELECT\tmmuuid:7bf282c8-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tSupportsUpdates\t12\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tSUPPORTSUPDATES\tmmuuid:7ce6a6c0-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tIsCaseSensitive\t13\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tISCASESENSITIVE\tmmuuid:7ce6a6c1-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tIsSigned\t14\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tISSIGNED\tmmuuid:7ce6a6c2-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tIsCurrency\t15\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tISCURRENCY\tmmuuid:7ce6a6c3-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tIsAutoIncremented\t16\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tELEMENTS\tISAUTOINCREMENTED\tmmuuid:7ce6a6c4-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tNullType\t17\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tELEMENTS\tNULLTYPE\tmmuuid:7ce6a6c5-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tMinRange\t18\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tELEMENTS\tMINRANGE\tmmuuid:7ce6a6c6-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tMaxRange\t19\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tELEMENTS\tMAXRANGE\tmmuuid:7ce6a6c7-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tSearchType\t20\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tELEMENTS\tSEARCHTYPE\tmmuuid:7ce6a6c8-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tFormat\t21\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tFORMAT\tmmuuid:7ce6a6c9-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tDefaultValue\t22\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tDEFAULTVALUE\tmmuuid:7ddacac1-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tJavaClass\t23\tnull\tstring\t0\t500\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t500\t500\t10\tELEMENTS\tJAVACLASS\tmmuuid:7ddacac2-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tUID\t29\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tELEMENTS\tUID\tmmuuid:7ddacac3-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tPrecision\t24\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tPRECISION\tmmuuid:7ddacac5-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tElements\tSystem.Elements\tRadix\t26\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tRADIX\tmmuuid:7ddacac7-b9b3-1de7-b705-ef2376c3949e\tnull", "System\tVirtualDatabases\tSystem.VirtualDatabases\tName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tVIRTUALDATABASES\tNAME\tmmuuid:8cfee540-c1d3-1de7-b515-bad6cb0abb8d\tnull", "System\tVirtualDatabases\tSystem.VirtualDatabases\tVersion\t2\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tVIRTUALDATABASES\tVERSION\tmmuuid:8cfee541-c1d3-1de7-b515-bad6cb0abb8d\tnull", "System\tElements\tSystem.Elements\tNameInSource\t6\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tNAMEINSOURCE\tmmuuid:8f854500-3416-1dee-8e07-e3cb3008f82b\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tType\t6\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tPROCEDUREPARAMS\tTYPE\tmmuuid:91fce1c0-6663-1de8-a732-e7f41500bc3a\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tScale\t10\tnull\tinteger\t0\t10\ttrue\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t(0)\tjava.lang.Integer\t10\t10\t10\tPROCEDUREPARAMS\tSCALE\tmmuuid:95044680-634e-1e44-a903-c1472e78d1c5\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPARAMS\tMODELNAME\tmmuuid:959eca00-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tProcedureName\t2\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPARAMS\tPROCEDURENAME\tmmuuid:959eca01-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tPROCEDUREPARAMS\tNAME\tmmuuid:959eca03-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tDataType\t4\tnull\tstring\t0\t25\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t25\t25\t10\tPROCEDUREPARAMS\tDATATYPE\tmmuuid:959eca04-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tPosition\t5\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tPROCEDUREPARAMS\tPOSITION\tmmuuid:959eca06-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tOptional\t7\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tPROCEDUREPARAMS\tOPTIONAL\tmmuuid:959eca08-b8f3-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tNameInSource\t5\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tNAMEINSOURCE\tmmuuid:9a749d40-3424-1dee-8e07-e3cb3008f82b\tnull", "System\tKeyProperties\tSystem.KeyProperties\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYPROPERTIES\tMODELNAME\tmmuuid:9ba7aa01-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tFKTABLE_CAT\t5\tnull\tstring\t0\t1\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t1\t1\t10\tREFERENCEKEYCOLUMNS\tFKTABLE_CAT\tmmuuid:9d4fe981-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tDELETE_RULE\t11\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tREFERENCEKEYCOLUMNS\tDELETE_RULE\tmmuuid:9d4fe982-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tFKTABLE_SCHEM\t6\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tFKTABLE_SCHEM\tmmuuid:9d4fe983-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tPK_NAME\t13\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tPK_NAME\tmmuuid:9d4fe984-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tFKCOLUMN_NAME\t8\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tFKCOLUMN_NAME\tmmuuid:9d4fe985-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tPKTABLE_NAME\t3\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tPKTABLE_NAME\tmmuuid:9d4fe986-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tFK_NAME\t12\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tFK_NAME\tmmuuid:9d4fe987-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tKEY_SEQ\t9\tnull\tshort\t0\t5\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Short\t5\t5\t10\tREFERENCEKEYCOLUMNS\tKEY_SEQ\tmmuuid:9d4fe988-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tPKTABLE_CAT\t1\tnull\tstring\t0\t1\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t1\t1\t10\tREFERENCEKEYCOLUMNS\tPKTABLE_CAT\tmmuuid:9d4fe989-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tUPDATE_RULE\t10\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tREFERENCEKEYCOLUMNS\tUPDATE_RULE\tmmuuid:9d4fe98a-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tFKTABLE_NAME\t7\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tFKTABLE_NAME\tmmuuid:9d4fe98b-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tDEFERRABILITY\t14\tnull\tinteger\t0\t10\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tREFERENCEKEYCOLUMNS\tDEFERRABILITY\tmmuuid:9d4fe98c-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tPKCOLUMN_NAME\t4\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tPKCOLUMN_NAME\tmmuuid:9d4fe98d-2c99-1f8d-a539-a73e664462a1\tnull", "System\tReferenceKeyColumns\tSystem.JDBC.ReferenceKeyColumns\tPKTABLE_SCHEM\t2\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tREFERENCEKEYCOLUMNS\tPKTABLE_SCHEM\tmmuuid:9d4fe98e-2c99-1f8d-a539-a73e664462a1\tnull", "System\tKeyProperties\tSystem.KeyProperties\tGroupFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tKEYPROPERTIES\tGROUPFULLNAME\tmmuuid:9d80afc0-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeys\tSystem.Keys\tType\t6\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tKEYS\tTYPE\tmmuuid:9e0dce80-ce82-1de7-8c2d-d908d66ab0ba\tnull", "System\tGroups\tSystem.Groups\tIsMaterialized\t13\tnull\tboolean\t0\t0\tfalse\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t0\t0\t10\tGROUPS\tISMATERIALIZED\tmmuuid:9e5c3980-04e6-101e-861a-a893857ac5a5\tnull", "System\tKeyProperties\tSystem.KeyProperties\tKeyName\t3\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t255\t10\tKEYPROPERTIES\tKEYNAME\tmmuuid:9e74d3c0-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeyProperties\tSystem.KeyProperties\tName\t4\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t255\t10\tKEYPROPERTIES\tNAME\tmmuuid:9e74d3c5-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeyProperties\tSystem.KeyProperties\tValue\t5\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t255\t10\tKEYPROPERTIES\tVALUE\tmmuuid:9e74d3ca-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeyProperties\tSystem.KeyProperties\tGroupName\t6\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYPROPERTIES\tGROUPNAME\tmmuuid:9e74d3cf-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeyProperties\tSystem.KeyProperties\tGroupUpperName\t7\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYPROPERTIES\tGROUPUPPERNAME\tmmuuid:9e74d3d4-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tKeyProperties\tSystem.KeyProperties\tUID\t8\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tKEYPROPERTIES\tUID\tmmuuid:9f68f7c0-1142-1ff5-a438-98ce9bfae8da\tnull", "System\tModels\tSystem.Models\tPrimaryMetamodelURI\t11\tnull\tstring\t0\t255\tfalse\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tMODELS\tPRIMARYMETAMODELURI\tmmuuid:a5682040-ea71-1ee5-b836-ce1850f9b1e5\tnull", "System\tProcedures\tSystem.Procedures\tFullName\t8\tnull\tstring\t0\t2048\tfalse\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tPROCEDURES\tFULLNAME\tmmuuid:af58c3c0-23d0-1f11-bb31-8e2670f95fb1\tnull", "System\tGroups\tSystem.Groups\tDescription\t11\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPS\tDESCRIPTION\tmmuuid:afce0780-3a4e-1edb-8606-be949cc6da52\tnull", "System\tGroups\tSystem.Groups\tUID\t9\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tGROUPS\tUID\tmmuuid:b1e4e240-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPS\tMODELNAME\tmmuuid:b1e4e243-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tGROUPS\tFULLNAME\tmmuuid:b1e4e244-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPS\tNAME\tmmuuid:b1e4e245-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tIsPhysical\t6\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tGROUPS\tISPHYSICAL\tmmuuid:b1e4e248-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tCardinality\t10\tnull\tinteger\t0\t10\tfalse\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tAll Except Like\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tGROUPS\tCARDINALITY\tmmuuid:b2d85ec0-ebd5-1eda-b235-cf50afc035e1\tnull", "System\tGroups\tSystem.Groups\tUpperName\t7\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPS\tUPPERNAME\tmmuuid:b2d90641-ec67-1de9-9115-ad36abcfb081\tnull", "System\tGroups\tSystem.Groups\tType\t4\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tGROUPS\tTYPE\tmmuuid:b2d90642-ec67-1de9-9115-ad36abcfb081\tnull", "System\tElements\tSystem.Elements\tCharOctetLength\t25\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tELEMENTS\tCHAROCTETLENGTH\tmmuuid:c0b5e1c0-cdd8-1de7-8c2d-d908d66ab0ba\tnull", "System\tGroups\tSystem.Groups\tNameInSource\t5\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPS\tNAMEINSOURCE\tmmuuid:c143df00-3409-1dee-8e07-e3cb3008f82b\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tRadix\t11\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tPROCEDUREPARAMS\tRADIX\tmmuuid:c65e8d80-634e-1e44-a903-c1472e78d1c5\tnull", "System\tGroupProperties\tSystem.GroupProperties\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPPROPERTIES\tMODELNAME\tmmuuid:c8e43042-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tGroupName\t5\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPPROPERTIES\tGROUPNAME\tmmuuid:c8e43043-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tGroupFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tGROUPPROPERTIES\tGROUPFULLNAME\tmmuuid:c8e43044-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPPROPERTIES\tNAME\tmmuuid:c8e43045-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tUID\t7\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tGROUPPROPERTIES\tUID\tmmuuid:c8e43046-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tValue\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPPROPERTIES\tVALUE\tmmuuid:c8e43048-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tGroupProperties\tSystem.GroupProperties\tGroupUpperName\t6\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tGROUPPROPERTIES\tGROUPUPPERNAME\tmmuuid:c8e43049-c509-1de7-b515-bad6cb0abb8d\tnull", "System\tModels\tSystem.Models\tIsPhysical\t2\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tMODELS\tISPHYSICAL\tmmuuid:d5a73440-b6b7-1de7-b705-ef2376c3949e\tnull", "System\tModels\tSystem.Models\tMaxSetSize\t8\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tMODELS\tMAXSETSIZE\tmmuuid:d5a73442-b6b7-1de7-b705-ef2376c3949e\tnull", "System\tKeyElements\tSystem.KeyElements\tKeyType\t5\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tKEYELEMENTS\tKEYTYPE\tmmuuid:db288f80-ce87-1de7-8c2d-d908d66ab0ba\tnull", "System\tDataTypeProperties\tSystem.DataTypeProperties\tUID\t4\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPEPROPERTIES\tUID\tmmuuid:dba25280-a5e0-1e42-ba2a-a0f062ab71df\tnull", "System\tDataTypes\tSystem.DataTypes\tRuntimeType\t16\tnull\tstring\t0\t64\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t64\t64\t10\tDATATYPES\tRUNTIMETYPE\tmmuuid:de321500-e584-1e20-b806-d8b2a0a91d66\tnull", "System\tDataTypes\tSystem.DataTypes\tIsStandard\t2\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tDATATYPES\tISSTANDARD\tmmuuid:e21059c5-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tIsPhysical\t3\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tDATATYPES\tISPHYSICAL\tmmuuid:e2f53b80-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tTypeName\t4\tnull\tstring\t0\t100\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t100\t100\t10\tDATATYPES\tTYPENAME\tmmuuid:e2f53b81-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tScale\t6\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\t(0)\tjava.lang.Integer\t10\t10\t10\tDATATYPES\tSCALE\tmmuuid:e2f53b82-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tNullType\t8\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tDATATYPES\tNULLTYPE\tmmuuid:e2f53b84-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tIsSigned\t9\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t('0')\tjava.lang.Boolean\t1\t1\t10\tDATATYPES\tISSIGNED\tmmuuid:e2f53b85-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tIsAutoIncremented\t10\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t('0')\tjava.lang.Boolean\t1\t1\t10\tDATATYPES\tISAUTOINCREMENTED\tmmuuid:e2f53b86-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tIsCaseSensitive\t11\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\t('0')\tjava.lang.Boolean\t1\t1\t10\tDATATYPES\tISCASESENSITIVE\tmmuuid:e2f53b87-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tJavaClass\t5\tnull\tstring\t0\t500\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t500\t500\t10\tDATATYPES\tJAVACLASS\tmmuuid:e3e95f82-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tUID\t15\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tDATATYPES\tUID\tmmuuid:e3e95f83-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tPrecision\t12\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tDATATYPES\tPRECISION\tmmuuid:e3e95f84-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tRadix\t13\tnull\tinteger\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Integer\t10\t10\t10\tDATATYPES\tRADIX\tmmuuid:e3e95f85-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tSearchType\t14\tnull\tstring\t0\t20\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t20\t20\t10\tDATATYPES\tSEARCHTYPE\tmmuuid:e3e95f87-b80e-1de7-b705-ef2376c3949e\tnull", "System\tDataTypes\tSystem.DataTypes\tDescription\t18\tnull\tstring\t0\t255\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tDATATYPES\tDESCRIPTION\tmmuuid:e81d8400-3a83-1edb-8606-be949cc6da52\tnull", "System\tDataTypes\tSystem.DataTypes\tBaseType\t17\tnull\tstring\t0\t64\ttrue\ttrue\tfalse\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t64\t64\t10\tDATATYPES\tBASETYPE\tmmuuid:e8729800-e584-1e20-b806-d8b2a0a91d66\tnull", "System\tElements\tSystem.Elements\tGroupUpperName\t27\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tGROUPUPPERNAME\tmmuuid:e92fbb00-c2a0-1de7-b515-bad6cb0abb8d\tnull", "System\tElements\tSystem.Elements\tUpperName\t28\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tELEMENTS\tUPPERNAME\tmmuuid:ea23df00-c2a0-1de7-b515-bad6cb0abb8d\tnull", "System\tKeyElements\tSystem.KeyElements\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYELEMENTS\tNAME\tmmuuid:ed887840-c318-1de7-b515-bad6cb0abb8d\tnull", "System\tGroups\tSystem.Groups\tIsSystem\t12\tnull\tboolean\t0\t1\tfalse\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tGROUPS\tISSYSTEM\tmmuuid:ee427900-7eec-1eea-940e-bcb0b71c723a\tnull", "System\tProcedureParams\tSystem.ProcedureParams\tNullType\t12\tnull\tstring\t0\t10\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t10\t10\t10\tPROCEDUREPARAMS\tNULLTYPE\tmmuuid:f8acf880-634e-1e44-a903-c1472e78d1c5\tnull", "PartsSupplier\tPARTS\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_ID\t1\tPART_ID\tstring\t0\t4\ttrue\ttrue\ttrue\ttrue\ttrue\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t0\t4\t10\tPARTS\tPART_ID\tmmuuid:fadcd7c0-73fe-1edc-a81c-ecf397b10590\tnull", "System\tKeys\tSystem.Keys\tModelName\t1\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tMODELNAME\tmmuuid:fe2c6482-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tGroupName\t8\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tGROUPNAME\tmmuuid:fe2c6483-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tGroupFullName\t2\tnull\tstring\t0\t2048\ttrue\ttrue\tfalse\ttrue\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t2048\t2048\t10\tKEYS\tGROUPFULLNAME\tmmuuid:fe2c6484-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tName\t3\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tNAME\tmmuuid:fe2c6485-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tDescription\t4\tnull\tstring\t0\t255\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t255\t255\t10\tKEYS\tDESCRIPTION\tmmuuid:fe2c6486-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tIsIndexed\t7\tnull\tboolean\t0\t1\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.Boolean\t1\t1\t10\tKEYS\tISINDEXED\tmmuuid:ff208881-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tRefKeyUID\t10\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNullable\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tKEYS\tREFKEYUID\tmmuuid:ff208882-b9eb-1de7-b705-ef2376c3949e\tnull", "System\tKeys\tSystem.Keys\tUID\t11\tnull\tstring\t0\t50\ttrue\ttrue\tfalse\tfalse\tfalse\tfalse\tfalse\tNo Nulls\tnull\tnull\tSearchable\tnull\tnull\tjava.lang.String\t50\t50\t10\tKEYS\tUID\tmmuuid:ff208884-b9eb-1de7-b705-ef2376c3949e\tnull"};
        this.executeAndAssertResults("select* from System.Elements order by UID", expected);
    }

    @Test
    public void testGroupType() {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from System.Groups order by Type", expected);
    }

    @Test
    public void testGroupIsSystem() {
        String[] expected = new String[]{"Name[string]\t", "PARTS", "SHIP_VIA", "STATUS", "SUPPLIER", "SUPPLIER_PARTS"};
        this.executeAndAssertResults("select Name from System.Groups where IsSystem = 'false' order by Name", expected);
    }

    @Test
    public void test_OA_PROC() {
        String[] expected = new String[]{"OA_QUALIFIER[string]\tOA_OWNER[string]\tOA_NAME[string]\tNUM_INPUT_PARAMS[integer]\tNUM_OUTPUT_PARAMS[integer]\tNUM_RESULT_SETS[integer]\tREMARKS[string]\tPROCEDURE_TYPE[short]", "PartsSupplier\tSystem\tdescribe\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetBinaryVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetCharacterVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetVDBResourcePaths\t0\t0\t0\tnull\t1"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_PROC", expected);
    }

    @Test
    public void test_OA_PROCCOLUMNS() {
        String[] expected = new String[]{"OA_QUALIFIER[string]\tOA_OWNER[string]\tOA_NAME[string]\tCOLUMN_NAME[string]\tOA_COLUMNTYPE[short]\tDATA_TYPE[short]\tTYPE_NAME[string]\tOA_PRECISION[integer]\tOA_LENGTH[integer]\tOA_RADIX[integer]\tOA_SCALE[integer]\tOA_NULLABLE[short]\tOA_SCOPE[short]\tREMARKS[string]", "PartsSupplier\tSystem\tdescribe\tDescription\t0\t12\tVARCHAR\t128\t128\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tdescribe\tentity\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetBinaryVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetBinaryVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetCharacterVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetCharacterVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\ttokenReplacements\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\ttokens\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetVDBResourcePaths\tResourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetVDBResourcePaths\tisBinary\t0\t5\tSMALLINT\t1\t1\t10\t0\t1\t0"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_PROCCOLUMNS ORDER BY OA_NAME, COLUMN_NAME ", expected);
    }

    @Test
    public void testOATYPES() {
        String[] expected = new String[]{"TYPE_NAME[string]\tDATA_TYPE[short]\tPRECISION[integer]\tLITERAL_PREFIX[string]\tLITERAL_SUFFIX[string]\tCREATE_PARAMS[string]\tNULLABLE[short]\tCASE_SENSITIVE[short]\tSEARCHABLE[short]\tUNSIGNED_ATTRIBUTE[short]\tMONEY[short]\tAUTO_INCREMENT[short]\tLOCAL_TYPE_NAME[string]\tMINIMUM_SCALE[short]\tMAXIMUM_SCALE[short]"};
        this.executeAndAssertResults("select TYPE_NAME, DATA_TYPE, OA_PRECISION as PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX,  CREATE_PARAMS, OA_NULLABLE as NULLABLE, CASE_SENSITIVE, OA_SEARCHABLE as SEARCHABLE,  UNSIGNED_ATTRIB as UNSIGNED_ATTRIBUTE, OA_MONEY as MONEY, AUTO_INCREMENT, LOCAL_TYPE_NAME,  MINIMUM_SCALE, MAXIMUM_SCALE  FROM System.ODBC.OA_TYPES  WHERE DATA_TYPE = -6", expected);
    }

    @Test
    public void testOACOLUMNSAll() {
        String[] expected = new String[]{"TABLE_QUALIFIER[string]\tTABLE_OWNER[string]\tTABLE_NAME[string]\tCOLUMN_NAME[string]\tDATA_TYPE[short]\tTYPE_NAME[string]\tOA_LENGTH[integer]\tOA_PRECISION[integer]\tOA_SCALE[integer]\tOA_RADIX[integer]\tOA_NULLABLE[short]\tOA_SCOPE[short]\tPSEUDO_COLUMN[short]\tOA_COLUMNTYPE[short]\tREMARKS[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_COLOR\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\t12\tVARCHAR\t4\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_NAME\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_WEIGHT\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_ID\t5\tSMALLINT\t0\t2\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\t5\tSMALLINT\t0\t2\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_CITY\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\t12\tVARCHAR\t10\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATE\t12\tVARCHAR\t2\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATUS\t5\tSMALLINT\t0\t2\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\t12\tVARCHAR\t4\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tQUANTITY\t5\tSMALLINT\t0\t3\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSHIPPER_ID\t5\tSMALLINT\t0\t2\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\t12\tVARCHAR\t10\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tDataTypeElementName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tDataTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tName\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tDataTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tElementLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tDataType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tName\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tBaseType\t12\tVARCHAR\t64\t64\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsAutoIncremented\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsCaseSensitive\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsSigned\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsStandard\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tJavaClass\t12\tVARCHAR\t500\t500\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tNullType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tRadix\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tRuntimeType\t12\tVARCHAR\t64\t64\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tScale\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tSearchType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tTypeLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tElementName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tElementUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tCharOctetLength\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDataType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDefaultValue\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tElementLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tFormat\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsAutoIncremented\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsCaseSensitive\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsCurrency\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsLengthFixed\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsSigned\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tJavaClass\t12\tVARCHAR\t500\t500\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tMaxRange\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tMinRange\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tNullType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tRadix\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSearchType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSupportsSelect\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSupportsUpdates\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tCardinality\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsMaterialized\t5\tSMALLINT\t0\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsSystem\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tSupportsUpdates\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tKeyName\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tKeyType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tRefKeyUID\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tKeyName\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tName\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tValue\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tIsIndexed\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tRefKeyUID\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tMaxSetSize\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tPrimaryMetamodelURI\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsDistinct\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsJoin\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsOrderBy\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsOuterJoin\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsWhereAll\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tDataType\t12\tVARCHAR\t25\t25\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tNullType\t12\tVARCHAR\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tOptional\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tProcedureName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tRadix\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tTypeLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tProcedureName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tDescription\t12\tVARCHAR\t255\t225\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tModelUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tReturnsResults\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tVirtualDatabases\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tVirtualDatabases\tVersion\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tDEFERRABILITY\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tDELETE_RULE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKCOLUMN_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_CAT\t12\tVARCHAR\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_SCHEM\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFK_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tKEY_SEQ\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKCOLUMN_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_CAT\t12\tVARCHAR\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_SCHEM\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPK_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tUPDATE_RULE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_COLUMNTYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_LENGTH\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_RADIX\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_SCALE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_SCOPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tPSEUDO_COLUMN\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tDELETE_RULE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFK_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tKEY_SEQ\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPK_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tUPDATE_RULE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_INPUT_PARAMS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_OUTPUT_PARAMS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_RESULT_SETS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tPROCEDURE_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_COLUMNTYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_LENGTH\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_RADIX\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_SCALE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_SCOPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tFILTER_CONDITIONS\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tINDEX_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tINDEX_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tNON_UNIQUE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_CARDINALITY\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_COLLATION\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_PAGES\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tSEQ_IN_INDEX\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_TYPE\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tAUTO_INCREMENT\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tCASE_SENSITIVE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tCREATE_PARAMS\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLITERAL_PREFIX\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLITERAL_SUFFIX\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLOCAL_TYPE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tMAXIMUM_SCALE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tMINIMUM_SCALE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_MONEY\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_SEARCHABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tUNSIGNED_ATTRIB\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_COLUMNS ORDER BY TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, COLUMN_NAME", expected);
    }

    @Test
    public void testOATYPESAll() {
        String[] expected = new String[]{"TYPE_NAME[string]\tDATA_TYPE[short]\tOA_PRECISION[integer]\tLITERAL_PREFIX[string]\tLITERAL_SUFFIX[string]\tCREATE_PARAMS[string]\tOA_NULLABLE[short]\tCASE_SENSITIVE[short]\tOA_SEARCHABLE[short]\tUNSIGNED_ATTRIB[short]\tOA_MONEY[short]\tAUTO_INCREMENT[short]\tMINIMUM_SCALE[short]\tMAXIMUM_SCALE[short]\tLOCAL_TYPE_NAME[string]", "CHAR\t1\t2147483647\t'\t'\tnull\t1\t1\t3\t0\t0\t0\tnull\tnull\tCHAR", "DATE\t9\t10\t{d '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tDATE", "DOUBLE\t8\t15\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tDOUBLE", "FLOAT\t6\t15\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tFLOAT", "INTEGER\t4\t10\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tINTEGER", "LONGVARBINARY\t-4\t2147483647\t0x\tnull\tnull\t1\t0\t0\t0\t0\t0\tnull\tnull\tnull", "NUMERIC\t2\t32\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\t0\t32\tNUMERIC", "REAL\t7\t7\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tREAL", "SMALLINT\t5\t5\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tSMALLINT", "TIME\t10\t8\t{t '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tTIME", "TIMESTAMP\t11\t19\t{ts '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tTIMESTAMP", "VARCHAR\t12\t2147483647\t'\t'\tnull\t1\t1\t3\t0\t0\t0\tnull\tnull\tVARCHAR"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_TYPES ORDER BY TYPE_NAME", expected);
    }

    @Test
    public void testOAFKEYS() {
        String[] expected = new String[]{"PKTABLE_QUALIFIER[string]\tPKTABLE_OWNER[string]\tPKTABLE_NAME[string]\tPKCOLUMN_NAME[string]\tFKTABLE_QUALIFIER[string]\tFKTABLE_OWNER[string]\tFKTABLE_NAME[string]\tFKCOLUMN_NAME[string]\tKEY_SEQ[short]\tUPDATE_RULE[short]\tDELETE_RULE[short]\tFK_NAME[string]\tPK_NAME[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\t1\tnull\tnull\tFK_SPLIER_PRTS_PRTS\tPK_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SHIP_VIA", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_STATUS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATUS\t1\tnull\tnull\tFK_SPLIER_STATS\tPK_STATUS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SUPPLIER", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\t1\tnull\tnull\tFK_SPLY_PRTS_SPLY\tPK_SUPPLIER", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SUPPLIER_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t2\tnull\tnull\tnull\tPK_SUPPLIER_PARTS"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_FKEYS ORDER BY PK_NAME, KEY_SEQ", expected);
    }

    @Test
    public void testOASTATISTICS() {
        String[] expected = new String[]{"TABLE_QUALIFIER[string]\tTABLE_OWNER[string]\tTABLE_NAME[string]\tNON_UNIQUE[short]\tINDEX_QUALIFIER[string]\tINDEX_NAME[string]\tOA_TYPE[short]\tSEQ_IN_INDEX[short]\tCOLUMN_NAME[string]\tOA_COLLATION[string]\tOA_CARDINALITY[string]\tOA_PAGES[string]\tFILTER_CONDITIONS[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\t0\t\tPK_SHIP_VIA\t3\t1\tSHIPPER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\t0\t\tPK_STATUS\t3\t1\tSTATUS_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\t0\t\tPK_SUPPLIER\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\t1\t\tFK_SPLIER_STATS\t3\t1\tSUPPLIER_STATUS\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t0\t\tPK_SUPPLIER_PARTS\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t1\t\tFK_SPLY_PRTS_SPLY\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t0\t\tPK_SUPPLIER_PARTS\t3\t2\tPART_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t1\t\tFK_SPLIER_PRTS_PRTS\t3\t1\tPART_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\t0\t\tPK_PARTS\t3\t1\tPART_ID\tnull\tnull\tnull"};
        this.executeAndAssertResults("select* FROM System.ODBC.OA_STATISTICS", expected);
    }

    @Test
    public void testDefect12054() {
        String[] expected = new String[]{"PKTABLE_QUALIFIER[string]\tPKTABLE_OWNER[string]\tPKTABLE_NAME[string]\tPKCOLUMN_NAME[string]\tFKTABLE_QUALIFIER[string]\tFKTABLE_OWNER[string]\tFKTABLE_NAME[string]\tFKCOLUMN_NAME[string]\tKEY_SEQ[short]\tUPDATE_RULE[short]\tDELETE_RULE[short]\tFK_NAME[string]\tPK_NAME[string]", "\t\tPARTS\tPART_ID\t\t\tSUPPLIER_PARTS\tPART_ID\t1\tnull\tnull\tFK_SPLIER_PRTS_PRTS\tPK_PARTS", "\t\tSHIP_VIA\tSHIPPER_ID\t\t\tnull\tnull\t1\tnull\tnull\tnull\tPK_SHIP_VIA", "\t\tSTATUS\tSTATUS_ID\t\t\tSUPPLIER\tSUPPLIER_STATUS\t1\tnull\tnull\tFK_SPLIER_STATS\tPK_STATUS", "\t\tSUPPLIER\tSUPPLIER_ID\t\t\tSUPPLIER_PARTS\tSUPPLIER_ID\t1\tnull\tnull\tFK_SPLY_PRTS_SPLY\tPK_SUPPLIER", "\t\tSUPPLIER_PARTS\tSUPPLIER_ID\t\t\tnull\tnull\t1\tnull\tnull\tnull\tPK_SUPPLIER_PARTS", "\t\tSUPPLIER_PARTS\tPART_ID\t\t\tnull\tnull\t2\tnull\tnull\tnull\tPK_SUPPLIER_PARTS", "\t\tSUPPLIER\tSUPPLIER_STATUS\t\t\tnull\tnull\t1\tnull\tnull\tnull\tFK_SPLIER_STATS", "\t\tSUPPLIER_PARTS\tPART_ID\t\t\tnull\tnull\t1\tnull\tnull\tnull\tFK_SPLIER_PRTS_PRTS", "\t\tSUPPLIER_PARTS\tSUPPLIER_ID\t\t\tnull\tnull\t1\tnull\tnull\tnull\tFK_SPLY_PRTS_SPLY"};
        this.executeAndAssertResults("select '' AS PKTABLE_QUALIFIER, '' AS PKTABLE_OWNER, PK.GroupName AS PKTABLE_NAME, PK.Name AS PKCOLUMN_NAME, '' AS FKTABLE_QUALIFIER, '' AS FKTABLE_OWNER, FK.GroupName AS FKTABLE_NAME, FK.Name AS FKCOLUMN_NAME, convert(PK.Position, short) AS KEY_SEQ, convert(null, short) AS UPDATE_RULE, convert(null, short) AS DELETE_RULE, FK.KeyName AS FK_NAME, PK.KeyName AS PK_NAME FROM System.KeyElements AS PK LEFT OUTER JOIN System.KeyElements AS FK ON FK.RefKeyUID = PK.UID", expected);
    }

    @Test
    public void testDefect12064() {
        String[] expected = new String[]{"KeyName[string]\tRefKeyUID[string]\t", "PK_PARTS\tnull", "PK_SHIP_VIA\tnull", "PK_STATUS\tnull", "PK_SUPPLIER\tnull", "PK_SUPPLIER_PARTS\tnull", "PK_SUPPLIER_PARTS\tnull"};
        this.executeAndAssertResults("select KeyName, RefKeyUID FROM System.KeyElements WHERE RefKeyUID IS NULL order by KeyName", expected);
    }

    @Test
    public void testSlowSystemQuery() {
        String[] expected = new String[]{"groupFullName[string]\tSOURCE_NAME[string]\tINFO_CAT_NAME[string]\tCOMMON_SCHEMA_FLAG[string]"};
        this.executeAndAssertResults("select sgp1.groupFullName, sgp1.groupname AS SOURCE_NAME, sgp1.value AS INFO_CAT_NAME, sgp3.value AS COMMON_SCHEMA_FLAG from System.GroupProperties sgp1, System.GroupProperties sgp2, System.GroupProperties sgp3 where sgp1.groupFullName = sgp2.groupFullName and sgp1.groupFullName = sgp3.groupFullName and sgp2.groupFullName = sgp3.groupFullName and sgp1.name='InformationCategory' and sgp2.name = 'presentationMetadataFlag' and sgp2.value = 'true' and sgp3.name = 'infoCatCommonSchemaFlag'", expected);
    }

    @Test
    public void testReferenceKeyColumns() {
        String[] expected = new String[]{"PKTABLE_CAT[string]\tPKTABLE_SCHEM[string]\tPKTABLE_NAME[string]\tPKCOLUMN_NAME[string]\tFKTABLE_CAT[string]\tFKTABLE_SCHEM[string]\tFKTABLE_NAME[string]\tFKCOLUMN_NAME[string]\tKEY_SEQ[short]\tUPDATE_RULE[integer]\tDELETE_RULE[integer]\tFK_NAME[string]\tPK_NAME[string]\tDEFERRABILITY[integer]", "null\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.STATUS\tSTATUS_ID\tnull\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_STATUS\t1\t3\t3\tFK_SPLIER_STATS\tPK_STATUS\t5", "null\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER\tSUPPLIER_ID\tnull\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tSUPPLIER_ID\t1\t3\t3\tFK_SPLY_PRTS_SPLY\tPK_SUPPLIER\t5", "null\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.PARTS\tPART_ID\tnull\tPartsSupplier\tPartsSupplier.PARTSSUPPLIER.SUPPLIER_PARTS\tPART_ID\t1\t3\t3\tFK_SPLIER_PRTS_PRTS\tPK_PARTS\t5"};
        this.executeAndAssertResults("select* FROM System.JDBC.ReferenceKeyColumns", expected);
    }

    @Test
    public void testVirtualLookup() {
        String[] expected = new String[]{"expr[string]", "null"};
        this.executeAndAssertResults("select lookup('System.KeyElements', 'RefKeyUID', 'KeyName', 'PK_PARTS')", expected);
    }
}

