/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.systemmodel;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.jdbc.api.AbstractMMQueryTestCase;
import org.junit.Before;
import org.junit.Test;

public class TestVirtualDocWithVirtualProc
extends AbstractMMQueryTestCase {
    private static final String DQP_PROP_FILE = UnitTestUtil.getTestDataPath() + "/xml-vp/xmlvp.properties";
    private static final String VDB = "xmlvp";

    public TestVirtualDocWithVirtualProc() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() {
        this.getConnection(VDB, DQP_PROP_FILE);
    }

    @Test
    public void testDefect15241() {
        String sql = "SELECT ModelName, Name, Description FROM System.Groups WHERE Name = 'yyyTestDocument'";
        String[] expected = new String[]{"ModelName[string]\tName[string]\tDescription[string]", "test13326Doc\tyyyTestDocument\tnull", "testDoc\tyyyTestDocument\tThis is a test description of virtual doc yyyTestDocument"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241a() {
        String sql = "SELECT GroupName, Name, Description FROM System.Elements WHERE Name = 'IntKey'";
        String[] expected = new String[]{"GroupName[string]\tName[string]\tDescription[string]", "HugeA\tIntKey\tnull", "HugeB\tIntKey\tnull", "LargeA\tIntKey\tnull", "LargeB\tIntKey\tnull", "MediumA\tIntKey\tnull", "MediumB\tIntKey\tnull", "SmallA\tIntKey\tThis is a test description of SmallA.IntKey element", "SmallB\tIntKey\tnull"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241b() {
        String sql = "SELECT GroupName, Name, Value, UID FROM System.GroupProperties WHERE ModelName = 'testDoc'";
        String[] expected = new String[]{"GroupName[string]\tName[string]\tValue[string]\tUID[string]", "yyyTestDocument\tNugentXAttribute\tNuuuuuge22222\tmmuuid:4789b280-841c-1f15-9526-ebd0cace03e1", "yyyTestDocument\tNugentYAttribute\tNuuuuuge44444\tmmuuid:4789b280-841c-1f15-9526-ebd0cace03e1"};
        this.executeAndAssertResults(sql, expected);
    }
}

