/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.language;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.cdk.unittest.FakeTranslationFactory;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.connector.language.ICriteria;
import org.teiid.connector.language.ILanguageFactory;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.language.LanguageUtil;
import org.teiid.dqp.internal.datamgr.language.LanguageFactoryImpl;

public class TestLanguageUtil
extends TestCase {
    public TestLanguageUtil(String name) {
        super(name);
    }

    private ICriteria convertCriteria(String criteriaStr) {
        TranslationUtility util = FakeTranslationFactory.getInstance().getBQTTranslationUtility();
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE " + criteriaStr;
        IQuery query = (IQuery)util.parseCommand(sql);
        ICriteria criteria = query.getWhere();
        return criteria;
    }

    public void helpTestSeparateByAnd(String criteriaStr, String[] expected) throws Exception {
        ICriteria criteria = this.convertCriteria(criteriaStr);
        List crits = LanguageUtil.separateCriteriaByAnd((ICriteria)criteria);
        HashSet<String> expectedSet = new HashSet<String>();
        for (int i = 0; i < expected.length; ++i) {
            expectedSet.add(expected[i]);
        }
        HashSet<String> actualSet = new HashSet<String>();
        for (int i = 0; i < crits.size(); ++i) {
            actualSet.add(crits.get(i).toString());
        }
        TestLanguageUtil.assertEquals((String)"Did not get expected criteria pieces", expectedSet, actualSet);
    }

    public void testSeparateCrit_predicate() throws Exception {
        this.helpTestSeparateByAnd("intkey = 1", new String[]{"SmallA.IntKey = 1"});
    }

    public void testSeparateCrit_ORisConjunct() throws Exception {
        this.helpTestSeparateByAnd("intkey = 1 OR intkey = 2", new String[]{"(SmallA.IntKey = 1) OR (SmallA.IntKey = 2)"});
    }

    public void testSeparateCrit_nestedAND() throws Exception {
        this.helpTestSeparateByAnd("((intkey = 1 AND intkey = 2) AND (intkey = 3) AND (intkey = 4))", new String[]{"SmallA.IntKey = 1", "SmallA.IntKey = 2", "SmallA.IntKey = 3", "SmallA.IntKey = 4"});
    }

    public void testSeparateCrit_NOT() throws Exception {
        this.helpTestSeparateByAnd("((NOT (intkey = 1 AND intkey = 2)) AND (intkey = 3) AND (intkey = 4))", new String[]{"NOT ((SmallA.IntKey = 1) AND (SmallA.IntKey = 2))", "SmallA.IntKey = 3", "SmallA.IntKey = 4"});
    }

    public void helpTestCombineCriteria(String primaryStr, String additionalStr, String expected) throws Exception {
        ICriteria primaryCrit = primaryStr == null ? null : this.convertCriteria(primaryStr);
        ICriteria additionalCrit = additionalStr == null ? null : this.convertCriteria(additionalStr);
        ICriteria crit = LanguageUtil.combineCriteria((ICriteria)primaryCrit, (ICriteria)additionalCrit, (ILanguageFactory)LanguageFactoryImpl.INSTANCE);
        String critStr = crit == null ? null : crit.toString();
        TestLanguageUtil.assertEquals((String)"Did not get expected criteria", (String)expected, (String)critStr);
    }

    public void testCombineCrit_bothNull() throws Exception {
        this.helpTestCombineCriteria(null, null, null);
    }

    public void testCombineCrit_primaryNull() throws Exception {
        this.helpTestCombineCriteria(null, "intkey = 1", "SmallA.IntKey = 1");
    }

    public void testCombineCrit_additionalNull() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", null, "SmallA.IntKey = 1");
    }

    public void testCombineCrit_bothPredicates() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", "intkey = 2", "(SmallA.IntKey = 1) AND (SmallA.IntKey = 2)");
    }

    public void testCombineCrit_primaryPredicate() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", "intkey = 2 AND intkey = 3", "(SmallA.IntKey = 1) AND ((SmallA.IntKey = 2) AND (SmallA.IntKey = 3))");
    }

    public void testCombineCrit_additionalPredicate() throws Exception {
        this.helpTestCombineCriteria("intkey = 1 AND intkey = 2", "intkey = 3", "(SmallA.IntKey = 1) AND (SmallA.IntKey = 2) AND (SmallA.IntKey = 3)");
    }
}

