/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.connector.api.Connection;
import org.teiid.connector.api.ConnectorCapabilities;
import org.teiid.connector.api.ConnectorEnvironment;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.connector.api.ProcedureExecution;
import org.teiid.connector.api.ResultSetExecution;
import org.teiid.connector.basic.BasicConnection;
import org.teiid.connector.basic.BasicConnector;
import org.teiid.connector.basic.BasicConnectorCapabilities;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.language.IQueryCommand;
import org.teiid.connector.language.ISelectSymbol;
import org.teiid.connector.metadata.runtime.Element;
import org.teiid.connector.metadata.runtime.MetadataObject;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;

public class MockConnector
extends BasicConnector {
    public ConnectorCapabilities getCapabilities() {
        return new BasicConnectorCapabilities();
    }

    public Connection getConnection(ExecutionContext context) throws ConnectorException {
        return new BasicConnection(){

            public void close() {
            }

            public ProcedureExecution createProcedureExecution(IProcedure procedure, ExecutionContext executionContext, RuntimeMetadata metadata) throws ConnectorException {
                Properties props = new Properties();
                props.setProperty("customBehaviour", "SkipExecute");
                MetadataObject metaObject = procedure.getMetadataObject();
                TestCase.assertEquals((String)"AnyModel.ProcedureB", (String)procedure.getProcedureName());
                TestCase.assertEquals((String)"PROC", (String)metaObject.getNameInSource());
                TestCase.assertEquals((Object)props, (Object)metaObject.getProperties());
                ProcedureExecution exec = (ProcedureExecution)Mockito.mock(ProcedureExecution.class);
                Mockito.stub((Object)exec.next()).toReturn(null);
                return exec;
            }

            public ResultSetExecution createResultSetExecution(IQueryCommand query, ExecutionContext executionContext, RuntimeMetadata metadata) throws ConnectorException {
                Properties groupProps = new Properties();
                groupProps.setProperty("customName", "CustomTableA");
                IGroup group = (IGroup)query.getProjectedQuery().getFrom().getItems().get(0);
                MetadataObject groupMD = group.getMetadataObject();
                TestCase.assertEquals((Object)groupProps, (Object)groupMD.getProperties());
                ISelectSymbol symbl = (ISelectSymbol)query.getProjectedQuery().getSelect().getSelectSymbols().get(0);
                IElement element = (IElement)symbl.getExpression();
                Element elementMD = (Element)element.getMetadataObject();
                Properties elementProps = new Properties();
                elementProps.setProperty("customPosition", "11");
                TestCase.assertEquals((int)0, (int)elementMD.getLength());
                TestCase.assertEquals((Object)"Foo", (Object)elementMD.getDefaultValue());
                TestCase.assertEquals((String)"TrimNulls", (String)elementMD.getFormat());
                TestCase.assertEquals(String.class, (Object)elementMD.getJavaType());
                TestCase.assertEquals(null, (Object)elementMD.getMaximumValue());
                TestCase.assertEquals(null, (Object)elementMD.getMinimumValue());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#anySimpleType", (String)elementMD.getModeledBaseType());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#string", (String)elementMD.getModeledPrimitiveType());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#string", (String)elementMD.getModeledType());
                TestCase.assertEquals((String)"COLUMN1", (String)elementMD.getNameInSource());
                TestCase.assertEquals((String)"STR", (String)elementMD.getNativeType());
                TestCase.assertEquals((int)1, (int)elementMD.getNullability());
                TestCase.assertEquals((int)0, (int)elementMD.getPosition());
                TestCase.assertEquals((int)0, (int)elementMD.getPrecision());
                TestCase.assertEquals((int)0, (int)elementMD.getScale());
                TestCase.assertEquals((int)3, (int)elementMD.getSearchability());
                TestCase.assertEquals((boolean)false, (boolean)elementMD.isAutoIncremented());
                TestCase.assertEquals((boolean)true, (boolean)elementMD.isCaseSensitive());
                TestCase.assertEquals((Object)elementProps, (Object)elementMD.getProperties());
                ISelectSymbol symbl2 = (ISelectSymbol)query.getProjectedQuery().getSelect().getSelectSymbols().get(1);
                IElement element2 = (IElement)symbl2.getExpression();
                Element elementMD2 = (Element)element2.getMetadataObject();
                Properties elementProps2 = new Properties();
                elementProps2.setProperty("customPosition", "12");
                TestCase.assertEquals((int)10, (int)elementMD2.getLength());
                TestCase.assertEquals((Object)"23", (Object)elementMD2.getDefaultValue());
                TestCase.assertEquals((String)"YesFormat", (String)elementMD2.getFormat());
                TestCase.assertEquals(Integer.class, (Object)elementMD2.getJavaType());
                TestCase.assertEquals((Object)"1", (Object)elementMD2.getMaximumValue());
                TestCase.assertEquals((Object)"100", (Object)elementMD2.getMinimumValue());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#long", (String)elementMD2.getModeledBaseType());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#decimal", (String)elementMD2.getModeledPrimitiveType());
                TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#int", (String)elementMD2.getModeledType());
                TestCase.assertEquals((String)"COLUMN2", (String)elementMD2.getNameInSource());
                TestCase.assertEquals((String)"INT", (String)elementMD2.getNativeType());
                TestCase.assertEquals((int)0, (int)elementMD2.getNullability());
                TestCase.assertEquals((int)1, (int)elementMD2.getPosition());
                TestCase.assertEquals((int)0, (int)elementMD2.getPrecision());
                TestCase.assertEquals((int)10, (int)elementMD2.getScale());
                TestCase.assertEquals((int)3, (int)elementMD2.getSearchability());
                TestCase.assertEquals((boolean)true, (boolean)elementMD2.isAutoIncremented());
                TestCase.assertEquals((boolean)false, (boolean)elementMD2.isCaseSensitive());
                TestCase.assertEquals((Object)elementProps2, (Object)elementMD2.getProperties());
                ResultSetExecution exec = (ResultSetExecution)Mockito.mock(ResultSetExecution.class);
                Mockito.stub((Object)exec.next()).toReturn(null);
                return exec;
            }
        };
    }

    public void start(ConnectorEnvironment environment) throws ConnectorException {
    }

    public void stop() {
    }
}

