/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.language.ISelectSymbol;
import org.teiid.connector.metadata.runtime.Element;

public class TestElement
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestElement.createTranslationUtility(TestElement.getTestVDBName());
    Properties props;

    public TestElement(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Element getElement(String groupName, String elementName, TranslationUtility transUtil) throws Exception {
        IQuery query = (IQuery)transUtil.parseCommand("SELECT " + elementName + " FROM " + groupName);
        ISelectSymbol symbol = (ISelectSymbol)query.getSelect().getSelectSymbols().get(0);
        IElement element = (IElement)symbol.getExpression();
        return (Element)element.getMetadataObject();
    }

    public void helpTestElement(String fullGroupName, String elementShortName, TranslationUtility transUtil, String nameInSource, Object defaultValue, Object minValue, Object maxValue, Class javaType, int length, int nullable, int position, int searchable, boolean autoIncrement, boolean caseSensitive, Properties expectedProps, String modeledType, String modeledBaseType, String modeledPrimitiveType) throws Exception {
        Element element = this.getElement(fullGroupName, elementShortName, transUtil);
        TestElement.assertEquals((String)nameInSource, (String)element.getNameInSource());
        TestElement.assertEquals((Object)defaultValue, (Object)element.getDefaultValue());
        TestElement.assertEquals((Object)minValue, (Object)element.getMinimumValue());
        TestElement.assertEquals((Object)maxValue, (Object)element.getMaximumValue());
        TestElement.assertEquals((Object)javaType, (Object)element.getJavaType());
        TestElement.assertEquals((int)length, (int)element.getLength());
        TestElement.assertEquals((int)nullable, (int)element.getNullability());
        TestElement.assertEquals((int)position, (int)element.getPosition());
        TestElement.assertEquals((int)searchable, (int)element.getSearchability());
        TestElement.assertEquals((boolean)autoIncrement, (boolean)element.isAutoIncremented());
        TestElement.assertEquals((boolean)caseSensitive, (boolean)element.isCaseSensitive());
        TestElement.assertEquals((String)modeledType, (String)element.getModeledType());
        TestElement.assertEquals((String)modeledBaseType, (String)element.getModeledBaseType());
        TestElement.assertEquals((String)modeledPrimitiveType, (String)element.getModeledPrimitiveType());
        Properties extProps = element.getProperties();
        TestElement.assertEquals((Object)expectedProps, (Object)extProps);
    }

    public void testElement1() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestNameInSource", CONNECTOR_METADATA_UTILITY, "the name in source", null, null, null, String.class, 10, 1, 0, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testElement2() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestDefaultValue", CONNECTOR_METADATA_UTILITY, null, "1000", null, null, Integer.class, 0, 1, 1, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testElement3() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestMinMaxValue", CONNECTOR_METADATA_UTILITY, null, null, "500", "25000", Integer.class, 0, 1, 2, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testElement4() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestAutoIncrement", CONNECTOR_METADATA_UTILITY, null, null, null, null, Long.class, 0, 1, 3, 3, true, true, this.props, "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testElement5() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestCaseSensitive", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, 1, 4, 3, false, false, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testElement6() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestExtensionProp", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, 1, 5, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testEnterpriseDataTypes() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestTable", "TestDataType", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 0, 1, 6, 3, false, true, this.props, "http://www.metamatrix.com/XMLSchema/DataSets/Books/BookDatatypes#PublicationYear", "http://www.w3.org/2001/XMLSchema#gYear", "http://www.w3.org/2001/XMLSchema#gYear");
    }

    public void testUnsearchable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestUnsearchable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, 1, 0, 0, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testSearchableLike() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchableLike", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, 1, 1, 2, false, true, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testSearchableComparable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchableComparable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, 1, 2, 1, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testSearchable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestSearchableColumns", "TestSearchable", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, 1, 3, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testNullable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNullable", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, 1, 0, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void testNotNullable() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNotNullable", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, 0, 1, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testNullableUnknown() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestNullableColumns", "TestNullableUnknown", CONNECTOR_METADATA_UTILITY, null, null, null, null, String.class, 10, 2, 2, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }

    public void testElementWithCategories() throws Exception {
        this.helpTestElement("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCol", CONNECTOR_METADATA_UTILITY, null, null, null, null, Integer.class, 0, 1, 0, 3, false, true, this.props, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
    }

    protected void setUp() throws Exception {
        this.props = new Properties();
        this.props.setProperty("ColProp", "defaultvalue");
    }
}

