/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.metadata.runtime.Group;

public class TestGroup
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestGroup.createTranslationUtility(TestGroup.getTestVDBName());

    public TestGroup(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Group getGroup(String groupName, TranslationUtility transUtil) throws Exception {
        IQuery query = (IQuery)transUtil.parseCommand("SELECT 1 FROM " + groupName);
        IGroup group = (IGroup)query.getFrom().getItems().get(0);
        return (Group)group.getMetadataObject();
    }

    public void helpTestGroup(String fullGroupName, String nameInSource, Properties expectedProps, TranslationUtility transUtil) throws Exception {
        Group group = this.getGroup(fullGroupName, transUtil);
        TestGroup.assertEquals((String)"table name in source", (String)group.getNameInSource());
        Properties extProps = group.getProperties();
        TestGroup.assertEquals((Object)expectedProps, (Object)extProps);
    }

    public void testGroup() throws Exception {
        Properties props = new Properties();
        props.put("TestExtraProperty", "extension prop value");
        this.helpTestGroup("ConnectorMetadata.TestTable", "TestTable", props, CONNECTOR_METADATA_UTILITY);
    }
}

