/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.language.ISelectSymbol;
import org.teiid.connector.metadata.runtime.Element;
import org.teiid.connector.metadata.runtime.Group;
import org.teiid.connector.metadata.runtime.Parameter;
import org.teiid.connector.metadata.runtime.Procedure;

public class TestMetadataObject
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestMetadataObject.createTranslationUtility(TestMetadataObject.getTestVDBName());

    public TestMetadataObject(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Group getGroupID(String groupName, TranslationUtility transUtil) {
        IQuery query = (IQuery)transUtil.parseCommand("SELECT 1 FROM " + groupName);
        IGroup group = (IGroup)query.getFrom().getItems().get(0);
        return (Group)group.getMetadataObject();
    }

    public void helpTestGroupID(String fullGroupName, String shortGroupName, int elementCount, TranslationUtility transUtil) throws Exception {
        Group groupID = this.getGroupID(fullGroupName, transUtil);
        TestMetadataObject.assertEquals((String)fullGroupName, (String)groupID.getFullName());
        TestMetadataObject.assertEquals((String)shortGroupName, (String)groupID.getName());
        List children = groupID.getChildren();
        TestMetadataObject.assertEquals((int)elementCount, (int)children.size());
        for (Element element : children) {
            TestMetadataObject.assertEquals((Object)groupID, (Object)element.getParent());
            TestMetadataObject.assertTrue((boolean)element.getFullName().startsWith(groupID.getFullName()));
        }
    }

    public void testGroupID() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestTable", "TestTable", 7, CONNECTOR_METADATA_UTILITY);
    }

    public void testGroupID_longName() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestTable2", 1, CONNECTOR_METADATA_UTILITY);
    }

    public Element getElementID(String groupName, String elementName, TranslationUtility transUtil) {
        IQuery query = (IQuery)transUtil.parseCommand("SELECT " + elementName + " FROM " + groupName);
        ISelectSymbol symbol = (ISelectSymbol)query.getSelect().getSelectSymbols().get(0);
        IElement element = (IElement)symbol.getExpression();
        return (Element)element.getMetadataObject();
    }

    public void helpTestElementID(String groupName, String elementName, TranslationUtility transUtil) throws Exception {
        Element elementID = this.getElementID(groupName, elementName, transUtil);
        TestMetadataObject.assertEquals((String)(groupName + "." + elementName), (String)elementID.getFullName());
        TestMetadataObject.assertEquals((String)elementName, (String)elementID.getName());
        TestMetadataObject.assertNotNull((Object)elementID.getParent());
        TestMetadataObject.assertEquals((String)groupName, (String)elementID.getParent().getFullName());
    }

    public void testElementID() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestTable", "TestNameInSource", CONNECTOR_METADATA_UTILITY);
    }

    public void testElementID_longName() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCol", CONNECTOR_METADATA_UTILITY);
    }

    public Procedure getProcedureID(String procName, int inputParamCount, TranslationUtility transUtil) {
        StringBuffer sql = new StringBuffer("EXEC ");
        sql.append(procName);
        sql.append("(");
        for (int i = 0; i < inputParamCount; ++i) {
            sql.append("null");
            if (i >= inputParamCount - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        IProcedure proc = (IProcedure)transUtil.parseCommand(sql.toString());
        return (Procedure)proc.getMetadataObject();
    }

    public void helpTestProcedureID(String procName, String shortName, int inputParamCount, String[] paramNames, TranslationUtility transUtil) throws Exception {
        Procedure procID = this.getProcedureID(procName, inputParamCount, transUtil);
        TestMetadataObject.assertEquals((String)procName, (String)procID.getFullName());
        TestMetadataObject.assertEquals((String)shortName, (String)procID.getName());
        List children = procID.getChildren();
        TestMetadataObject.assertEquals((int)paramNames.length, (int)children.size());
        HashSet<String> actualParamNames = new HashSet<String>();
        for (Parameter childID : children) {
            TestMetadataObject.assertEquals((Object)procID, (Object)childID.getParent());
            TestMetadataObject.assertTrue((boolean)childID.getFullName().startsWith(procID.getFullName()));
            actualParamNames.add(childID.getName());
        }
        HashSet<String> expectedParamNames = new HashSet<String>(Arrays.asList(paramNames));
        TestMetadataObject.assertEquals(expectedParamNames, actualParamNames);
    }

    public void testProcedureID() throws Exception {
        String[] paramNames = new String[]{"InParam", "OutParam", "InOutParam", "ReturnParam"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc1", "TestProc1", 2, paramNames, CONNECTOR_METADATA_UTILITY);
    }

    public void testProcedureID_resultSet() throws Exception {
        String[] paramNames = new String[]{"Param1", "RSParam"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc2", "TestProc2", 1, paramNames, CONNECTOR_METADATA_UTILITY);
    }

    public void testProcedureID_longName() throws Exception {
        this.helpTestProcedureID("ConnectorMetadata.TestCatalog.TestSchema.TestProc", "TestProc", 0, new String[0], CONNECTOR_METADATA_UTILITY);
    }
}

