/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.sql.Timestamp;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.connector.language.IParameter;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.metadata.runtime.Parameter;

public class TestParams
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestParams.createTranslationUtility(TestParams.getTestVDBName());

    public TestParams(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/sptest/spvdb.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public IProcedure getProcedure(String procName, int inputArgs, TranslationUtility transUtil) throws Exception {
        StringBuffer sql = new StringBuffer("EXEC " + procName + "(");
        if (inputArgs > 0) {
            sql.append("?");
            for (int i = 1; i < inputArgs; ++i) {
                sql.append(", ?");
            }
        }
        sql.append(")");
        IProcedure proc = (IProcedure)transUtil.parseCommand(sql.toString());
        return proc;
    }

    private void checkParameter(IParameter param, String name, String fullName, int index, IParameter.Direction direction, String nameInSource, String defaultValue, int nullability, Class javaType, int length, int precision, int scale, TranslationUtility transUtil, String modeledType, String modeledBaseType, String modeledPrimitiveType) throws Exception {
        Parameter p = (Parameter)param.getMetadataObject();
        TestParams.assertEquals((String)name, (String)p.getName());
        TestParams.assertEquals((String)fullName, (String)p.getFullName());
        TestParams.assertEquals((int)index, (int)param.getIndex());
        TestParams.assertEquals((Object)direction, (Object)param.getDirection());
        TestParams.assertEquals((String)nameInSource, (String)p.getNameInSource());
        TestParams.assertEquals((Object)defaultValue, (Object)p.getDefaultValue());
        TestParams.assertEquals((int)nullability, (int)p.getNullability());
        TestParams.assertEquals((Object)javaType, (Object)p.getJavaType());
        TestParams.assertEquals((Object)javaType, (Object)param.getType());
        TestParams.assertEquals((int)length, (int)p.getLength());
        TestParams.assertEquals((int)precision, (int)p.getPrecision());
        TestParams.assertEquals((int)scale, (int)p.getScale());
        TestParams.assertEquals(null, (Object)param.getValue());
        TestParams.assertEquals((boolean)false, (boolean)param.getValueSpecified());
        TestParams.assertEquals((String)modeledType, (String)p.getModeledType());
        TestParams.assertEquals((String)modeledBaseType, (String)p.getModeledBaseType());
        TestParams.assertEquals((String)modeledPrimitiveType, (String)p.getModeledPrimitiveType());
    }

    public void testProcedureWithResultSet() throws Exception {
        IProcedure proc = this.getProcedure("sptest.proc1", 4, CONNECTOR_METADATA_UTILITY);
        List params = proc.getParameters();
        TestParams.assertEquals((int)4, (int)params.size());
        this.checkParameter((IParameter)params.get(0), "in1", "sptest.proc1.in1", 1, IParameter.Direction.IN, null, "sample default", 0, String.class, 20, 10, 5, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
        this.checkParameter((IParameter)params.get(1), "in2", "sptest.proc1.in2", 2, IParameter.Direction.IN, null, "15", 1, Integer.class, 0, 10, 0, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
        this.checkParameter((IParameter)params.get(2), "in3", "sptest.proc1.in3", 3, IParameter.Direction.IN, null, "2003-04-23 09:30:00", 2, Timestamp.class, 22, 10, 0, CONNECTOR_METADATA_UTILITY, "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance#timestamp", "http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/2001/XMLSchema#dateTime");
        this.checkParameter((IParameter)params.get(3), "inOptional", "sptest.proc1.inOptional", 4, IParameter.Direction.IN, "optionalName", null, 1, String.class, 0, 0, 0, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }
}

