/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.metadata.runtime.Element;
import org.teiid.connector.metadata.runtime.Parameter;
import org.teiid.connector.metadata.runtime.Procedure;

public class TestProcedure
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestProcedure.createTranslationUtility(TestProcedure.getTestVDBName());

    public TestProcedure(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Procedure getProcedure(String procName, int inputArgs, TranslationUtility transUtil) throws Exception {
        StringBuffer sql = new StringBuffer("EXEC " + procName + "(");
        if (inputArgs > 0) {
            sql.append("?");
            for (int i = 1; i < inputArgs; ++i) {
                sql.append(", ?");
            }
        }
        sql.append(")");
        IProcedure proc = (IProcedure)transUtil.parseCommand(sql.toString());
        return (Procedure)proc.getMetadataObject();
    }

    public void testProcedure1() throws Exception {
        Procedure proc = this.getProcedure("ConnectorMetadata.TestProc1", 2, CONNECTOR_METADATA_UTILITY);
        TestProcedure.assertEquals((String)"Procedure name in source", (String)proc.getNameInSource());
        String[] nameInSource = new String[]{"Param name in source", null, null, null};
        int[] direction = new int[]{0, 1, 2, 3};
        int[] index = new int[]{1, 2, 3, 4};
        Class[] type = new Class[]{Integer.class, Long.class, Short.class, Date.class};
        List params = proc.getChildren();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = (Parameter)params.get(i);
            TestProcedure.assertEquals((String)nameInSource[i], (String)param.getNameInSource());
            TestProcedure.assertEquals((int)direction[i], (int)param.getDirection());
            TestProcedure.assertEquals((int)index[i], (int)param.getIndex());
            TestProcedure.assertEquals((Object)type[i], (Object)param.getJavaType());
        }
    }

    public void testProcedureWithResultSet() throws Exception {
        Procedure proc = this.getProcedure("ConnectorMetadata.TestProc2", 1, CONNECTOR_METADATA_UTILITY);
        TestProcedure.assertEquals(null, (String)proc.getNameInSource());
        String[] nameInSource = new String[]{null, "Result set name in source"};
        int[] direction = new int[]{0, 4};
        int[] index = new int[]{1, 2};
        Class[] type = new Class[]{String.class, ResultSet.class};
        List params = proc.getChildren();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = (Parameter)params.get(i);
            TestProcedure.assertEquals((String)nameInSource[i], (String)param.getNameInSource());
            TestProcedure.assertEquals((int)direction[i], (int)param.getDirection());
            TestProcedure.assertEquals((int)index[i], (int)param.getIndex());
            TestProcedure.assertEquals((Object)type[i], (Object)param.getJavaType());
        }
        Parameter param = (Parameter)params.get(1);
        List rsCols = param.getChildren();
        TestProcedure.assertEquals((int)2, (int)rsCols.size());
        Element elemID = (Element)rsCols.get(0);
        TestProcedure.assertEquals((String)"RSCol1", (String)elemID.getName());
        TestProcedure.assertEquals((String)"ConnectorMetadata.TestProc2.RSParam.RSCol1", (String)elemID.getFullName());
        TestProcedure.assertEquals((String)"Result set column name in source", (String)elemID.getNameInSource());
        TestProcedure.assertEquals(Timestamp.class, (Object)elemID.getJavaType());
        TestProcedure.assertEquals((int)0, (int)elemID.getPosition());
        Element elemID2 = (Element)rsCols.get(1);
        TestProcedure.assertEquals((String)"RSCol2", (String)elemID2.getName());
        TestProcedure.assertEquals((String)"ConnectorMetadata.TestProc2.RSParam.RSCol2", (String)elemID2.getFullName());
        TestProcedure.assertEquals(null, (String)elemID2.getNameInSource());
        TestProcedure.assertEquals(String.class, (Object)elemID2.getJavaType());
        TestProcedure.assertEquals((int)1, (int)elemID2.getPosition());
        Properties props = new Properties();
        props.put("ColProp", "defaultvalue");
    }
}

