/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.teiid.connector.language.ICompareCriteria;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IExpression;
import org.teiid.connector.language.IFrom;
import org.teiid.connector.language.IFunction;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.ILanguageObject;
import org.teiid.connector.language.ISelect;
import org.teiid.connector.visitor.util.CollectorVisitor;
import org.teiid.dqp.internal.datamgr.language.CompareCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.ElementImpl;
import org.teiid.dqp.internal.datamgr.language.FromImpl;
import org.teiid.dqp.internal.datamgr.language.FunctionImpl;
import org.teiid.dqp.internal.datamgr.language.GroupImpl;
import org.teiid.dqp.internal.datamgr.language.QueryImpl;
import org.teiid.dqp.internal.datamgr.language.SelectImpl;

public class TestCollectorVisitor
extends TestCase {
    public TestCollectorVisitor(String name) {
        super(name);
    }

    public Set getStringSet(Collection objs) {
        HashSet<String> strings = new HashSet<String>();
        for (Object obj : objs) {
            if (obj == null) {
                strings.add(null);
                continue;
            }
            strings.add(obj.toString());
        }
        return strings;
    }

    public void helpTestCollection(ILanguageObject obj, Class type, String[] objects) {
        Set actualObjects = this.getStringSet(CollectorVisitor.collectObjects((Class)type, (ILanguageObject)obj));
        HashSet<String> expectedObjects = new HashSet<String>(Arrays.asList(objects));
        TestCollectorVisitor.assertEquals((String)"Did not get expected objects", expectedObjects, (Object)actualObjects);
    }

    public ILanguageObject example1() {
        GroupImpl g = new GroupImpl("g1", null, null);
        ArrayList<Object> symbols = new ArrayList<Object>();
        symbols.add(new ElementImpl((IGroup)g, "e1", null, String.class));
        FunctionImpl function = new FunctionImpl("length", Arrays.asList(new ElementImpl((IGroup)g, "e2", null, String.class)), Integer.class);
        symbols.add(function);
        SelectImpl s = new SelectImpl(symbols, false);
        ArrayList<GroupImpl> groups = new ArrayList<GroupImpl>();
        groups.add(g);
        FromImpl f = new FromImpl(groups);
        QueryImpl q = new QueryImpl((ISelect)s, (IFrom)f, null, null, null, null);
        return q;
    }

    public void testCollection1() {
        this.helpTestCollection(this.example1(), IElement.class, new String[]{"g1.e1", "g1.e2"});
    }

    public void testCollection2() {
        this.helpTestCollection(this.example1(), IFunction.class, new String[]{"length(g1.e2)"});
    }

    public void testCollection3() {
        this.helpTestCollection(this.example1(), IExpression.class, new String[]{"g1.e1", "g1.e2", "length(g1.e2)"});
    }

    public void helpTestElementsUsedByGroups(ILanguageObject obj, String[] elements, String[] groups) {
        Set actualElements = this.getStringSet(CollectorVisitor.collectElements((ILanguageObject)obj));
        Set actualGroups = this.getStringSet(CollectorVisitor.collectGroupsUsedByElements((ILanguageObject)obj));
        HashSet<String> expectedElements = new HashSet<String>(Arrays.asList(elements));
        HashSet<String> expectedGroups = new HashSet<String>(Arrays.asList(groups));
        TestCollectorVisitor.assertEquals((String)"Did not get expected elements", expectedElements, (Object)actualElements);
        TestCollectorVisitor.assertEquals((String)"Did not get expected groups", expectedGroups, (Object)actualGroups);
    }

    public void test1() {
        GroupImpl g1 = new GroupImpl("g1", null, null);
        ElementImpl e1 = new ElementImpl((IGroup)g1, "e1", null, String.class);
        this.helpTestElementsUsedByGroups((ILanguageObject)e1, new String[]{"g1.e1"}, new String[]{"g1"});
    }

    public void test2() {
        GroupImpl g1 = new GroupImpl("g1", null, null);
        ElementImpl e1 = new ElementImpl((IGroup)g1, "e1", null, String.class);
        ElementImpl e2 = new ElementImpl((IGroup)g1, "e2", null, String.class);
        CompareCriteriaImpl cc = new CompareCriteriaImpl((IExpression)e1, (IExpression)e2, ICompareCriteria.Operator.EQ);
        this.helpTestElementsUsedByGroups((ILanguageObject)cc, new String[]{"g1.e1", "g1.e2"}, new String[]{"g1"});
    }
}

