/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import com.metamatrix.cdk.unittest.FakeTranslationFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.unittest.FakeMetadataFacade;
import com.metamatrix.query.unittest.FakeMetadataFactory;
import com.metamatrix.query.unittest.FakeMetadataObject;
import com.metamatrix.query.unittest.FakeMetadataStore;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.IExpression;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.ILanguageObject;
import org.teiid.connector.metadata.runtime.RuntimeMetadata;
import org.teiid.connector.visitor.util.SQLStringVisitor;
import org.teiid.dqp.internal.datamgr.language.AggregateImpl;
import org.teiid.dqp.internal.datamgr.language.BaseLanguageObject;
import org.teiid.dqp.internal.datamgr.language.ElementImpl;
import org.teiid.dqp.internal.datamgr.language.FunctionImpl;
import org.teiid.dqp.internal.datamgr.language.GroupImpl;
import org.teiid.dqp.internal.datamgr.language.LiteralImpl;
import org.teiid.dqp.internal.datamgr.language.TestAggregateImpl;
import org.teiid.dqp.internal.datamgr.language.TestCompareCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestDeleteImpl;
import org.teiid.dqp.internal.datamgr.language.TestElementImpl;
import org.teiid.dqp.internal.datamgr.language.TestExistsCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestFromImpl;
import org.teiid.dqp.internal.datamgr.language.TestFunctionImpl;
import org.teiid.dqp.internal.datamgr.language.TestGroupByImpl;
import org.teiid.dqp.internal.datamgr.language.TestGroupImpl;
import org.teiid.dqp.internal.datamgr.language.TestInCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestInsertImpl;
import org.teiid.dqp.internal.datamgr.language.TestIsNullCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestJoinImpl;
import org.teiid.dqp.internal.datamgr.language.TestLikeCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestLiteralImpl;
import org.teiid.dqp.internal.datamgr.language.TestNotCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestOrderByImpl;
import org.teiid.dqp.internal.datamgr.language.TestProcedureImpl;
import org.teiid.dqp.internal.datamgr.language.TestQueryImpl;
import org.teiid.dqp.internal.datamgr.language.TestScalarSubqueryImpl;
import org.teiid.dqp.internal.datamgr.language.TestSearchedCaseExpressionImpl;
import org.teiid.dqp.internal.datamgr.language.TestSelectImpl;
import org.teiid.dqp.internal.datamgr.language.TestSelectSymbolImpl;
import org.teiid.dqp.internal.datamgr.language.TestSetQueryImpl;
import org.teiid.dqp.internal.datamgr.language.TestSubqueryCompareCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestSubqueryInCriteriaImpl;
import org.teiid.dqp.internal.datamgr.language.TestUpdateImpl;
import org.teiid.dqp.internal.datamgr.language.TstLanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;

public class TestSQLStringVisitor
extends TestCase {
    public static final RuntimeMetadata metadata = TstLanguageBridgeFactory.metadataFactory;

    public TestSQLStringVisitor(String name) {
        super(name);
    }

    private String getString(ILanguageObject obj) {
        return SQLStringVisitor.getSQLString((ILanguageObject)obj);
    }

    private String getString(ILanguageObject obj, RuntimeMetadata metadata) {
        return SQLStringVisitor.getSQLString((ILanguageObject)obj);
    }

    private RuntimeMetadataImpl exampleRuntimeMetadata(QueryMetadataInterface metadata) {
        return new RuntimeMetadataImpl(metadata);
    }

    private FakeMetadataStore exampleMetadataStore() {
        FakeMetadataObject bqt1 = FakeMetadataFactory.createPhysicalModel((String)"BQT1");
        FakeMetadataObject bqt1SmallA = FakeMetadataFactory.createPhysicalGroup((String)"BQT1.SmallA", (FakeMetadataObject)bqt1);
        bqt1SmallA.putProperty("nameInSource", (Object)"SmallishA");
        FakeMetadataObject doubleNum = FakeMetadataFactory.createElement((String)"DoubleNum", (FakeMetadataObject)bqt1SmallA, (String)"double", (int)0);
        doubleNum.putProperty("nameInSource", (Object)"doublishNum");
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(bqt1);
        store.addObject(bqt1SmallA);
        store.addObject(doubleNum);
        return store;
    }

    public void testVisitIAggregate() throws Exception {
        String expected = "COUNT(42)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestAggregateImpl.example((String)"COUNT", (String)"COUNT", (boolean)false, (int)42)));
    }

    public void testVisitIAggregateDistinct() throws Exception {
        String expected = "COUNT(DISTINCT *)";
        AggregateImpl impl = new AggregateImpl("COUNT", true, null, Integer.class);
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)impl));
    }

    public void testVisitICompareCriteria() throws Exception {
        String expected = "200 = 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)1, (int)200, (int)100)));
    }

    public void testVisitICompoundCriteria() throws Exception {
        String expected = "200 = 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)1, (int)200, (int)100)));
        expected = "200 >= 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)6, (int)200, (int)100)));
        expected = "200 > 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)4, (int)200, (int)100)));
        expected = "200 <= 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)5, (int)200, (int)100)));
        expected = "200 < 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)3, (int)200, (int)100)));
        expected = "200 <> 100";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestCompareCriteriaImpl.example((int)2, (int)200, (int)100)));
    }

    public void testVisitIDelete() throws Exception {
        String expected = "DELETE FROM g1 WHERE (100 >= 200) AND (500 < 600)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestDeleteImpl.example()));
    }

    public void testVisitIElement() throws Exception {
        String expected = "g1.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestElementImpl.example((String)"vm1.g1", (String)"e1")));
    }

    public void testVisitIExistsCriteria() throws Exception {
        String expected = "EXISTS (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestExistsCriteriaImpl.example()));
    }

    public void testVisitIFrom() throws Exception {
        String expected = "FROM g1, g2 AS myAlias, g3, g4";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestFromImpl.example()));
    }

    public void testVisitIFunction() throws Exception {
        String expected = "testName(100, 200)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestFunctionImpl.example((String)"testName")));
    }

    public void testVisitConvertFunctionOracleStyleWithNIS() throws Exception {
        FakeMetadataFacade facade = new FakeMetadataFacade(this.exampleMetadataStore());
        RuntimeMetadataImpl metadata = this.exampleRuntimeMetadata((QueryMetadataInterface)facade);
        GroupImpl g = new GroupImpl("SmallA", null, metadata.getGroup("BQT1.SmallA"));
        ElementImpl e = new ElementImpl((IGroup)g, "DoubleNum", metadata.getElement("DoubleNum"), Double.class);
        List<IExpression> params = Arrays.asList(e, new LiteralImpl((Object)"integer", String.class));
        String expected = "convert(SmallishA.doublishNum, integer)";
        FunctionImpl test = new FunctionImpl("convert", params, Integer.class);
        TestSQLStringVisitor.assertEquals((String)"convert(SmallishA.doublishNum, integer)", (String)this.getString((ILanguageObject)test, (RuntimeMetadata)metadata));
    }

    public void testVisitConvertFunctionOracleStyle() throws Exception {
        String expected = "convert(columnA, integer)";
        List<BaseLanguageObject> params = Arrays.asList(new ElementImpl(null, "columnA", null, String.class), new LiteralImpl((Object)"integer", String.class));
        FunctionImpl test = new FunctionImpl("convert", params, Integer.class);
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)test));
    }

    public void testVisitIGroup() throws Exception {
        String expected = "g1 AS alias";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestGroupImpl.example((String)"alias", (String)"vm1.g1")));
        expected = "g1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestGroupImpl.example((String)"vm1.g1")));
    }

    public void testVisitIGroupBy() throws Exception {
        String expected = "GROUP BY g1.e1, g1.e2, g1.e3, g1.e4";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestGroupByImpl.example()));
    }

    public void testVisitIInCriteria() throws Exception {
        String expected = "300 IN (100, 200, 300, 400)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestInCriteriaImpl.example((boolean)false)));
        expected = "300 NOT IN (100, 200, 300, 400)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestInCriteriaImpl.example((boolean)true)));
    }

    public void testVisitIInsert() throws Exception {
        String expected = "INSERT INTO g1 (e1, e2, e3, e4) VALUES (1, 2, 3, 4)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestInsertImpl.example((String)"g1")));
    }

    public void testVisitIIsNullCriteria() throws Exception {
        String expected = "g1.e1 IS NULL";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestIsNullCriteriaImpl.example((boolean)false)));
        expected = "g1.e1 IS NOT NULL";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestIsNullCriteriaImpl.example((boolean)true)));
    }

    public void testVisitIJoin() throws Exception {
        String expected = "g1 CROSS JOIN g2 ON g1.e1 = g2.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_CROSS)));
        expected = "g1 FULL OUTER JOIN g2 ON g1.e1 = g2.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_FULL_OUTER)));
        expected = "g1 INNER JOIN g2 ON g1.e1 = g2.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_INNER)));
        expected = "g1 LEFT OUTER JOIN g2 ON g1.e1 = g2.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_LEFT_OUTER)));
        expected = "g1 RIGHT OUTER JOIN g2 ON g1.e1 = g2.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestJoinImpl.example((JoinType)JoinType.JOIN_RIGHT_OUTER)));
    }

    public void testVisitILikeCriteria() throws Exception {
        String expected = "g1.e1 LIKE 'likeString' ESCAPE '\\'";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLikeCriteriaImpl.example((String)"likeString", (char)'\\', (boolean)false)));
        expected = "g1.e1 NOT LIKE 'likeString' ESCAPE '\\'";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLikeCriteriaImpl.example((String)"likeString", (char)'\\', (boolean)true)));
    }

    public void testVisitILiteral() throws Exception {
        String expected = "'string''Literal'";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)"string'Literal")));
        expected = "1000";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)new Integer(1000))));
        expected = "{b'true'}";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)Boolean.TRUE)));
        long now = System.currentTimeMillis();
        Date date = new Date(now);
        expected = "{d'" + date.toString() + "'}";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)date)));
        Timestamp ts = new Timestamp(now);
        expected = "{ts'" + ts.toString() + "'}";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)ts)));
        Time t = new Time(now);
        expected = "{t'" + t.toString() + "'}";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestLiteralImpl.example((Object)t)));
    }

    public void testVisitINotCriteria() throws Exception {
        String expected = "NOT (100 >= 200)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestNotCriteriaImpl.example()));
    }

    public void testVisitIOrderBy() throws Exception {
        String expected = "ORDER BY e1, e2 DESC, e3, e4 DESC";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestOrderByImpl.example()));
    }

    public void testVisitIQuery() throws Exception {
        String expected = "SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestQueryImpl.example()));
    }

    public void testVisitIScalarSubquery() throws Exception {
        String expected = "(SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestScalarSubqueryImpl.example()));
    }

    public void testVisitISearchedCaseExpression() throws Exception {
        String expected = "CASE WHEN g1.e1 = 0 THEN 0 WHEN g1.e1 = 1 THEN 1 WHEN g1.e1 = 2 THEN 2 ELSE 9999 END";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSearchedCaseExpressionImpl.example()));
    }

    public void testVisitISelect() throws Exception {
        String expected = "SELECT g1.e1, g1.e2, g1.e3, g1.e4";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSelectImpl.example((boolean)false)));
        expected = "SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSelectImpl.example((boolean)true)));
    }

    public void testVisitISelectSymbol() throws Exception {
        String expected = "g1.e1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSelectSymbolImpl.example((String)"e1", null)));
        expected = "g1.e1 AS alias";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSelectSymbolImpl.example((String)"e1", (String)"alias")));
    }

    public void testVisitISubqueryCompareCriteria() throws Exception {
        String expected = "g1.e1 > SOME (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSubqueryCompareCriteriaImpl.example()));
    }

    public void testVisitISubqueryInCriteria() throws Exception {
        String expected = "g1.e1 NOT IN (SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSubqueryInCriteriaImpl.example()));
    }

    public void testVisitIUnion1() throws Exception {
        String expected = "SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC UNION SELECT DISTINCT g1.e1, g1.e2, g1.e3, g1.e4 FROM g1, g2 AS myAlias, g3, g4 WHERE (100 >= 200) AND (500 < 600) GROUP BY g1.e1, g1.e2, g1.e3, g1.e4 HAVING (100 >= 200) AND (500 < 600) ORDER BY e1, e2 DESC, e3, e4 DESC ORDER BY e1, e2 DESC, e3, e4 DESC";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestSetQueryImpl.example()));
    }

    public void testVisitIUnion2() throws Exception {
        String expected = "SELECT ted.nugent FROM ted UNION ALL SELECT dave.barry FROM dave";
        String actual = this.getString((ILanguageObject)TestSetQueryImpl.example2());
        TestSQLStringVisitor.assertEquals((String)expected, (String)actual);
    }

    public void testVisitIUnion3() throws Exception {
        String expected = "SELECT ted.nugent FROM ted UNION ALL SELECT dave.barry FROM dave ORDER BY nugent";
        String actual = this.getString((ILanguageObject)TestSetQueryImpl.example3());
        TestSQLStringVisitor.assertEquals((String)expected, (String)actual);
    }

    public void testVisitIUpdate() throws Exception {
        String expected = "UPDATE g1 SET e1 = 1, e2 = 1, e3 = 1, e4 = 1 WHERE 1 = 1";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestUpdateImpl.example()));
    }

    public void testVisitProcedure() throws Exception {
        String expected = "EXEC sq3(, x, 1)";
        TestSQLStringVisitor.assertEquals((String)expected, (String)this.getString((ILanguageObject)TestProcedureImpl.example()));
    }

    public void testTimestampAddFunction() throws Exception {
        String sql = "select timestampadd(SQL_TSI_DAY, 2, timestampvalue) from bqt1.smalla";
        ICommand command = FakeTranslationFactory.getInstance().getBQTTranslationUtility().parseCommand(sql);
        TestSQLStringVisitor.assertEquals((String)"SELECT timestampadd(SQL_TSI_DAY, 2, SmallA.TimestampValue) FROM SmallA", (String)command.toString());
    }
}

