/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.test.client.ClassFactory;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.TestClientTransaction;
import org.teiid.test.client.TestResultsSummary;
import org.teiid.test.client.TransactionFactory;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.datasource.DataSourceMgr;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class TestClient {
    public static final SimpleDateFormat TSFORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private Properties overrides = new Properties();

    public static void main(String[] args) {
        TestClient tc = new TestClient();
        tc.runTest();
    }

    public void runTest() {
        try {
            this.runScenario();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void runScenario() throws Exception {
        String scenario_file = ConfigPropertyLoader.getInstance().getProperty("scenariofile");
        if (scenario_file == null) {
            throw new TransactionRuntimeException("scenariofile property was not defined");
        }
        String scenario_name = FileUtils.getBaseFileNameWithoutExtension((String)scenario_file);
        TestLogger.log("Starting scenario " + scenario_name);
        Properties sc_props = PropertiesUtils.load((String)scenario_file);
        Properties sc_updates = this.getSubstitutedProperties(sc_props);
        if (!sc_updates.isEmpty()) {
            sc_props.putAll((Map<?, ?>)sc_updates);
            this.overrides.putAll((Map<?, ?>)sc_props);
        }
        ConfigPropertyLoader.getInstance().setProperties(sc_props);
        Properties config_updates = this.getSubstitutedProperties(ConfigPropertyLoader.getInstance().getProperties());
        if (!config_updates.isEmpty()) {
            this.overrides.putAll((Map<?, ?>)config_updates);
            ConfigPropertyLoader.getInstance().setProperties(config_updates);
        }
        String url = ConfigPropertyLoader.getInstance().getProperty("URL");
        String vdb_name = ConfigPropertyLoader.getInstance().getProperty("DatabaseName");
        Assert.assertNotNull((String)"DatabaseName property not set, need it for the vdb name", (Object)vdb_name);
        url = StringUtil.replace((String)url, (String)"${vdb}", (String)vdb_name);
        ConfigPropertyLoader.getInstance().setProperty("URL", url);
        QueryScenario set = ClassFactory.createQueryScenario(scenario_name);
        TransactionContainer tc = this.getTransactionContainter();
        this.runTestCase(set, tc);
        TestLogger.log("Completed scenario " + scenario_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestCase(QueryScenario queryset, TransactionContainer tc) throws Exception {
        String querySetID = null;
        List<QueryTest> queryTests = null;
        TestClientTransaction userTxn = new TestClientTransaction(queryset);
        Iterator<String> qsetIt = queryset.getQuerySetIDs().iterator();
        TestResultsSummary summary = new TestResultsSummary(queryset.getResultsMode());
        try {
            while (qsetIt.hasNext()) {
                querySetID = qsetIt.next();
                TestLogger.logInfo("Start Test Query ID [" + querySetID + "]");
                queryTests = queryset.getQueries(querySetID);
                Iterator<QueryTest> queryTestIt = null;
                queryTestIt = queryTests.iterator();
                ExpectedResults expectedResults = queryset.getExpectedResults(querySetID);
                long beginTS = System.currentTimeMillis();
                long endTS = 0L;
                while (queryTestIt.hasNext()) {
                    QueryTest q = queryTestIt.next();
                    userTxn.init(summary, expectedResults, q);
                    try {
                        tc.runTransaction(userTxn);
                    }
                    catch (Throwable t) {
                        TestLogger.logInfo("Testcase run error: " + t.getLocalizedMessage());
                    }
                }
                endTS = System.currentTimeMillis();
                TestLogger.logInfo("End Test Query ID [" + querySetID + "]");
                summary.printResults(queryset, querySetID, beginTS, endTS);
            }
        }
        finally {
            try {
                summary.printTotals(queryset);
                summary.cleanup();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            DataSourceMgr.getInstance().shutdown();
            ConfigPropertyLoader.reset();
        }
    }

    protected TransactionContainer getTransactionContainter() {
        try {
            return TransactionFactory.create(ConfigPropertyLoader.getInstance());
        }
        catch (QueryTestFailedException e) {
            e.printStackTrace();
            throw new TransactionRuntimeException(e);
        }
    }

    private Properties getSubstitutedProperties(Properties props) {
        Properties or = new Properties();
        Properties configprops = ConfigPropertyLoader.getInstance().getProperties();
        configprops.putAll((Map<?, ?>)props);
        or = PropertiesUtils.resolveNestedProperties((Properties)configprops);
        return or;
    }

    static {
        if (System.getProperty("config") == null) {
            System.setProperty("config", "./ctc_tests/ctc-test.properties");
        } else {
            System.out.println("Config File Set: " + System.getProperty("config"));
        }
        if (System.getProperty("project.loc") == null) {
            System.setProperty("project.loc", ".");
        }
    }
}

