/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.CacheListener;
import org.teiid.core.TeiidRuntimeException;

public class DefaultCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -5541424157695857527L;
    DefaultCache cacheRoot = new DefaultCache("Teiid");
    private volatile boolean destroyed = false;

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    @Override
    public <K, V> Cache<K, V> get(Cache.Type type, CacheConfiguration config) {
        if (!this.destroyed) {
            Cache node = this.cacheRoot.addChild(type.location());
            return node;
        }
        throw new TeiidRuntimeException("Cache system has been shutdown");
    }

    class DefaultCache<K, V>
    implements Cache<K, V>,
    Serializable {
        Map<K, V> map = new HashMap();
        Map<String, Cache> children = new HashMap<String, Cache>();
        String name;

        public DefaultCache(String name) {
            this.name = name;
        }

        @Override
        public void addListener(CacheListener listener) {
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public V remove(K key) {
            return this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public void removeListener() {
        }

        @Override
        public Cache addChild(String name) {
            if (this.children.get(name) != null) {
                return this.children.get(name);
            }
            DefaultCache<K, V> c = new DefaultCache<K, V>(name);
            this.children.put(name, c);
            return c;
        }

        @Override
        public Cache getChild(String name) {
            return this.children.get(name);
        }

        @Override
        public List<Cache> getChildren() {
            return new ArrayList<Cache>(this.children.values());
        }

        @Override
        public boolean removeChild(String name) {
            Cache obj = this.children.remove(name);
            return obj != null;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

