/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.List;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;

public interface BufferManager
extends StorageManager {
    public static final int DEFAULT_CONNECTOR_BATCH_SIZE = 1024;
    public static final int DEFAULT_PROCESSOR_BATCH_SIZE = 512;
    public static final int DEFAULT_MAX_PROCESSING_BATCHES = 128;
    public static final int DEFAULT_RESERVE_BUFFERS = 16384;

    public int getProcessorBatchSize();

    public int getConnectorBatchSize();

    public TupleBuffer createTupleBuffer(List var1, String var2, TupleSourceType var3) throws TeiidComponentException;

    public int getMaxProcessingBatchColumns();

    @Override
    public FileStore createFileStore(String var1);

    public int reserveBuffers(int var1, BufferReserveMode var2);

    public void releaseBuffers(int var1);

    public int getSchemaSize(List var1);

    public static enum BufferReserveMode {
        WAIT,
        FORCE,
        NO_WAIT;

    }

    public static enum TupleSourceType {
        PROCESSOR,
        FINAL;

    }
}

