/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.teiid.client.BatchSerializer;

public class TupleBatch
implements Externalizable {
    private static final long serialVersionUID = 6304443387337336957L;
    private int rowOffset;
    private List[] tuples;
    private boolean terminationFlag = false;
    private transient String[] types;

    public TupleBatch() {
    }

    public TupleBatch(int beginRow, List[] tuples) {
        this.rowOffset = beginRow;
        this.tuples = tuples;
    }

    public TupleBatch(int beginRow, List listOfTupleLists) {
        this.rowOffset = beginRow;
        this.tuples = listOfTupleLists.toArray(new List[listOfTupleLists.size()]);
    }

    public int getBeginRow() {
        return this.rowOffset;
    }

    public int getEndRow() {
        return this.rowOffset + this.tuples.length - 1;
    }

    public int getRowCount() {
        return this.tuples.length;
    }

    public List getTuple(int rowIndex) {
        return this.tuples[rowIndex - this.rowOffset];
    }

    public List[] getAllTuples() {
        return this.tuples;
    }

    public boolean getTerminationFlag() {
        return this.terminationFlag;
    }

    public void setTerminationFlag(boolean terminationFlag) {
        this.terminationFlag = terminationFlag;
    }

    public String[] getDataTypes() {
        return this.types;
    }

    public void setDataTypes(String[] types) {
        this.types = types;
    }

    public boolean containsRow(int row) {
        return this.rowOffset <= row && this.getEndRow() >= row;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("TupleBatch; beginning row=");
        s.append(this.rowOffset);
        s.append(", number of rows=");
        s.append(this.tuples.length);
        s.append(", lastBatch=");
        s.append(this.terminationFlag);
        return s.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rowOffset = in.readInt();
        this.terminationFlag = in.readBoolean();
        this.tuples = BatchSerializer.readBatch((ObjectInput)in, (String[])this.types);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rowOffset);
        out.writeBoolean(this.terminationFlag);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])this.types, (List[])this.tuples);
    }
}

