/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.common.buffer.AbstractTupleSource;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.DQPPlugin;
import org.teiid.logging.LogManager;
import org.teiid.query.sql.symbol.Expression;

public class TupleBuffer {
    private static final AtomicLong LOB_ID = new AtomicLong();
    private BatchManager manager;
    private String tupleSourceID;
    private List<?> schema;
    private String[] types;
    private int batchSize;
    private int rowCount;
    private boolean isFinal;
    private TreeMap<Integer, BatchManager.ManagedBatch> batches = new TreeMap();
    private ArrayList<List<?>> batchBuffer;
    private boolean removed;
    private boolean forwardOnly;
    private Map<String, Streamable<?>> lobReferences;
    private boolean lobs = true;

    public static String[] getTypeNames(List expressions) {
        if (expressions == null) {
            return null;
        }
        String[] types = new String[expressions.size()];
        ListIterator i = expressions.listIterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            types[i.previousIndex()] = DataTypeManager.getDataTypeName((Class)expr.getType());
        }
        return types;
    }

    public TupleBuffer(BatchManager manager, String id, List<?> schema, int batchSize) {
        this.manager = manager;
        this.tupleSourceID = id;
        this.schema = schema;
        this.types = TupleBuffer.getTypeNames(schema);
        this.batchSize = batchSize;
        if (this.types != null) {
            int i = 0;
            for (i = 0; i < this.types.length && !DataTypeManager.isLOB((String)this.types[i]) && this.types[i] != "object"; ++i) {
            }
            if (i == this.types.length) {
                this.lobs = false;
            }
        }
    }

    public boolean isLobs() {
        return this.lobs;
    }

    public void addTuple(List<?> tuple) throws TeiidComponentException {
        if (this.lobs) {
            this.correctLobReferences(new List[]{tuple});
        }
        ++this.rowCount;
        if (this.batchBuffer == null) {
            this.batchBuffer = new ArrayList(this.batchSize / 4);
        }
        this.batchBuffer.add(tuple);
        if (this.batchBuffer.size() == this.batchSize) {
            this.saveBatch(false, false);
        }
    }

    public void addTupleBatch(TupleBatch batch, boolean save) throws TeiidComponentException {
        this.setRowCount(batch.getBeginRow() - 1);
        if (save) {
            for (List tuple : batch.getAllTuples()) {
                this.addTuple(tuple);
            }
        } else {
            this.correctLobReferences(batch.getAllTuples());
        }
    }

    public void setRowCount(int rowCount) throws TeiidComponentException {
        assert (this.rowCount <= rowCount);
        if (this.rowCount != rowCount) {
            this.saveBatch(false, true);
            this.rowCount = rowCount;
        }
    }

    public void purge() {
        if (this.batchBuffer != null) {
            this.batchBuffer.clear();
        }
        for (BatchManager.ManagedBatch batch : this.batches.values()) {
            batch.remove();
        }
        this.batches.clear();
    }

    public void saveBatch() throws TeiidComponentException {
        this.saveBatch(false, false);
    }

    void saveBatch(boolean finalBatch, boolean force) throws TeiidComponentException {
        Assertion.assertTrue((!this.isRemoved() ? 1 : 0) != 0);
        if (this.batchBuffer == null || this.batchBuffer.isEmpty() || !force && this.batchBuffer.size() < Math.max(1, this.batchSize / 32)) {
            return;
        }
        TupleBatch writeBatch = new TupleBatch(this.rowCount - this.batchBuffer.size() + 1, this.batchBuffer);
        if (finalBatch) {
            writeBatch.setTerminationFlag(true);
        }
        writeBatch.setDataTypes(this.types);
        BatchManager.ManagedBatch mbatch = this.manager.createManagedBatch(writeBatch);
        this.batches.put(writeBatch.getBeginRow(), mbatch);
        this.batchBuffer = null;
    }

    public void close() throws TeiidComponentException {
        this.saveBatch(true, false);
        this.isFinal = true;
    }

    public TupleBatch getBatch(int row) throws TeiidComponentException {
        TupleBatch result = null;
        if (row > this.rowCount) {
            result = new TupleBatch(this.rowCount + 1, new List[0]);
        } else if (this.batchBuffer != null && row > this.rowCount - this.batchBuffer.size()) {
            result = new TupleBatch(this.rowCount - this.batchBuffer.size() + 1, this.batchBuffer);
            if (this.forwardOnly) {
                this.batchBuffer = null;
            }
        } else {
            if (this.batchBuffer != null && !this.batchBuffer.isEmpty()) {
                this.saveBatch(this.isFinal, false);
            }
            Map.Entry<Integer, BatchManager.ManagedBatch> entry = this.batches.floorEntry(row);
            Assertion.isNotNull(entry);
            BatchManager.ManagedBatch batch = entry.getValue();
            result = batch.getBatch(!this.forwardOnly, this.types);
            if (this.lobs && result.getDataTypes() == null) {
                this.correctLobReferences(result.getAllTuples());
            }
            result.setDataTypes(this.types);
            if (this.forwardOnly) {
                this.batches.remove(entry.getKey());
            }
        }
        if (this.isFinal && result.getEndRow() == this.rowCount) {
            result.setTerminationFlag(true);
        }
        return result;
    }

    public void remove() {
        if (!this.removed) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Removing TupleBuffer:", this.tupleSourceID});
            }
            this.batchBuffer = null;
            this.purge();
            this.manager.remove();
            this.removed = true;
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public List<?> getSchema() {
        return this.schema;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        Streamable<?> lob = null;
        if (this.lobReferences != null) {
            lob = this.lobReferences.get(id);
        }
        if (lob == null) {
            throw new TeiidComponentException(DQPPlugin.Util.getString("ProcessWorker.wrongdata"));
        }
        return lob;
    }

    private void correctLobReferences(List[] rows) throws TeiidComponentException {
        int columns = this.schema.size();
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < columns; ++col) {
                Object anObj = rows[row].get(col);
                if (!(anObj instanceof Streamable)) continue;
                Streamable lob = (Streamable)anObj;
                String id = lob.getReferenceStreamId();
                if (id == null) {
                    id = String.valueOf(LOB_ID.getAndIncrement());
                    lob.setReferenceStreamId(id);
                }
                if (this.lobReferences == null) {
                    this.lobReferences = Collections.synchronizedMap(new HashMap());
                }
                this.lobReferences.put(id, lob);
                if (lob.getReference() != null) continue;
                lob.setReference(this.getLobReference(lob.getReferenceStreamId()).getReference());
            }
        }
    }

    public void setForwardOnly(boolean forwardOnly) {
        this.forwardOnly = forwardOnly;
    }

    public IndexedTupleSource createIndexedTupleSource() {
        return new AbstractTupleSource(){

            @Override
            public List<? extends Expression> getSchema() {
                return TupleBuffer.this.schema;
            }

            @Override
            protected List<?> finalRow() throws BlockedException {
                if (TupleBuffer.this.isFinal) {
                    return null;
                }
                throw BlockedException.INSTANCE;
            }

            @Override
            public int available() {
                return TupleBuffer.this.rowCount - this.getCurrentIndex() + 1;
            }

            @Override
            protected TupleBatch getBatch(int row) throws TeiidComponentException {
                return TupleBuffer.this.getBatch(row);
            }
        };
    }

    public String toString() {
        return this.tupleSourceID;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isForwardOnly() {
        return this.forwardOnly;
    }
}

