/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.SQLXML;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.Source;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.SourceTransform;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.processor.xml.XMLUtil;

public class BufferManagerImpl
implements BufferManager,
StorageManager {
    private static final int IO_BUFFER_SIZE = 16384;
    private int connectorBatchSize = 1024;
    private int processorBatchSize = 512;
    private int maxProcessingBatches = 128;
    private int maxReserveBatchColumns = 16384;
    private volatile int reserveBatchColumns = 16384;
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition batchesFreed = this.lock.newCondition();
    private volatile int activeBatchColumnCount = 0;
    private Map<String, TupleBufferInfo> activeBatches = new LinkedHashMap<String, TupleBufferInfo>();
    private StorageManager diskMgr;
    private AtomicLong currentTuple = new AtomicLong();
    private AtomicInteger batchAdded = new AtomicInteger();
    private AtomicInteger readCount = new AtomicInteger();
    private AtomicInteger writeCount = new AtomicInteger();
    private AtomicInteger readAttempts = new AtomicInteger();
    private AtomicInteger referenceHit = new AtomicInteger();

    @Override
    public int getMaxProcessingBatchColumns() {
        return this.maxProcessingBatches;
    }

    public void setMaxProcessingBatchColumns(int maxProcessingBatches) {
        this.maxProcessingBatches = Math.max(0, maxProcessingBatches);
    }

    @Override
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    @Override
    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.connectorBatchSize = connectorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    public void setStorageManager(StorageManager storageManager) {
        Assertion.isNotNull((Object)storageManager);
        Assertion.isNull((Object)this.diskMgr);
        this.diskMgr = storageManager;
    }

    public StorageManager getStorageManager() {
        return this.diskMgr;
    }

    @Override
    public TupleBuffer createTupleBuffer(List elements, String groupName, BufferManager.TupleSourceType tupleSourceType) {
        final String newID = String.valueOf(this.currentTuple.getAndIncrement());
        BatchManager batchManager = new BatchManager(){
            private FileStore store;

            @Override
            public BatchManager.ManagedBatch createManagedBatch(TupleBatch batch) throws TeiidComponentException {
                if (this.store == null) {
                    this.store = BufferManagerImpl.this.createFileStore(newID);
                    this.store.setCleanupReference(this);
                }
                ManagedBatchImpl mbi = new ManagedBatchImpl(newID, this.store, batch);
                mbi.addToCache(false);
                BufferManagerImpl.this.persistBatchReferences();
                return mbi;
            }

            @Override
            public void remove() {
                if (this.store != null) {
                    this.store.remove();
                    this.store = null;
                }
            }
        };
        TupleBuffer tupleBuffer = new TupleBuffer(batchManager, newID, elements, this.getProcessorBatchSize());
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating TupleBuffer:", newID, "of type ", tupleSourceType});
        return tupleBuffer;
    }

    @Override
    public FileStore createFileStore(String name) {
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating FileStore:", name});
        return this.diskMgr.createFileStore(name);
    }

    @Override
    public void initialize() throws TeiidComponentException {
        DataTypeManager.addSourceTransform(Source.class, (SourceTransform)new SourceTransform<Source, XMLType>(){

            public XMLType transform(Source value) {
                SQLXMLImpl sqlxml;
                if (value instanceof InputStreamFactory) {
                    return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
                }
                StandardXMLTranslator sxt = new StandardXMLTranslator(value);
                try {
                    sqlxml = XMLUtil.saveToBufferManager(BufferManagerImpl.this, (XMLTranslator)sxt);
                }
                catch (TeiidComponentException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
                catch (TeiidProcessingException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
                return new XMLType((SQLXML)sqlxml);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseBuffers(int count) {
        if (count < 1) {
            return;
        }
        this.lock.lock();
        try {
            this.reserveBatchColumns += count;
            this.batchesFreed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reserveBuffers(int count, BufferManager.BufferReserveMode mode) {
        this.lock.lock();
        try {
            int waitCount;
            if (mode == BufferManager.BufferReserveMode.WAIT) {
                waitCount = 0;
                while (count - waitCount > this.reserveBatchColumns) {
                    try {
                        this.batchesFreed.await(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new TeiidRuntimeException((Throwable)e);
                    }
                    ++waitCount;
                }
            }
            if (this.reserveBatchColumns >= count || mode == BufferManager.BufferReserveMode.FORCE) {
                this.reserveBatchColumns -= count;
                waitCount = count;
                return waitCount;
            }
            int result = Math.max(0, this.reserveBatchColumns);
            this.reserveBatchColumns -= result;
            int n = result;
            return n;
        }
        finally {
            this.lock.unlock();
            this.persistBatchReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBatchReferences() {
        if (this.activeBatchColumnCount == 0 || this.activeBatchColumnCount <= this.reserveBatchColumns) {
            int memoryCount = this.activeBatchColumnCount + this.maxReserveBatchColumns - this.reserveBatchColumns;
            if (DataTypeManager.isValueCacheEnabled()) {
                if (memoryCount < this.maxReserveBatchColumns / 8) {
                    DataTypeManager.setValueCacheEnabled((boolean)false);
                }
            } else if (memoryCount > this.maxReserveBatchColumns / 4) {
                DataTypeManager.setValueCacheEnabled((boolean)true);
            }
            return;
        }
        while (true) {
            ManagedBatchImpl mb = null;
            Map<String, TupleBufferInfo> map = this.activeBatches;
            synchronized (map) {
                if (this.activeBatchColumnCount == 0 || this.activeBatchColumnCount * 5 < this.reserveBatchColumns * 4) {
                    break;
                }
                Iterator<TupleBufferInfo> iter = this.activeBatches.values().iterator();
                TupleBufferInfo tbi = iter.next();
                Map.Entry<Integer, ManagedBatchImpl> entry = null;
                if (tbi.lastUsed != null) {
                    entry = tbi.batches.floorEntry(tbi.lastUsed - 1);
                }
                if (entry == null) {
                    entry = tbi.batches.lastEntry();
                }
                tbi.removeBatch((Integer)entry.getKey());
                if (tbi.batches.isEmpty()) {
                    iter.remove();
                }
                mb = entry.getValue();
            }
            try {
                mb.persist();
            }
            catch (TeiidComponentException e) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object[])new Object[]{"Error persisting batch, attempts to read that batch later will result in an exception"});
            }
        }
    }

    @Override
    public int getSchemaSize(List elements) {
        return elements.size();
    }

    public void setMaxReserveBatchColumns(int maxReserve) {
        this.maxReserveBatchColumns = maxReserve;
        this.reserveBatchColumns = maxReserve;
    }

    public void shutdown() {
    }

    private final class ManagedBatchImpl
    implements BatchManager.ManagedBatch {
        private final String id;
        private final FileStore store;
        private long offset = -1L;
        private boolean persistent;
        private volatile TupleBatch activeBatch;
        private volatile Reference<TupleBatch> batchReference;
        private int beginRow;
        private int columnCount;

        public ManagedBatchImpl(String id, FileStore store, TupleBatch batch) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Add batch to BufferManager", BufferManagerImpl.this.batchAdded.incrementAndGet()});
            this.id = id;
            this.store = store;
            this.activeBatch = batch;
            this.beginRow = batch.getBeginRow();
            List[] allTuples = batch.getAllTuples();
            if (allTuples.length > 0) {
                this.columnCount = allTuples[0].size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToCache(boolean update) {
            Map map = BufferManagerImpl.this.activeBatches;
            synchronized (map) {
                TupleBatch batch = this.activeBatch;
                if (batch == null) {
                    return;
                }
                BufferManagerImpl.this.activeBatchColumnCount += this.columnCount;
                TupleBufferInfo tbi = null;
                tbi = update ? (TupleBufferInfo)BufferManagerImpl.this.activeBatches.remove(this.id) : (TupleBufferInfo)BufferManagerImpl.this.activeBatches.get(this.id);
                if (tbi == null) {
                    tbi = new TupleBufferInfo();
                    update = true;
                }
                if (update) {
                    BufferManagerImpl.this.activeBatches.put(this.id, tbi);
                }
                Assertion.isNull((Object)tbi.batches.put(this.beginRow, this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TupleBatch getBatch(boolean cache, String[] types) throws TeiidComponentException {
            int reads = BufferManagerImpl.this.readAttempts.incrementAndGet();
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, "getting batch", reads, "reference hits", BufferManagerImpl.this.referenceHit.get()});
            Object object = BufferManagerImpl.this.activeBatches;
            synchronized (object) {
                TupleBufferInfo tbi = (TupleBufferInfo)BufferManagerImpl.this.activeBatches.remove(this.id);
                if (tbi != null) {
                    boolean put = true;
                    if (!cache) {
                        tbi.removeBatch(this.beginRow);
                        if (tbi.batches.isEmpty()) {
                            put = false;
                        }
                    }
                    if (put) {
                        tbi.lastUsed = this.beginRow;
                        BufferManagerImpl.this.activeBatches.put(this.id, tbi);
                    }
                }
            }
            BufferManagerImpl.this.persistBatchReferences();
            object = this;
            synchronized (object) {
                TupleBatch batch = this.activeBatch;
                if (batch != null) {
                    return batch;
                }
                Reference<TupleBatch> ref = this.batchReference;
                this.batchReference = null;
                if (ref != null && (batch = ref.get()) != null) {
                    if (cache) {
                        this.activeBatch = batch;
                        this.addToCache(true);
                    }
                    BufferManagerImpl.this.referenceHit.getAndIncrement();
                    return batch;
                }
                int count = BufferManagerImpl.this.readCount.incrementAndGet();
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, this.beginRow, "reading batch from disk, total reads:", count});
                try {
                    ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(this.store.createInputStream(this.offset), 16384));
                    batch = new TupleBatch();
                    batch.setDataTypes(types);
                    batch.readExternal(ois);
                    batch.setDataTypes(null);
                    if (cache) {
                        this.activeBatch = batch;
                        this.addToCache(true);
                    }
                    return batch;
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e, QueryExecPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{this.id}));
                }
                catch (ClassNotFoundException e) {
                    throw new TeiidComponentException((Throwable)e, QueryExecPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{this.id}));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void persist() throws TeiidComponentException {
            block9: {
                try {
                    TupleBatch batch = this.activeBatch;
                    if (batch == null) break block9;
                    if (!this.persistent) {
                        int count = BufferManagerImpl.this.writeCount.incrementAndGet();
                        LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, this.beginRow, "writing batch to disk, total writes: ", count});
                        FileStore fileStore = this.store;
                        synchronized (fileStore) {
                            this.offset = this.store.getLength();
                            BufferedOutputStream fsos = new BufferedOutputStream(this.store.createOutputStream(), 16384);
                            ObjectOutputStream oos = new ObjectOutputStream(fsos);
                            batch.writeExternal(oos);
                            oos.close();
                        }
                        LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, this.beginRow, "batch written starting at:", this.offset});
                    }
                    this.batchReference = new WeakReference<TupleBatch>(batch);
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e);
                }
                finally {
                    this.persistent = true;
                    this.activeBatch = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Map map = BufferManagerImpl.this.activeBatches;
            synchronized (map) {
                TupleBufferInfo tbi = (TupleBufferInfo)BufferManagerImpl.this.activeBatches.get(this.id);
                if (tbi != null && tbi.removeBatch(this.beginRow) != null && tbi.batches.isEmpty()) {
                    BufferManagerImpl.this.activeBatches.remove(this.id);
                }
            }
            this.activeBatch = null;
            this.batchReference = null;
        }

        public String toString() {
            return "ManagedBatch " + this.id + " " + this.activeBatch;
        }
    }

    private class TupleBufferInfo {
        TreeMap<Integer, ManagedBatchImpl> batches = new TreeMap();
        Integer lastUsed = null;

        private TupleBufferInfo() {
        }

        ManagedBatchImpl removeBatch(int row) {
            ManagedBatchImpl result = this.batches.remove(row);
            if (result != null) {
                BufferManagerImpl.this.activeBatchColumnCount -= result.columnCount;
            }
            return result;
        }
    }
}

