/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.cache;

import java.io.Serializable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.logging.LogManager;

public class DQPContextCache
implements Serializable {
    private static final long serialVersionUID = 6958846566556640186L;
    private Cache cache;
    private String processIdentifier;

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cache = cacheFactory.get(Cache.Type.SCOPED_CACHE, new CacheConfiguration(CacheConfiguration.Policy.LRU, 600, 10000));
    }

    public void setProcessName(String name) {
        this.processIdentifier = name;
    }

    public Cache getGlobalScopedCache() {
        return this.cache.addChild(Scope.GLOBAL.name());
    }

    public void stop() {
        try {
            this.cache.removeChild(this.processIdentifier);
        }
        catch (IllegalStateException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
        }
    }

    public Cache getRequestScopedCache(String request) {
        Cache processCache = this.cache.addChild(this.processIdentifier);
        Cache scopeNode = processCache.addChild(Scope.REQUEST.name());
        return scopeNode.addChild(request.toString());
    }

    public void removeRequestScopedCache(String request) {
        try {
            Cache scopeNode;
            Cache processCache = this.cache.getChild(this.processIdentifier);
            if (processCache != null && (scopeNode = processCache.getChild(Scope.REQUEST.name())) != null) {
                scopeNode.removeChild(request.toString());
            }
        }
        catch (IllegalStateException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
        }
    }

    public Cache getServiceScopedCache(String serviceId) {
        Cache processCache = this.cache.addChild(this.processIdentifier);
        Cache scopeNode = processCache.addChild(Scope.SERVICE.name());
        return scopeNode.addChild(serviceId);
    }

    public void removeServiceScopedCache(String serviceId) {
        try {
            Cache scopeNode;
            Cache processCache = this.cache.getChild(this.processIdentifier);
            if (processCache != null && (scopeNode = processCache.addChild(Scope.SERVICE.name())) != null) {
                scopeNode.removeChild(serviceId);
            }
        }
        catch (IllegalStateException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
        }
    }

    public Cache getSessionScopedCache(String session) {
        Cache scopeNode = this.cache.addChild(Scope.SESSION.name());
        return scopeNode.addChild(session);
    }

    public void removeSessionScopedCache(String session) {
        try {
            Cache scopeNode = this.cache.addChild(Scope.SESSION.name());
            if (scopeNode != null) {
                scopeNode.removeChild(session);
            }
        }
        catch (IllegalStateException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
        }
    }

    public Cache getVDBScopedCache(String vdbName, int vdbVersion) {
        Cache scopeNode = this.cache.addChild(Scope.VDB.name());
        String id = vdbName + "-" + vdbVersion;
        return scopeNode.addChild(id.toUpperCase());
    }

    public void removeVDBScopedCache(String vdbName, int vdbVersion) {
        try {
            Cache scopeNode = this.cache.addChild(Scope.VDB.name());
            if (scopeNode != null) {
                String id = vdbName + "-" + vdbVersion;
                scopeNode.removeChild(id.toUpperCase());
            }
        }
        catch (IllegalStateException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
        }
    }

    private static enum Scope {
        REQUEST,
        SESSION,
        SERVICE,
        VDB,
        GLOBAL;

    }
}

