/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.impl;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.cache.DQPContextCache;
import org.teiid.dqp.internal.datamgr.impl.CapabilitiesConverter;
import org.teiid.dqp.internal.datamgr.impl.ConnectorWork;
import org.teiid.dqp.internal.datamgr.impl.ConnectorWorkItem;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.service.BufferService;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.sql.lang.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConnectorManager {
    private static final String JAVA_CONTEXT = "java:";
    public static final int DEFAULT_MAX_THREADS = 20;
    private static AtomicInteger ID_SEQUENCE = new AtomicInteger();
    private String translatorName;
    private String connectionName;
    private String connectorId = String.valueOf(ID_SEQUENCE.getAndIncrement());
    private BufferService bufferService;
    private ConcurrentHashMap<AtomicRequestID, ConnectorWorkItem> requestStates = new ConcurrentHashMap();
    private SourceCapabilities cachedCapabilities;
    private int currentConnections;
    private int maxConnections = 20;
    private LinkedList<ConnectorWorkItem> queuedRequests = new LinkedList();
    private volatile boolean stopped;
    private ExecutionFactory<Object, Object> executionFactory;

    public ConnectorManager(String translatorName, String connectionName) {
        this.translatorName = translatorName;
        this.connectionName = connectionName;
    }

    public String getStausMessage() {
        StringBuilder sb = new StringBuilder();
        ExecutionFactory<Object, Object> ef = this.getExecutionFactory();
        if (ef != null) {
            Object conn;
            if (ef.isSourceRequired() && (conn = this.getConnectionFactory()) == null) {
                sb.append(DQPPlugin.Util.getString("datasource_not_found", new Object[]{this.connectionName}));
            }
        } else {
            sb.append(DQPPlugin.Util.getString("translator_not_found", new Object[]{this.translatorName}));
        }
        return sb.toString();
    }

    public synchronized void acquireConnectionLock(ConnectorWorkItem item) throws BlockedException {
        switch (item.getPermitMode()) {
            case NOT_ACQUIRED: {
                if (this.currentConnections < this.maxConnections) {
                    ++this.currentConnections;
                    item.setPermitMode(ConnectorWorkItem.PermitMode.ACQUIRED);
                    return;
                }
                this.queuedRequests.add(item);
                item.setPermitMode(ConnectorWorkItem.PermitMode.BLOCKED);
            }
            case BLOCKED: {
                throw BlockedException.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataStore getMetadata(String modelName, Map<String, Datatype> datatypes, Properties importProperties) throws TranslatorException {
        MetadataFactory factory = new MetadataFactory(modelName, datatypes, importProperties);
        ExecutionFactory<Object, Object> executionFactory = this.getExecutionFactory();
        Object connectionFactory = this.getConnectionFactory();
        Object connection = executionFactory.getConnection(connectionFactory);
        try {
            executionFactory.getMetadata(factory, connection);
        }
        finally {
            executionFactory.closeConnection(connection, connectionFactory);
        }
        return factory.getMetadataStore();
    }

    public SourceCapabilities getCapabilities() throws TranslatorException {
        if (this.cachedCapabilities != null) {
            return this.cachedCapabilities;
        }
        this.checkStatus();
        ExecutionFactory<Object, Object> translator = this.getExecutionFactory();
        BasicSourceCapabilities resultCaps = CapabilitiesConverter.convertCapabilities(translator, this.connectorId);
        resultCaps.setScope(SourceCapabilities.Scope.SCOPE_GLOBAL);
        this.cachedCapabilities = resultCaps;
        return resultCaps;
    }

    public ConnectorWork executeRequest(AtomicRequestMessage message, AbstractWorkItem awi) throws TranslatorException {
        this.checkStatus();
        AtomicRequestID atomicRequestId = message.getAtomicRequestID();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{atomicRequestId, "Create State"});
        ConnectorWorkItem item = new ConnectorWorkItem(message, awi, this);
        Assertion.isNull((Object)this.requestStates.put(atomicRequestId, item), (String)"State already existed");
        return item;
    }

    ConnectorWork getState(AtomicRequestID requestId) {
        return this.requestStates.get(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeState(AtomicRequestID id) {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{id, "Remove State"});
        ConnectorWorkItem cwi = this.requestStates.remove(id);
        if (cwi != null && cwi.getPermitMode() == ConnectorWorkItem.PermitMode.ACQUIRED) {
            ConnectorManager connectorManager = this;
            synchronized (connectorManager) {
                ConnectorWorkItem next = this.queuedRequests.pollFirst();
                if (next == null) {
                    --this.currentConnections;
                    return;
                }
                next.setPermitMode(ConnectorWorkItem.PermitMode.ACQUIRED);
                next.getParent().moreWork();
            }
        }
    }

    int size() {
        return this.requestStates.size();
    }

    public void setBufferService(BufferService service) {
        this.bufferService = service;
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{DQPPlugin.Util.getString("ConnectorManagerImpl.Initializing_connector", new Object[]{this.translatorName})});
    }

    public void stop() {
        this.stopped = true;
        for (ConnectorWorkItem workItem : this.requestStates.values()) {
            workItem.cancel();
        }
    }

    void logSRCCommand(AtomicRequestMessage qr, ExecutionContext context, CommandLogMessage.Event cmdStatus, Integer finalRowCnt) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5)) {
            return;
        }
        String sqlStr = null;
        if (cmdStatus == CommandLogMessage.Event.NEW) {
            Command cmd = qr.getCommand();
            sqlStr = cmd != null ? cmd.toString() : null;
        }
        String userName = qr.getWorkContext().getUserName();
        String transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTransactionId();
        }
        String modelName = qr.getModelName();
        AtomicRequestID id = qr.getAtomicRequestID();
        String principal = userName == null ? "unknown" : userName;
        CommandLogMessage message = null;
        message = cmdStatus == CommandLogMessage.Event.NEW ? new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, sqlStr, context) : new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, finalRowCnt, cmdStatus, context);
        LogManager.log((int)5, (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    protected ExecutionFactory<Object, Object> getExecutionFactory() {
        if (this.executionFactory == null) {
            try {
                InitialContext ic = new InitialContext();
                return (ExecutionFactory)ic.lookup(this.translatorName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.executionFactory;
    }

    public void setExecutionFactory(ExecutionFactory<Object, Object> ef) {
        this.executionFactory = ef;
    }

    protected Object getConnectionFactory() {
        if (this.connectionName != null) {
            String jndiName = this.connectionName;
            if (!this.connectionName.startsWith(JAVA_CONTEXT)) {
                jndiName = JAVA_CONTEXT + jndiName;
            }
            try {
                InitialContext ic = new InitialContext();
                try {
                    return ic.lookup(jndiName);
                }
                catch (NamingException e) {
                    if (!jndiName.equals(this.connectionName)) {
                        return ic.lookup(this.connectionName);
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return null;
    }

    DQPContextCache getContextCache() {
        if (this.bufferService != null) {
            return this.bufferService.getContextCache();
        }
        return null;
    }

    private void checkStatus() throws TranslatorException {
        if (this.stopped) {
            throw new TranslatorException(DQPPlugin.Util.getString("ConnectorManager.not_in_valid_state", new Object[]{this.translatorName}));
        }
    }

    public void setMaxConnections(int value) {
        this.maxConnections = value;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }
}

