/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.impl;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.teiid.cache.Cache;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.cache.DQPContextCache;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.translator.CacheScope;
import org.teiid.translator.ExecutionContext;

public class ExecutionContextImpl
implements ExecutionContext {
    private String requestID;
    private String partID;
    private String connectorName;
    private String vdbName;
    private int vdbVersion;
    private Subject user;
    private Serializable executionPayload;
    private String requestConnectionID;
    private String executeCount;
    private boolean keepAlive = false;
    private boolean isTransactional;
    private DQPContextCache contextCache;
    private int batchSize = 1024;
    private List<Exception> warnings = new LinkedList<Exception>();

    public ExecutionContextImpl(String vdbName, int vdbVersion, Serializable executionPayload, String originalConnectionID, String connectorName, String requestId, String partId, String execCount) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.executionPayload = executionPayload;
        this.connectorName = connectorName;
        this.requestID = requestId;
        this.partID = partId;
        this.requestConnectionID = originalConnectionID;
        this.executeCount = execCount;
    }

    public String getConnectorIdentifier() {
        return this.connectorName;
    }

    public String getRequestIdentifier() {
        return this.requestID;
    }

    public String getPartIdentifier() {
        return this.partID;
    }

    public String getExecutionCountIdentifier() {
        return this.executeCount;
    }

    public String getVirtualDatabaseName() {
        return this.vdbName;
    }

    public int getVirtualDatabaseVersion() {
        return this.vdbVersion;
    }

    public Subject getSubject() {
        return this.user;
    }

    public void setUser(Subject user) {
        this.user = user;
    }

    public Serializable getExecutionPayload() {
        return this.executionPayload;
    }

    public String getConnectionIdentifier() {
        return this.requestConnectionID;
    }

    public void keepExecutionAlive(boolean alive) {
        this.keepAlive = alive;
    }

    boolean keepExecutionAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)obj;
        return this.compareWithNull(this.getRequestIdentifier(), other.getRequestIdentifier()) && this.compareWithNull(this.getPartIdentifier(), other.getPartIdentifier());
    }

    private boolean compareWithNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.requestID}), (Object[])new Object[]{this.partID});
    }

    public String toString() {
        String userName = null;
        if (this.user != null) {
            for (Principal p : this.user.getPrincipals()) {
                userName = p.getName();
            }
        }
        return "ExecutionContext<vdb=" + this.vdbName + ", version=" + this.vdbVersion + ", user=" + userName + ">";
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void addWarning(Exception ex) {
        if (ex == null) {
            return;
        }
        this.warnings.add(ex);
    }

    public List<Exception> getWarnings() {
        ArrayList<Exception> result = new ArrayList<Exception>(this.warnings);
        this.warnings.clear();
        return result;
    }

    public void setContextCache(DQPContextCache cache) {
        this.contextCache = cache;
    }

    public Object get(Object key) {
        if (this.contextCache != null) {
            Cache cache = this.contextCache.getRequestScopedCache(this.getRequestIdentifier());
            return cache.get(key);
        }
        return null;
    }

    public void put(Object key, Object value) {
        if (this.contextCache != null) {
            Cache cache = this.contextCache.getRequestScopedCache(this.getRequestIdentifier());
            cache.put(key, value);
        }
    }

    public Object getFromCache(CacheScope scope, Object key) {
        DQPWorkContext context = DQPWorkContext.getWorkContext();
        this.checkScopeValidity(scope, context);
        Cache cache = this.getScopedCache(scope, context);
        if (cache != null) {
            return cache.get(key);
        }
        return null;
    }

    public void storeInCache(CacheScope scope, Object key, Object value) {
        DQPWorkContext context = DQPWorkContext.getWorkContext();
        this.checkScopeValidity(scope, context);
        Cache cache = this.getScopedCache(scope, context);
        if (cache != null) {
            cache.put(key, value);
        }
    }

    private Cache getScopedCache(CacheScope scope, DQPWorkContext context) {
        switch (scope) {
            case SERVICE: {
                return this.contextCache.getServiceScopedCache(this.getConnectorIdentifier());
            }
            case SESSION: {
                return this.contextCache.getSessionScopedCache(String.valueOf(context.getSessionToken().getSessionID()));
            }
            case VDB: {
                return this.contextCache.getVDBScopedCache(context.getVdbName(), context.getVdbVersion());
            }
            case GLOBAL: {
                return this.contextCache.getGlobalScopedCache();
            }
        }
        return null;
    }

    private void checkScopeValidity(CacheScope scope, DQPWorkContext context) {
        if (scope == CacheScope.REQUEST) {
            throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorEnvironmentImpl.request_scope_error"));
        }
        if (scope == CacheScope.SESSION) {
            if (context == null || context.getSessionToken() == null) {
                throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorEnvironmentImpl.session_scope_error"));
            }
        } else if (scope == CacheScope.VDB && (context == null || context.getVdbName() == null || context.getVdbVersion() == 0)) {
            throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorEnvironmentImpl.vdb_scope_error"));
        }
    }
}

