/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.vdb.runtime.VDBKey;

public class TranslatorRepository
implements Serializable {
    private static final long serialVersionUID = -1212280886010974273L;
    private Map<String, TranslatorMetaData> translatorRepo = new ConcurrentHashMap<String, TranslatorMetaData>();
    private Map<VDBKey, Map<String, VDBTranslatorMetaData>> vdbScopedTranslatorRepo = new ConcurrentHashMap<VDBKey, Map<String, VDBTranslatorMetaData>>();

    public void addTranslatorMetadata(String name, TranslatorMetaData factory) {
        this.translatorRepo.put(name, factory);
    }

    public void addTranslatorMetadata(VDBKey key, String name, VDBTranslatorMetaData factory) {
        Map<String, VDBTranslatorMetaData> repo = this.vdbScopedTranslatorRepo.get(key);
        if (repo == null) {
            repo = new ConcurrentHashMap<String, VDBTranslatorMetaData>();
            this.vdbScopedTranslatorRepo.put(key, repo);
        }
        repo.put(name, factory);
    }

    public Translator getTranslatorMetaData(VDBKey key, String name) {
        Map<String, VDBTranslatorMetaData> repo;
        Translator factory = null;
        if (key != null && (repo = this.vdbScopedTranslatorRepo.get(key)) != null && !repo.isEmpty()) {
            factory = (Translator)repo.get(name);
        }
        if (factory == null) {
            factory = (Translator)this.translatorRepo.get(name);
        }
        return factory;
    }

    public TranslatorMetaData removeTranslatorMetadata(String name) {
        return this.translatorRepo.remove(name);
    }

    public void removeVDBTranslators(VDBKey name) {
        this.vdbScopedTranslatorRepo.remove(name);
    }
}

