/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.HashMap;
import java.util.Map;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.translator.TranslatorException;

public class CachedFinder
implements CapabilitiesFinder {
    private static BasicSourceCapabilities SYSTEM_CAPS = new BasicSourceCapabilities();
    private ConnectorManagerRepository connectorRepo;
    private VDBMetaData vdb;
    private Map<String, SourceCapabilities> userCache = new HashMap<String, SourceCapabilities>();

    public CachedFinder(ConnectorManagerRepository repo, VDBMetaData vdb) {
        this.connectorRepo = repo;
        this.vdb = vdb;
        this.userCache.put("SYS", SYSTEM_CAPS);
    }

    @Override
    public SourceCapabilities findCapabilities(String modelName) throws TeiidComponentException {
        SourceCapabilities caps = this.userCache.get(modelName);
        if (caps != null) {
            return caps;
        }
        TranslatorException exception = null;
        ModelMetaData model = this.vdb.getModel(modelName);
        for (String sourceName : model.getSourceNames()) {
            try {
                ConnectorManager mgr = this.connectorRepo.getConnectorManager(sourceName);
                if (mgr == null) {
                    throw new TranslatorException(DQPPlugin.Util.getString("CachedFinder.no_connector_found", new Object[]{sourceName, modelName, sourceName}));
                }
                caps = mgr.getCapabilities();
                break;
            }
            catch (TranslatorException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw new TeiidComponentException(exception);
        }
        if (caps == null) {
            throw new TeiidRuntimeException("No sources were given for the model " + modelName);
        }
        this.userCache.put(modelName, caps);
        return caps;
    }
}

