/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.DQPPlugin;
import org.teiid.logging.LogManager;
import org.teiid.query.util.CommandContext;
import org.teiid.vdb.runtime.VDBKey;

class CodeTableCache {
    private int maxCodeTables;
    private int maxCodeRecords;
    private int maxCodeTableRecords;
    private int rowCount;
    private Map<CacheKey, CodeTable> codeTableCache = new HashMap<CacheKey, CodeTable>();

    public CodeTableCache(int maxCodeTables, int maxCodeRecords, int maxCodeTableRecords) {
        this.maxCodeRecords = maxCodeRecords;
        this.maxCodeTables = maxCodeTables;
        this.maxCodeTableRecords = maxCodeTableRecords;
    }

    public synchronized CacheState cacheExists(String codeTable, String returnElement, String keyElement, CommandContext context) {
        CacheKey cacheKey = new CacheKey(codeTable, returnElement, keyElement, context.getVdbName(), context.getVdbVersion());
        CodeTable table = this.codeTableCache.get(cacheKey);
        if (table == null) {
            if (this.codeTableCache.size() >= this.maxCodeTables) {
                return CacheState.CACHE_OVERLOAD;
            }
            table = new CodeTable();
            table.waitingRequests.add(context.getProcessorID());
            this.codeTableCache.put(cacheKey, table);
            return CacheState.CACHE_NOT_EXIST;
        }
        if (table.waitingRequests == null) {
            return CacheState.CACHE_EXISTS;
        }
        table.waitingRequests.add(context.getProcessorID());
        return CacheState.CACHE_LOADING;
    }

    public CacheKey createCacheRequest(String codeTable, String returnElement, String keyElement, CommandContext context) {
        return new CacheKey(codeTable, returnElement, keyElement, context.getVdbName(), context.getVdbVersion());
    }

    public synchronized void loadTable(CacheKey cacheKey, List[] records) throws TeiidProcessingException {
        int potentialSize;
        CodeTable table = this.codeTableCache.get(cacheKey);
        if (table.codeMap == null) {
            table.codeMap = new HashMap<Object, Object>();
        }
        if ((potentialSize = table.codeMap.size() + records.length) > this.maxCodeTableRecords) {
            throw new TeiidProcessingException("ERR.018.005.0100", DQPPlugin.Util.getString("ERR.018.005.0100", new Object[]{"maxCodeTables"}));
        }
        if (potentialSize + this.rowCount > this.maxCodeRecords) {
            throw new TeiidProcessingException("ERR.018.005.0100", DQPPlugin.Util.getString("ERR.018.005.0100", new Object[]{"maxCodeTableRecords"}));
        }
        for (int i = 0; i < records.length; ++i) {
            Object returnValue;
            List record = records[i];
            Object keyValue = record.get(0);
            Object existing = table.codeMap.put(keyValue, returnValue = record.get(1));
            if (existing == null) continue;
            throw new TeiidProcessingException(DQPPlugin.Util.getString("CodeTableCache.duplicate_key", new Object[]{cacheKey.getCodeTable(), cacheKey.getKeyElement(), keyValue}));
        }
    }

    public synchronized Object lookupValue(String codeTable, String returnElement, String keyElement, Object keyValue, CommandContext context) throws TeiidComponentException {
        CacheKey cacheKey = new CacheKey(codeTable, returnElement, keyElement, context.getVdbName(), context.getVdbVersion());
        CodeTable table = this.codeTableCache.get(cacheKey);
        if (table == null || table.codeMap == null) {
            throw new TeiidComponentException(DQPPlugin.Util.getString("CodeTableCache.No_code_table", new Object[]{cacheKey.codeTable, cacheKey.keyElement, cacheKey.returnElement}));
        }
        return table.codeMap.get(keyValue);
    }

    public synchronized Set<Object> markCacheDone(CacheKey cacheKey, boolean success) {
        if (!success) {
            CodeTable table = this.codeTableCache.remove(cacheKey);
            if (table != null) {
                return table.waitingRequests;
            }
            return null;
        }
        CodeTable table = this.codeTableCache.get(cacheKey);
        if (table == null || table.codeMap == null) {
            return null;
        }
        this.rowCount += table.codeMap.size();
        Set<Object> waiting = table.waitingRequests;
        table.waitingRequests = null;
        return waiting;
    }

    public synchronized void clearAll() {
        int removedTables = 0;
        int removedRecords = this.rowCount;
        Iterator<CodeTable> iter = this.codeTableCache.values().iterator();
        while (iter.hasNext()) {
            CodeTable table = iter.next();
            if (table.waitingRequests != null) continue;
            ++removedTables;
            iter.remove();
        }
        this.rowCount = 0;
        LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)DQPPlugin.Util.getString("CodeTableCache.Cleared_code_tables", new Object[]{removedTables, removedRecords}));
    }

    static class CacheKey {
        private String codeTable;
        private String returnElement;
        private String keyElement;
        private VDBKey vdbKey;
        private int hashCode;

        public CacheKey(String codeTable, String returnElement, String keyElement, String vdbName, int vdbVersion) {
            this.codeTable = codeTable;
            this.returnElement = returnElement;
            this.keyElement = keyElement;
            this.vdbKey = new VDBKey(vdbName, vdbVersion);
            this.hashCode = HashCodeUtil.hashCode((int)codeTable.toUpperCase().hashCode(), (Object[])new Object[]{returnElement.toUpperCase(), keyElement.toUpperCase(), this.vdbKey});
        }

        public String getCodeTable() {
            return this.codeTable;
        }

        public String getKeyElement() {
            return this.keyElement;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return other.hashCode() == this.hashCode() && this.codeTable.equalsIgnoreCase(other.codeTable) && this.returnElement.equalsIgnoreCase(other.returnElement) && this.keyElement.equalsIgnoreCase(other.keyElement) && this.vdbKey.equals(other.vdbKey);
            }
            return false;
        }
    }

    public static enum CacheState {
        CACHE_EXISTS,
        CACHE_LOADING,
        CACHE_NOT_EXIST,
        CACHE_OVERLOAD;

    }

    private static class CodeTable {
        Map<Object, Object> codeMap;
        Set<Object> waitingRequests = new HashSet<Object>();

        private CodeTable() {
        }
    }
}

