/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.core.util.ApplicationInfo;

public class DQPConfiguration {
    static final int DEFAULT_MAX_CODE_TABLE_RECORDS = 10000;
    static final int DEFAULT_MAX_CODE_TABLES = 200;
    static final int DEFAULT_MAX_CODE_RECORDS = 200000;
    static final int DEFAULT_FETCH_SIZE = 20480;
    static final int DEFAULT_PROCESSOR_TIMESLICE = 2000;
    static final int DEFAULT_MAX_RESULTSET_CACHE_ENTRIES = 1024;
    static final int DEFAULT_QUERY_THRESHOLD = 600;
    static final String PROCESS_PLAN_QUEUE_NAME = "QueryProcessorQueue";
    public static final int DEFAULT_MAX_PROCESS_WORKERS = 32;
    public static final int DEFAULT_MAX_SOURCE_ROWS = -1;
    private int maxThreads = 32;
    private int timeSliceInMilli = 2000;
    private boolean processDebugAllowed;
    private int maxRowsFetchSize = 20480;
    private int lobChunkSizeInKB = 100;
    private int preparedPlanCacheMaxCount = 250;
    private int codeTablesMaxCount = 200;
    private int codeTablesMaxRowsPerTable = 10000;
    private int codeTablesMaxRows = 200000;
    private boolean resultSetCacheEnabled = true;
    private int maxResultSetCacheEntries = 1024;
    private boolean useEntitlements = false;
    private int queryThresholdInSecs = 600;
    private boolean exceptionOnMaxSourceRows = true;
    private int maxSourceRows = -1;

    @ManagementProperty(description="Process pool maximum thread count. (default 32) Increase this value if the system's available processors is larger than 8")
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @ManagementProperty(description="Query processor time slice, in milliseconds. (default 2000)")
    public int getTimeSliceInMilli() {
        return this.timeSliceInMilli;
    }

    public void setTimeSliceInMilli(int timeSliceInMilli) {
        this.timeSliceInMilli = timeSliceInMilli;
    }

    @ManagementProperty(description="Process debug allowed")
    public boolean isProcessDebugAllowed() {
        return this.processDebugAllowed;
    }

    public void setProcessDebugAllowed(boolean processDebugAllowed) {
        this.processDebugAllowed = processDebugAllowed;
    }

    @ManagementProperty(description="Maximum allowed fetch size, set via JDBC. User requested value ignored above this value. (default 20480)")
    public int getMaxRowsFetchSize() {
        return this.maxRowsFetchSize;
    }

    public void setMaxRowsFetchSize(int maxRowsFetchSize) {
        this.maxRowsFetchSize = maxRowsFetchSize;
    }

    @ManagementProperty(description="The max lob chunk size in KB transferred each time when processing blobs, clobs(100KB default)")
    public int getLobChunkSizeInKB() {
        return this.lobChunkSizeInKB;
    }

    public void setLobChunkSizeInKB(int lobChunkSizeInKB) {
        this.lobChunkSizeInKB = lobChunkSizeInKB;
    }

    @ManagementProperty(description="The maximum number of query plans that are cached. Note: this is a memory based cache. (default 250)")
    public int getPreparedPlanCacheMaxCount() {
        return this.preparedPlanCacheMaxCount;
    }

    public void setPreparedPlanCacheMaxCount(int preparedPlanCacheMaxCount) {
        this.preparedPlanCacheMaxCount = preparedPlanCacheMaxCount;
    }

    @ManagementProperty(description="Maximum number of cached lookup tables. Note: this is a memory based cache. (default 200)")
    public int getCodeTablesMaxCount() {
        return this.codeTablesMaxCount;
    }

    public void setCodeTablesMaxCount(int codeTablesMaxCount) {
        this.codeTablesMaxCount = codeTablesMaxCount;
    }

    @ManagementProperty(description="Maximum number of records in a single lookup table (default 10000)")
    public int getCodeTablesMaxRowsPerTable() {
        return this.codeTablesMaxRowsPerTable;
    }

    public void setCodeTablesMaxRowsPerTable(int codeTablesMaxRowsPerTable) {
        this.codeTablesMaxRowsPerTable = codeTablesMaxRowsPerTable;
    }

    @ManagementProperty(description="Maximum number of records in all lookup tables (default 200000)")
    public int getCodeTablesMaxRows() {
        return this.codeTablesMaxRows;
    }

    public void setCodeTablesMaxRows(int codeTablesMaxRows) {
        this.codeTablesMaxRows = codeTablesMaxRows;
    }

    @ManagementProperty(description="The maximum number of result set cache entries. 0 indicates no limit. (default 1024)")
    public int getResultSetCacheMaxEntries() {
        return this.maxResultSetCacheEntries;
    }

    public void setResultSetCacheMaxEntries(int value) {
        this.maxResultSetCacheEntries = value;
    }

    @ManagementProperty(description="Denotes whether or not result set caching is enabled. (default true)")
    public boolean isResultSetCacheEnabled() {
        return this.resultSetCacheEnabled;
    }

    public void setResultSetCacheEnabled(boolean value) {
        this.resultSetCacheEnabled = value;
    }

    @ManagementProperty(description="Turn on checking the entitlements on resources based on the roles defined in VDB")
    public boolean useEntitlements() {
        return this.useEntitlements;
    }

    public void setUseEntitlements(Boolean useEntitlements) {
        this.useEntitlements = useEntitlements;
    }

    @ManagementProperty(description="Long running query threshold, after which a alert can be generated by tooling if configured")
    public int getQueryThresholdInSecs() {
        return this.queryThresholdInSecs;
    }

    public void setQueryThresholdInSecs(int queryThresholdInSecs) {
        this.queryThresholdInSecs = queryThresholdInSecs;
    }

    @ManagementProperty(description="Teiid runtime version", readOnly=true)
    public String getRuntimeVersion() {
        return ApplicationInfo.getInstance().getBuildNumber();
    }

    @ManagementProperty(description="Indicates if an exception should be thrown if the specified value for Maximum Source Rows is exceeded; only up to the maximum rows will be consumed.")
    public boolean isExceptionOnMaxSourceRows() {
        return this.exceptionOnMaxSourceRows;
    }

    public void setExceptionOnMaxSourceRows(boolean exceptionOnMaxSourceRows) {
        this.exceptionOnMaxSourceRows = exceptionOnMaxSourceRows;
    }

    @ManagementProperty(description="Maximum rows allowed from a source query. -1 indicates no limit. (default -1)")
    public int getMaxSourceRows() {
        return this.maxSourceRows;
    }

    public void setMaxSourceRows(int maxSourceRows) {
        this.maxSourceRows = maxSourceRows;
    }
}

