/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.SessionToken;
import org.teiid.dqp.message.RequestID;
import org.teiid.security.SecurityHelper;

public class DQPWorkContext
implements Serializable {
    private static final long serialVersionUID = -6389893410233192977L;
    private static ThreadLocal<DQPWorkContext> CONTEXTS = new ThreadLocal<DQPWorkContext>(){

        @Override
        protected DQPWorkContext initialValue() {
            return new DQPWorkContext();
        }
    };
    private SessionMetadata session = new SessionMetadata();
    private String clientAddress;
    private String clientHostname;
    private SecurityHelper securityHelper;
    private HashMap<String, DataPolicy> policies;

    public static DQPWorkContext getWorkContext() {
        return CONTEXTS.get();
    }

    public static void setWorkContext(DQPWorkContext context) {
        CONTEXTS.set(context);
    }

    public static void releaseWorkContext() {
        CONTEXTS.set(null);
    }

    public SessionMetadata getSession() {
        return this.session;
    }

    public void setSession(SessionMetadata session) {
        this.session = session;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public String getUserName() {
        return this.session.getUserName();
    }

    public Subject getSubject() {
        if (this.session.getLoginContext() != null) {
            return this.session.getLoginContext().getSubject();
        }
        return null;
    }

    public String getVdbName() {
        return this.session.getVDBName();
    }

    public int getVdbVersion() {
        return this.session.getVDBVersion();
    }

    public String getSessionId() {
        return this.session.getSessionId();
    }

    public String getAppName() {
        return this.session.getApplicationName();
    }

    public RequestID getRequestID(long exeuctionId) {
        return new RequestID(this.getSessionId(), exeuctionId);
    }

    public SessionToken getSessionToken() {
        return this.session.getSessionToken();
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public String getSecurityDomain() {
        return this.session.getSecurityDomain();
    }

    public Object getSecurityContext() {
        return this.session.getSecurityContext();
    }

    public VDBMetaData getVDB() {
        return this.session.getVdb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V runInContext(Callable<V> callable) throws Exception {
        DQPWorkContext.setWorkContext(this);
        boolean associated = false;
        if (this.securityHelper != null && this.getSubject() != null) {
            associated = this.securityHelper.assosiateSecurityContext(this.getSecurityDomain(), this.getSecurityContext());
        }
        try {
            V v = callable.call();
            return v;
        }
        finally {
            if (associated) {
                this.securityHelper.clearSecurityContext(this.getSecurityDomain());
            }
            DQPWorkContext.releaseWorkContext();
        }
    }

    public void runInContext(final Runnable runnable) {
        try {
            this.runInContext(new Callable<Void>(){

                @Override
                public Void call() {
                    runnable.run();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap<String, DataPolicy> getAllowedDataPolicies() {
        if (this.policies == null) {
            this.policies = new HashMap();
            Set<String> userRoles = this.getUserRoles();
            if (userRoles.isEmpty()) {
                return this.policies;
            }
            List policies = this.getVDB().getDataPolicies();
            for (DataPolicy policy : policies) {
                if (!this.matchesPrincipal(userRoles, policy)) continue;
                this.policies.put(policy.getName(), policy);
            }
        }
        return this.policies;
    }

    private boolean matchesPrincipal(Set<String> userRoles, DataPolicy policy) {
        List roles = policy.getMappedRoleNames();
        Iterator i$ = roles.iterator();
        if (i$.hasNext()) {
            String role = (String)i$.next();
            return userRoles.contains(role);
        }
        return false;
    }

    private Set<String> getUserRoles() {
        HashSet<String> roles = new HashSet<String>();
        if (this.getSubject() == null) {
            return Collections.EMPTY_SET;
        }
        Set<Principal> principals = this.getSubject().getPrincipals();
        for (Principal p : principals) {
            if (!(p instanceof Group) || !p.getName().equals("Roles")) continue;
            Group g = (Group)p;
            Enumeration rolesPrinciples = g.members();
            while (rolesPrinciples.hasMoreElements()) {
                roles.add(((Principal)rolesPrinciples.nextElement()).getName());
            }
        }
        return roles;
    }
}

