/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.impl.ConnectorWork;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.CodeTableCache;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.BufferService;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.CompositeMetadataStore;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.TranslatorException;

public class DataTierManagerImpl
implements ProcessorDataManager {
    private DQPCore requestMgr;
    private BufferService bufferService;
    private ConnectorManagerRepository connectorManagerRepository;
    private CodeTableCache codeTableCache;

    public DataTierManagerImpl(DQPCore requestMgr, ConnectorManagerRepository connectorRepo, BufferService bufferService, int maxCodeTables, int maxCodeRecords, int maxCodeTableRecords) {
        this.requestMgr = requestMgr;
        this.connectorManagerRepository = connectorRepo;
        this.bufferService = bufferService;
        this.codeTableCache = new CodeTableCache(maxCodeTables, maxCodeRecords, maxCodeTableRecords);
    }

    private ConnectorManager getCM(String connectorName) {
        return this.connectorManagerRepository.getConnectorManager(connectorName);
    }

    @Override
    public TupleSource registerRequest(Object processorId, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException, TeiidProcessingException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)processorId);
        if ("SYS".equals(modelName)) {
            return this.processSystemQuery(command, workItem.getDqpWorkContext());
        }
        AtomicRequestMessage aqr = this.createRequest(processorId, command, modelName, connectorBindingId, nodeID);
        return new DataTierTupleSource(aqr.getCommand().getProjectedSymbols(), aqr, this, aqr.getConnectorName(), workItem);
    }

    /*
     * WARNING - void declaration
     */
    private TupleSource processSystemQuery(Command command, DQPWorkContext workContext) throws TeiidComponentException {
        AbstractCollection rows;
        block45: {
            VDBMetaData vdb;
            block44: {
                String vdbName = workContext.getVdbName();
                int vdbVersion = workContext.getVdbVersion();
                vdb = workContext.getVDB();
                CompositeMetadataStore metadata = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
                rows = new ArrayList<List<Serializable>>();
                if (!(command instanceof Query)) break block44;
                Query query = (Query)command;
                UnaryFromClause ufc = (UnaryFromClause)query.getFrom().getClauses().get(0);
                GroupSymbol group = ufc.getGroup();
                SystemTables sysTable = SystemTables.valueOf(group.getNonCorrelationName().substring("SYS".length() + 1).toUpperCase());
                switch (sysTable) {
                    case DATATYPES: {
                        rows = new LinkedHashSet();
                        for (Datatype datatype : metadata.getDatatypes()) {
                            rows.add(Arrays.asList(datatype.getName(), datatype.isBuiltin(), datatype.isBuiltin(), datatype.getName(), datatype.getJavaClassName(), datatype.getScale(), datatype.getLength(), datatype.getNullType().toString(), datatype.isSigned(), datatype.isAutoIncrement(), datatype.isCaseSensitive(), datatype.getPrecisionLength(), datatype.getRadix(), datatype.getSearchType().toString(), datatype.getUUID(), datatype.getRuntimeTypeName(), datatype.getBasetypeName(), datatype.getAnnotation()));
                        }
                        break block45;
                    }
                    case VIRTUALDATABASES: {
                        rows.add(Arrays.asList(vdbName, vdbVersion));
                        break;
                    }
                    case SCHEMAS: {
                        for (Schema model : this.getVisibleSchemas(vdb, metadata)) {
                            rows.add(Arrays.asList(vdbName, model.getName(), model.isPhysical(), model.getUUID(), model.getAnnotation(), model.getPrimaryMetamodelUri()));
                        }
                        break block45;
                    }
                    case PROCEDURES: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), proc.getNameInSource(), proc.getResultSet() != null, proc.getUUID(), proc.getAnnotation()));
                            }
                        }
                        break block45;
                    }
                    case PROCEDUREPARAMS: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                for (ProcedureParameter param : proc.getParameters()) {
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), param.getDatatype().getRuntimeTypeName(), param.getPosition(), param.getType().toString(), param.isOptional(), param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation()));
                                }
                                if (proc.getResultSet() == null) continue;
                                for (ProcedureParameter param : proc.getResultSet().getColumns()) {
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), param.getDatatype().getRuntimeTypeName(), param.getPosition(), "ResultSet", false, param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation()));
                                }
                            }
                        }
                        break block45;
                    }
                    case PROPERTIES: {
                        LinkedHashSet<Object> records = new LinkedHashSet<Object>();
                        records.addAll(metadata.getDatatypes());
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            records.add(schema);
                            records.addAll(schema.getTables().values());
                            for (Table table : schema.getTables().values()) {
                                records.add(table);
                                records.addAll(table.getColumns());
                                records.addAll(table.getAllKeys());
                            }
                            for (Procedure proc : schema.getProcedures().values()) {
                                records.add(proc);
                                records.addAll(proc.getParameters());
                                if (proc.getResultSet() == null) continue;
                                records.addAll(proc.getResultSet().getColumns());
                            }
                        }
                        for (AbstractMetadataRecord abstractMetadataRecord : records) {
                            for (Map.Entry entry : abstractMetadataRecord.getProperties().entrySet()) {
                                rows.add(Arrays.asList((String)entry.getKey(), (String)entry.getValue(), abstractMetadataRecord.getUUID()));
                            }
                        }
                        break block45;
                    }
                    default: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            block35: for (Table table : schema.getTables().values()) {
                                switch (sysTable) {
                                    case TABLES: {
                                        rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), table.getTableType().toString(), table.getNameInSource(), table.isPhysical(), table.supportsUpdate(), table.getUUID(), table.getCardinality(), table.getAnnotation(), table.isSystem(), table.isMaterialized()));
                                        break;
                                    }
                                    case COLUMNS: {
                                        for (Column column : table.getColumns()) {
                                            if (column.getDatatype() == null) continue;
                                            rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), column.getPosition(), column.getNameInSource(), column.getDatatype().getRuntimeTypeName(), column.getScale(), column.getLength(), column.isFixedLength(), column.isSelectable(), column.isUpdatable(), column.isCaseSensitive(), column.isSigned(), column.isCurrency(), column.isAutoIncremented(), column.getNullType().toString(), column.getMinimumValue(), column.getMaximumValue(), column.getSearchType().toString(), column.getFormat(), column.getDefaultValue(), column.getDatatype().getJavaClassName(), column.getPrecision(), column.getCharOctetLength(), column.getRadix(), column.getUUID(), column.getAnnotation()));
                                        }
                                        continue block35;
                                    }
                                    case KEYS: {
                                        for (KeyRecord key : table.getAllKeys()) {
                                            rows.add(Arrays.asList(vdbName, ((Schema)table.getParent()).getName(), table.getName(), key.getName(), key.getAnnotation(), key.getNameInSource(), key.getType().toString(), false, key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID()));
                                        }
                                        continue block35;
                                    }
                                    case KEYCOLUMNS: {
                                        short postition;
                                        for (KeyRecord key : table.getAllKeys()) {
                                            postition = 1;
                                            for (Column column : key.getColumns()) {
                                                rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), key.getName(), key.getType().toString(), key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID(), Integer.valueOf(postition++)));
                                            }
                                        }
                                        continue block35;
                                    }
                                    case REFERENCEKEYCOLUMNS: {
                                        short postition;
                                        for (KeyRecord key : table.getForeignKeys()) {
                                            postition = 0;
                                            for (Column column : key.getColumns()) {
                                                Table pkTable = (Table)key.getPrimaryKey().getParent();
                                                Serializable[] serializableArray = new Serializable[14];
                                                serializableArray[0] = vdbName;
                                                serializableArray[1] = ((Schema)pkTable.getParent()).getName();
                                                serializableArray[2] = pkTable.getName();
                                                serializableArray[3] = ((Column)key.getPrimaryKey().getColumns().get(postition)).getName();
                                                serializableArray[4] = vdbName;
                                                serializableArray[5] = schema.getName();
                                                serializableArray[6] = table.getName();
                                                serializableArray[7] = column.getName();
                                                postition = (short)(postition + 1);
                                                serializableArray[8] = Short.valueOf(postition);
                                                serializableArray[9] = Integer.valueOf(3);
                                                serializableArray[10] = Integer.valueOf(3);
                                                serializableArray[11] = key.getName();
                                                serializableArray[12] = key.getPrimaryKey().getName();
                                                serializableArray[13] = Integer.valueOf(5);
                                                rows.add(Arrays.asList(serializableArray));
                                            }
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        break block45;
                    }
                }
                break block45;
            }
            TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
            StoredProcedure proc = (StoredProcedure)command;
            SystemProcs sysTable = SystemProcs.valueOf(proc.getProcedureCallableName().substring("SYS".length() + 1).toUpperCase());
            switch (sysTable) {
                case GETVDBRESOURCEPATHS: {
                    void var14_39;
                    String[] filePaths;
                    String[] arr$ = filePaths = indexMetadata.getVDBResourcePaths();
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var14_39 < len$) {
                        String filePath = arr$[var14_39];
                        rows.add(Arrays.asList(filePath, filePath.endsWith(".INDEX")));
                        ++var14_39;
                    }
                    break;
                }
                case GETBINARYVDBRESOURCE: {
                    String filePath = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    BlobImpl contents = indexMetadata.getVDBResourceAsBlob(filePath);
                    if (contents == null) break;
                    rows.add(Arrays.asList(new BlobType((Blob)contents)));
                    break;
                }
                case GETCHARACTERVDBRESOURCE: {
                    String filePath = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    ClobImpl clobImpl = indexMetadata.getVDBResourceAsClob(filePath);
                    if (clobImpl == null) break;
                    rows.add(Arrays.asList(new ClobType((Clob)clobImpl)));
                    break;
                }
                case GETXMLSCHEMAS: {
                    Object groupID = indexMetadata.getGroupID((String)((Constant)proc.getParameter(1).getExpression()).getValue());
                    List<SQLXMLImpl> schemas = indexMetadata.getXMLSchemas(groupID);
                    for (SQLXMLImpl schema : schemas) {
                        rows.add(Arrays.asList(new XMLType((SQLXML)schema)));
                    }
                    break;
                }
            }
        }
        return new CollectionTupleSource(rows.iterator(), command.getProjectedSymbols());
    }

    private List<Schema> getVisibleSchemas(VDBMetaData vdb, CompositeMetadataStore metadata) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Schema schema : metadata.getSchemas().values()) {
            ModelMetaData model = vdb.getModel(schema.getName());
            if (!model.isVisible()) continue;
            result.add(schema);
        }
        return result;
    }

    private AtomicRequestMessage createRequest(Object processorId, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidProcessingException, TeiidComponentException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)processorId);
        RequestMessage request = workItem.requestMsg;
        AtomicRequestMessage aqr = new AtomicRequestMessage(request, workItem.getDqpWorkContext(), nodeID);
        aqr.setCommand(command);
        aqr.setModelName(modelName);
        aqr.setMaxResultRows(this.requestMgr.getMaxSourceRows());
        aqr.setExceptionOnMaxRows(this.requestMgr.isExceptionOnMaxSourceRows());
        aqr.setPartialResults(request.supportsPartialResults());
        if (nodeID >= 0) {
            aqr.setTransactionContext(workItem.getTransactionContext());
        }
        aqr.setFetchSize(this.bufferService.getBufferManager().getConnectorBatchSize());
        if (connectorBindingId == null) {
            VDBMetaData vdb = workItem.getDqpWorkContext().getVDB();
            ModelMetaData model = vdb.getModel(modelName);
            List bindings = model.getSourceNames();
            if (bindings == null || bindings.size() != 1) {
                throw new TeiidComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_binding", new Object[]{modelName, workItem.getDqpWorkContext().getVdbName(), workItem.getDqpWorkContext().getVdbVersion()}));
            }
            connectorBindingId = (String)bindings.get(0);
            Assertion.isNotNull((Object)connectorBindingId, (String)"could not obtain connector id");
        }
        aqr.setConnectorName(connectorBindingId);
        return aqr;
    }

    ConnectorWork executeRequest(AtomicRequestMessage aqr, AbstractWorkItem awi, String connectorName) throws TranslatorException {
        return this.getCM(connectorName).executeRequest(aqr, awi);
    }

    private void notifyWaitingCodeTableRequests(Collection requests) {
        if (requests != null) {
            Iterator reqIter = requests.iterator();
            while (reqIter.hasNext()) {
                RequestWorkItem workItem = this.requestMgr.safeGetWorkItem(reqIter.next());
                if (workItem == null) continue;
                workItem.moreWork();
            }
        }
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        switch (this.codeTableCache.cacheExists(codeTableName, returnElementName, keyElementName, context)) {
            case CACHE_NOT_EXIST: {
                this.registerCodeTableRequest(context, codeTableName, returnElementName, keyElementName);
            }
            case CACHE_EXISTS: {
                return this.codeTableCache.lookupValue(codeTableName, returnElementName, keyElementName, keyValue, context);
            }
            case CACHE_OVERLOAD: {
                throw new TeiidProcessingException("ERR.018.005.0100", DQPPlugin.Util.getString("ERR.018.005.0100", new Object[]{"maxCodeTables"}));
            }
        }
        throw BlockedException.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCodeTableRequest(CommandContext context, String codeTableName, String returnElementName, String keyElementName) throws TeiidComponentException, TeiidProcessingException {
        String query = "SELECT " + keyElementName + " ," + returnElementName + ' ' + "FROM" + ' ' + codeTableName;
        CodeTableCache.CacheKey codeRequestId = this.codeTableCache.createCacheRequest(codeTableName, returnElementName, keyElementName, context);
        boolean success = false;
        try {
            TupleBatch batch;
            QueryProcessor processor = context.getQueryProcessorFactory().createQueryProcessor(query, codeTableName.toUpperCase(), context);
            processor.setNonBlocking(true);
            do {
                batch = processor.nextBatch();
                this.codeTableCache.loadTable(codeRequestId, batch.getAllTuples());
            } while (!batch.getTerminationFlag());
            success = true;
        }
        finally {
            Set<Object> requests = this.codeTableCache.markCacheDone(codeRequestId, success);
            this.notifyWaitingCodeTableRequests(requests);
        }
    }

    @Override
    public void clearCodeTables() {
        this.codeTableCache.clearAll();
    }

    private static enum SystemProcs {
        GETCHARACTERVDBRESOURCE,
        GETBINARYVDBRESOURCE,
        GETVDBRESOURCEPATHS,
        GETXMLSCHEMAS;

    }

    private static enum SystemTables {
        VIRTUALDATABASES,
        SCHEMAS,
        TABLES,
        DATATYPES,
        COLUMNS,
        KEYS,
        PROCEDURES,
        KEYCOLUMNS,
        PROCEDUREPARAMS,
        REFERENCEKEYCOLUMNS,
        PROPERTIES;

    }
}

