/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.List;
import org.teiid.client.SourceWarning;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.impl.ConnectorWork;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.translator.TranslatorException;

public class DataTierTupleSource
implements TupleSource {
    private final List schema;
    private final AtomicRequestMessage aqr;
    private final DataTierManagerImpl dataMgr;
    private final String connectorName;
    private final RequestWorkItem workItem;
    private ConnectorWork cwi;
    private int index;
    private int rowsProcessed;
    private volatile AtomicResultsMessage arm;
    private boolean closed;
    private volatile boolean canceled;
    private volatile boolean running;

    public DataTierTupleSource(List schema, AtomicRequestMessage aqr, DataTierManagerImpl dataMgr, String connectorName, RequestWorkItem workItem) {
        this.schema = schema;
        this.aqr = aqr;
        this.dataMgr = dataMgr;
        this.connectorName = connectorName;
        this.workItem = workItem;
    }

    public List getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nextTuple() throws TeiidComponentException, TeiidProcessingException {
        if (this.arm == null) {
            this.open();
        }
        while (this.index >= this.arm.getResults().length) {
            if (this.isDone()) {
                return null;
            }
            try {
                this.running = true;
                this.receiveResults(this.cwi.more());
                continue;
            }
            catch (TranslatorException e) {
                this.exceptionOccurred(e, true);
                continue;
            }
            finally {
                this.running = false;
                continue;
            }
            break;
        }
        return this.arm.getResults()[this.index++];
    }

    public boolean isQueued() {
        return this.cwi != null && this.cwi.isQueued();
    }

    public boolean isDone() {
        return this.arm != null && this.arm.getFinalRow() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws TeiidComponentException, TeiidProcessingException {
        try {
            if (this.cwi == null) {
                this.cwi = this.dataMgr.executeRequest(this.aqr, this.workItem, this.connectorName);
                Assertion.isNull((Object)this.workItem.getConnectorRequest(this.aqr.getAtomicRequestID()));
                this.workItem.addConnectorRequest(this.aqr.getAtomicRequestID(), this);
            }
            this.running = true;
            this.receiveResults(this.cwi.execute());
        }
        catch (TranslatorException e) {
            this.exceptionOccurred(e, true);
        }
        finally {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void fullyCloseSource() {
        if (!this.closed) {
            if (this.cwi != null) {
                this.workItem.closeAtomicRequest(this.aqr.getAtomicRequestID());
                this.cwi.close();
            }
            this.closed = true;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancelRequest() {
        this.canceled = true;
        if (this.cwi != null) {
            this.cwi.cancel();
        }
    }

    @Override
    public void closeSource() {
        if (this.arm == null || this.arm.supportsImplicitClose()) {
            this.fullyCloseSource();
        }
    }

    void exceptionOccurred(TranslatorException exception, boolean removeState) throws TeiidComponentException, TeiidProcessingException {
        if (removeState) {
            this.fullyCloseSource();
        }
        if (!this.workItem.requestMsg.supportsPartialResults()) {
            if (exception.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)exception.getCause();
            }
            if (exception.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)exception.getCause();
            }
            throw new TeiidProcessingException((Throwable)exception);
        }
        AtomicResultsMessage emptyResults = new AtomicResultsMessage(new List[0], null);
        emptyResults.setWarnings(Arrays.asList(new Exception[]{exception}));
        emptyResults.setFinalRow(this.rowsProcessed);
        this.receiveResults(this.arm);
    }

    void receiveResults(AtomicResultsMessage response) {
        this.arm = response;
        this.rowsProcessed += response.getResults().length;
        this.index = 0;
        if (response.getWarnings() != null) {
            for (Exception warning : response.getWarnings()) {
                SourceWarning sourceFailure = new SourceWarning(this.aqr.getModelName(), this.aqr.getConnectorName(), (Throwable)warning, true);
                this.workItem.addSourceFailureDetails(sourceFailure);
            }
        }
    }

    public AtomicRequestMessage getAtomicRequestMessage() {
        return this.aqr;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public boolean isTransactional() {
        if (this.arm == null) {
            return false;
        }
        return this.arm.isTransactional();
    }

    @Override
    public int available() {
        if (this.arm == null) {
            return 0;
        }
        return this.arm.getResults().length - this.index;
    }
}

