/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.LRUCache;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.parser.ParseInfo;
import org.teiid.vdb.runtime.VDBKey;

public class SessionAwareCache<T> {
    public static final int DEFAULT_MAX_SIZE_TOTAL = 250;
    private Map<CacheID, T> cache;
    private int maxSize;
    private AtomicInteger cacheHit = new AtomicInteger();

    SessionAwareCache() {
        this(250);
    }

    SessionAwareCache(int maxSize) {
        if (maxSize < 0) {
            maxSize = 250;
        }
        this.maxSize = maxSize;
        this.cache = Collections.synchronizedMap(new LRUCache(maxSize));
    }

    public T get(CacheID id) {
        id.setSessionId(id.originalSessionId);
        T result = this.cache.get(id);
        if (result == null) {
            id.setSessionId(null);
            result = this.cache.get(id);
        }
        if (result != null) {
            this.cacheHit.getAndIncrement();
        }
        return result;
    }

    public int getCacheHitCount() {
        return this.cacheHit.get();
    }

    public void put(CacheID id, boolean sessionSpecific, T t) {
        if (sessionSpecific) {
            id.setSessionId(id.originalSessionId);
        } else {
            id.setSessionId(null);
        }
        this.cache.put(id, t);
    }

    public void clearAll() {
        this.cache.clear();
    }

    int getSpaceUsed() {
        return this.cache.size();
    }

    int getSpaceAllowed() {
        return this.maxSize;
    }

    static class CacheID {
        private String sql;
        private VDBKey vdbInfo;
        private ParseInfo pi;
        private String sessionId;
        private String originalSessionId;
        private List<?> parameters;

        CacheID(DQPWorkContext context, ParseInfo pi, String sql) {
            this.sql = sql;
            this.vdbInfo = new VDBKey(context.getVdbName(), context.getVdbVersion());
            this.pi = pi;
            this.originalSessionId = context.getSessionId();
        }

        private void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void setParameters(List<?> parameters) {
            this.parameters = parameters;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return this.pi.equals(that.pi) && this.vdbInfo.equals(that.vdbInfo) && this.sql.equals(that.sql) && EquivalenceUtil.areEqual((Object)this.sessionId, (Object)that.sessionId) && EquivalenceUtil.areEqual(this.parameters, that.parameters);
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.vdbInfo, this.sql, this.pi, this.sessionId, this.parameters});
        }

        public String toString() {
            return "Cache Entry<" + this.originalSessionId + "> params:" + this.parameters + " sql:" + this.sql;
        }
    }
}

