/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class StatsCapturingWorkManager {
    private static ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Scheduler"));
    private volatile int activeCount;
    private volatile int highestActiveCount;
    private volatile int highestQueueSize;
    private volatile boolean terminated;
    private volatile int submittedCount;
    private volatile int completedCount;
    private Object poolLock = new Object();
    private AtomicInteger threadCounter = new AtomicInteger();
    private String poolName;
    private int maximumPoolSize;
    private WorkManager delegate;
    private Queue<WorkWrapper> queue = new LinkedList<WorkWrapper>();
    private Set<Thread> threads = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private Map<Integer, ScheduledFuture<?>> futures = new HashMap();
    private int idCounter;

    private static void handleException(Work work, WorkException e) {
        if (work instanceof WorkListener) {
            ((WorkListener)work).workRejected(new WorkEvent((Object)work, 2, work, (WorkException)new WorkRejectedException((Throwable)e)));
        } else if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)5)) {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Throwable)e, (Object[])new Object[]{"Exception adding work to the WorkManager"});
        }
    }

    public StatsCapturingWorkManager(String name, int maximumPoolSize, WorkManager delegate) {
        this.maximumPoolSize = maximumPoolSize;
        this.poolName = name;
        this.delegate = delegate;
    }

    public void scheduleWork(Work arg0) throws WorkException {
        this.scheduleWork(arg0, (WorkContext)null, DQPWorkContext.getWorkContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWork(Work work, WorkContext workContext, DQPWorkContext dqpWorkContext) throws WorkRejectedException, WorkException {
        boolean atMaxThreads = false;
        boolean newMaxQueueSize = false;
        Object object = this.poolLock;
        synchronized (object) {
            this.checkForTermination();
            ++this.submittedCount;
            boolean bl = atMaxThreads = this.activeCount == this.maximumPoolSize;
            if (atMaxThreads) {
                this.queue.add(new WorkWrapper(work, workContext, dqpWorkContext));
                int queueSize = this.queue.size();
                if (queueSize > this.highestQueueSize) {
                    newMaxQueueSize = true;
                    this.highestQueueSize = queueSize;
                }
            } else {
                ++this.activeCount;
                this.highestActiveCount = Math.max(this.activeCount, this.highestActiveCount);
            }
        }
        if (atMaxThreads) {
            if (newMaxQueueSize && this.maximumPoolSize > 1) {
                LogManager.logWarning((String)"org.teiid.RUNTIME", (String)QueryPlugin.Util.getString("WorkerPool.Max_thread", new Object[]{this.maximumPoolSize, this.poolName, this.highestQueueSize}));
            }
            return;
        }
        if (workContext == null) {
            this.delegate.scheduleWork((Work)new WorkWrapper(work, null, dqpWorkContext));
        } else {
            this.delegate.scheduleWork((Work)new WorkWrapper(work, null, dqpWorkContext), workContext.getStartTimeout(), workContext.context, work instanceof WorkListener ? (WorkListener)work : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(final Work arg0, final ExecutionContext arg2, long delay) throws WorkException {
        if (delay < 1L) {
            this.scheduleWork(arg0, new WorkContext(arg2, Long.MAX_VALUE), DQPWorkContext.getWorkContext());
        } else {
            Map<Integer, ScheduledFuture<?>> map = this.futures;
            synchronized (map) {
                final int id = this.idCounter++;
                final DQPWorkContext dqpWorkContext = DQPWorkContext.getWorkContext();
                ScheduledFuture<?> sf = stpe.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StatsCapturingWorkManager.this.futures.remove(id);
                            StatsCapturingWorkManager.this.scheduleWork(arg0, new WorkContext(arg2, Long.MAX_VALUE), dqpWorkContext);
                        }
                        catch (WorkException e) {
                            StatsCapturingWorkManager.handleException(arg0, e);
                        }
                    }
                }, delay, TimeUnit.MILLISECONDS);
                this.futures.put(id, sf);
            }
        }
    }

    private void checkForTermination() throws WorkRejectedException {
        if (this.terminated) {
            throw new WorkRejectedException("Queue has been terminated");
        }
    }

    public WorkerPoolStatisticsMetadata getStats() {
        WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
        stats.setName(this.poolName);
        stats.setQueued(this.queue.size());
        stats.setHighestQueued(this.highestQueueSize);
        stats.setActiveThreads(this.activeCount);
        stats.setMaxThreads(this.maximumPoolSize);
        stats.setTotalSubmitted((long)this.submittedCount);
        stats.setHighestActiveThreads(this.highestActiveCount);
        stats.setTotalCompleted((long)this.completedCount);
        return stats;
    }

    public void shutdown() {
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.shutdown();
        Map<Integer, ScheduledFuture<?>> map = this.poolLock;
        synchronized (map) {
            for (Thread thread : this.threads) {
                thread.interrupt();
            }
            this.queue.clear();
        }
        map = this.futures;
        synchronized (map) {
            for (ScheduledFuture scheduledFuture : this.futures.values()) {
                scheduledFuture.cancel(true);
            }
            this.futures.clear();
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMillis = unit.toMillis(timeout);
        long finalMillis = System.currentTimeMillis() + timeoutMillis;
        Object object = this.poolLock;
        synchronized (object) {
            while (this.activeCount > 0 || !this.terminated) {
                if (timeoutMillis < 1L) {
                    return false;
                }
                this.poolLock.wait(timeoutMillis);
                timeoutMillis = finalMillis - System.currentTimeMillis();
            }
        }
        return true;
    }

    private final class WorkWrapper
    implements Work {
        private final Work work;
        private final WorkContext workContext;
        private final DQPWorkContext dqpWorkContext;

        private WorkWrapper(Work work, WorkContext workContext, DQPWorkContext dqpWorkContext) {
            this.work = work;
            this.workContext = workContext;
            this.dqpWorkContext = dqpWorkContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread t = Thread.currentThread();
            Object object = StatsCapturingWorkManager.this.poolLock;
            synchronized (object) {
                StatsCapturingWorkManager.this.threads.add(t);
            }
            String name = t.getName();
            t.setName(name + "_" + StatsCapturingWorkManager.this.poolName + StatsCapturingWorkManager.this.threadCounter.getAndIncrement());
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Beginning work with virtual worker", t.getName()});
            }
            boolean success = false;
            try {
                this.dqpWorkContext.runInContext((Runnable)this.work);
                success = true;
            }
            catch (Throwable throwable) {
                Object object2 = StatsCapturingWorkManager.this.poolLock;
                synchronized (object2) {
                    WorkWrapper next = null;
                    if (success) {
                        StatsCapturingWorkManager.this.completedCount++;
                        next = (WorkWrapper)StatsCapturingWorkManager.this.queue.poll();
                    }
                    StatsCapturingWorkManager.this.threads.remove(t);
                    if (next == null) {
                        StatsCapturingWorkManager.this.activeCount--;
                        if (StatsCapturingWorkManager.this.activeCount == 0 && StatsCapturingWorkManager.this.terminated) {
                            StatsCapturingWorkManager.this.poolLock.notifyAll();
                        }
                    } else {
                        try {
                            if (next.workContext == null) {
                                StatsCapturingWorkManager.this.delegate.scheduleWork((Work)next);
                            } else {
                                StatsCapturingWorkManager.this.delegate.scheduleWork((Work)next, next.workContext.getStartTimeout(), next.workContext.context, next.work instanceof WorkListener ? (WorkListener)next.work : null);
                            }
                        }
                        catch (WorkException e) {
                            StatsCapturingWorkManager.handleException(next.work, e);
                        }
                    }
                }
                t.setName(name);
                throw throwable;
            }
            Object object3 = StatsCapturingWorkManager.this.poolLock;
            synchronized (object3) {
                WorkWrapper next = null;
                if (success) {
                    StatsCapturingWorkManager.this.completedCount++;
                    next = (WorkWrapper)StatsCapturingWorkManager.this.queue.poll();
                }
                StatsCapturingWorkManager.this.threads.remove(t);
                if (next == null) {
                    StatsCapturingWorkManager.this.activeCount--;
                    if (StatsCapturingWorkManager.this.activeCount == 0 && StatsCapturingWorkManager.this.terminated) {
                        StatsCapturingWorkManager.this.poolLock.notifyAll();
                    }
                } else {
                    try {
                        if (next.workContext == null) {
                            StatsCapturingWorkManager.this.delegate.scheduleWork((Work)next);
                        } else {
                            StatsCapturingWorkManager.this.delegate.scheduleWork((Work)next, next.workContext.getStartTimeout(), next.workContext.context, next.work instanceof WorkListener ? (WorkListener)next.work : null);
                        }
                    }
                    catch (WorkException e) {
                        StatsCapturingWorkManager.handleException(next.work, e);
                    }
                }
            }
            t.setName(name);
        }

        public void release() {
            this.work.release();
        }
    }

    private static class WorkContext {
        ExecutionContext context;
        long startTimeout;
        long submitted = System.currentTimeMillis();

        public WorkContext(ExecutionContext context, long startTimeout) {
            this.context = context;
            this.startTimeout = startTimeout;
        }

        long getStartTimeout() {
            if (this.startTimeout == 0L) {
                return 0L;
            }
            return Math.max(1L, this.startTimeout + this.submitted - System.currentTimeMillis());
        }
    }
}

