/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.util.CommandContext;

public class MultiSourcePlanToProcessConverter
extends PlanToProcessConverter {
    private Set<String> multiSourceModels;
    private DQPWorkContext workContext;

    public MultiSourcePlanToProcessConverter(QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder, Set<String> multiSourceModels, DQPWorkContext workContext, CommandContext context) {
        super(metadata, idGenerator, analysisRecord, capFinder);
        this.multiSourceModels = multiSourceModels;
        this.workContext = workContext;
    }

    @Override
    protected RelationalNode convertNode(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalNode node = super.convertNode(planNode);
        if (node instanceof AccessNode) {
            try {
                return this.multiSourceModify((AccessNode)node);
            }
            catch (TeiidProcessingException e) {
                throw new QueryPlannerException(e, e.getMessage());
            }
        }
        return node;
    }

    private RelationalNode multiSourceModify(AccessNode accessNode) throws TeiidComponentException, TeiidProcessingException {
        String modelName = accessNode.getModelName();
        if (!this.multiSourceModels.contains(modelName)) {
            return accessNode;
        }
        VDBMetaData vdb = this.workContext.getVDB();
        ModelMetaData model = vdb.getModel(modelName);
        ArrayList<AccessNode> accessNodes = new ArrayList<AccessNode>();
        for (String sourceName : model.getSourceNames()) {
            AccessNode instanceNode = (AccessNode)accessNode.clone();
            instanceNode.setID(this.getID());
            instanceNode.setConnectorBindingId(sourceName);
            Command command = (Command)instanceNode.getCommand().clone();
            DeepPreOrderNavigator.doVisit(command, new MultiSourceElementReplacementVisitor(sourceName));
            try {
                command = QueryRewriter.rewrite(command, this.metadata, null);
                instanceNode.setCommand(command);
            }
            catch (QueryValidatorException e) {
                // empty catch block
            }
            if (!RelationalNodeUtil.shouldExecute(command, false)) continue;
            accessNodes.add(instanceNode);
        }
        switch (accessNodes.size()) {
            case 0: {
                NullNode nullNode = new NullNode(this.getID());
                nullNode.setElements(accessNode.getElements());
                return nullNode;
            }
            case 1: {
                AccessNode newNode = (AccessNode)accessNodes.get(0);
                return newNode;
            }
        }
        UnionAllNode unionNode = new UnionAllNode(this.getID());
        unionNode.setElements(accessNode.getElements());
        UnionAllNode parent = unionNode;
        for (AccessNode newNode : accessNodes) {
            unionNode.addChild(newNode);
        }
        return parent;
    }
}

