/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TransformationMetadata;

public class CompositeMetadataStore
extends MetadataStore {
    public CompositeMetadataStore(MetadataStore metadataStore) {
        this.addMetadataStore(metadataStore);
    }

    public CompositeMetadataStore(List<MetadataStore> metadataStores) {
        for (MetadataStore metadataStore : metadataStores) {
            this.addMetadataStore(metadataStore);
        }
    }

    public void addMetadataStore(MetadataStore metadataStore) {
        this.schemas.putAll(metadataStore.getSchemas());
        this.datatypes.addAll(metadataStore.getDatatypes());
    }

    public Schema getSchema(String fullName) throws QueryMetadataException {
        Schema result = (Schema)this.getSchemas().get(fullName);
        if (result == null) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Table findGroup(String fullName) throws QueryMetadataException {
        int index = fullName.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index == -1) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        String schema = fullName.substring(0, index);
        Table result = (Table)this.getSchema(schema).getTables().get(fullName.substring(index + 1));
        if (result == null) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Collection<Table> getGroupsForPartialName(String partialGroupName) {
        LinkedList<Table> result = new LinkedList<Table>();
        for (Schema schema : this.getSchemas().values()) {
            for (Table t : schema.getTables().values()) {
                String fullName = t.getFullName();
                if (!fullName.regionMatches(true, fullName.length() - partialGroupName.length(), partialGroupName, 0, partialGroupName.length())) continue;
                result.add(t);
            }
        }
        return result;
    }

    public Collection<Procedure> getStoredProcedure(String name) throws TeiidComponentException, QueryMetadataException {
        String schema;
        Procedure proc;
        LinkedList<Procedure> result = new LinkedList<Procedure>();
        int index = name.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index > -1 && (proc = (Procedure)this.getSchema(schema = name.substring(0, index)).getProcedures().get(name.substring(index + 1))) != null) {
            result.add(proc);
            return result;
        }
        name = TransformationMetadata.DELIMITER_STRING + name;
        for (Schema schema2 : this.getSchemas().values()) {
            for (Procedure p : schema2.getProcedures().values()) {
                String fullName = p.getFullName();
                if (!fullName.regionMatches(true, fullName.length() - name.length(), name, 0, name.length())) continue;
                result.add(p);
            }
        }
        if (result.isEmpty()) {
            throw new QueryMetadataException(name.substring(1) + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Collection<Table> getXMLTempGroups(Table tableRecord) {
        ArrayList<Table> results = new ArrayList<Table>();
        String namePrefix = tableRecord.getFullName() + TransformationMetadata.DELIMITER_STRING;
        for (Table table : ((Schema)tableRecord.getParent()).getTables().values()) {
            if (table.getTableType() != Table.Type.XmlStagingTable || !table.getName().startsWith(namePrefix)) continue;
            results.add(table);
        }
        return results;
    }
}

