/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.CharsetUtils;
import org.teiid.query.util.CommandContext;

public final class FunctionMethods {
    private static final double log10baseE = Math.log(10.0);
    static final String[] dayNames = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final char SPACE = ' ';
    public static final String SPACE_CHAR = " ";

    public static int plus(int x, int y) {
        return x + y;
    }

    public static long plus(long x, long y) {
        return x + y;
    }

    public static float plus(float x, float y) {
        return x + y;
    }

    public static double plus(double x, double y) {
        return x + y;
    }

    public static Object plus(BigInteger x, BigInteger y) {
        return x.add(y);
    }

    public static Object plus(BigDecimal x, BigDecimal y) {
        return x.add(y);
    }

    public static int minus(int x, int y) {
        return x - y;
    }

    public static long minus(long x, long y) {
        return x - y;
    }

    public static float minus(float x, float y) {
        return x - y;
    }

    public static double minus(double x, double y) {
        return x - y;
    }

    public static Object minus(BigInteger x, BigInteger y) {
        return x.subtract(y);
    }

    public static Object minus(BigDecimal x, BigDecimal y) {
        return x.subtract(y);
    }

    public static int multiply(int x, int y) {
        return x * y;
    }

    public static long multiply(long x, long y) {
        return x * y;
    }

    public static float multiply(float x, float y) {
        return x * y;
    }

    public static double multiply(double x, double y) {
        return x * y;
    }

    public static Object multiply(BigInteger x, BigInteger y) {
        return x.multiply(y);
    }

    public static Object multiply(BigDecimal x, BigDecimal y) {
        return x.multiply(y);
    }

    public static int divide(int x, int y) {
        return x / y;
    }

    public static long divide(long x, long y) {
        return x / y;
    }

    public static float divide(float x, float y) {
        return x / y;
    }

    public static double divide(double x, double y) {
        return x / y;
    }

    public static Object divide(BigInteger x, BigInteger y) {
        return x.divide(y);
    }

    public static Object divide(BigDecimal x, BigDecimal y) {
        BigDecimal bd = x.divide(y, Math.max(16, x.scale() + y.precision() + 1), RoundingMode.HALF_UP).stripTrailingZeros();
        return bd.setScale(Math.max(x.scale(), bd.scale()));
    }

    public static int abs(int x) {
        return Math.abs(x);
    }

    public static long abs(long x) {
        return Math.abs(x);
    }

    public static float abs(float x) {
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static Object abs(BigInteger x) {
        return x.abs();
    }

    public static Object abs(BigDecimal x) {
        return x.abs();
    }

    public static Object ceiling(Number x) {
        return new Double(Math.ceil(x.doubleValue()));
    }

    public static Object exp(Number x) {
        return new Double(Math.exp(x.doubleValue()));
    }

    public static Object floor(Number x) {
        return new Double(Math.floor(x.doubleValue()));
    }

    public static Object log(Number x) {
        return new Double(Math.log(x.doubleValue()));
    }

    public static Object log10(Number x) {
        return new Double(Math.log(x.doubleValue()) / log10baseE);
    }

    public static Object rand(CommandContext context, Object seed) throws FunctionExecutionException {
        if (context != null) {
            if (seed == null) {
                return new Double(context.getNextRand());
            }
            if (seed instanceof Integer) {
                return new Double(context.getNextRand(((Integer)seed).longValue()));
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0069", QueryPlugin.Util.getString("ERR.015.001.0069", new Object[]{"rand", seed}));
    }

    public static Object rand(CommandContext context) throws FunctionExecutionException {
        if (context != null) {
            return new Double(context.getNextRand());
        }
        throw new FunctionExecutionException("ERR.015.001.0069", QueryPlugin.Util.getString("ERR.015.001.0069", new Object[]{"rand"}));
    }

    public static int mod(int x, int y) {
        return x % y;
    }

    public static long mod(long x, long y) {
        return x % y;
    }

    public static float mod(float x, float y) {
        return x % y;
    }

    public static double mod(double x, double y) {
        return x % y;
    }

    public static Object mod(BigInteger x, BigInteger y) {
        return x.remainder(y);
    }

    public static Object mod(BigDecimal x, BigDecimal y) {
        return x.remainder(y);
    }

    public static double power(double x, double y) {
        return Math.pow(x, y);
    }

    public static BigInteger power(BigInteger x, int y) {
        return x.pow(y);
    }

    public static BigDecimal power(BigDecimal x, int y) {
        return x.pow(y);
    }

    public static int round(int number, int places) {
        if (places < 0) {
            return FunctionMethods.round(new BigDecimal(number), places).intValue();
        }
        return number;
    }

    public static float round(float number, int places) {
        return FunctionMethods.round(new BigDecimal(number), places).floatValue();
    }

    public static double round(double number, int places) {
        return FunctionMethods.round(new BigDecimal(number), places).doubleValue();
    }

    public static BigDecimal round(BigDecimal bigDecimalNumber, int places) {
        int scale = bigDecimalNumber.scale();
        if (scale <= places) {
            return bigDecimalNumber;
        }
        bigDecimalNumber = bigDecimalNumber.setScale(places, 4);
        return bigDecimalNumber.setScale(scale, 4);
    }

    public static Object sign(int x) {
        return Integer.signum(x);
    }

    public static Object sign(long x) {
        return Long.signum(x);
    }

    public static Object sign(float x) {
        return Float.valueOf(Math.signum(x));
    }

    public static Object sign(double x) {
        return Math.signum(x);
    }

    public static Object sign(BigInteger x) {
        return new Integer(x.signum());
    }

    public static Object sign(BigDecimal x) {
        return new Integer(x.signum());
    }

    public static Object sqrt(Number x) {
        return new Double(Math.sqrt(x.doubleValue()));
    }

    public static Object currentDate() {
        return TimestampWithTimezone.createDate((java.util.Date)new java.util.Date());
    }

    public static Object currentTime() {
        return TimestampWithTimezone.createTime((java.util.Date)new java.util.Date());
    }

    public static Object currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static int getField(java.util.Date date, int field) {
        Calendar cal = TimestampWithTimezone.getCalendar();
        cal.setTime(date);
        return cal.get(field);
    }

    public static Object dayName(java.util.Date x) {
        return dayNames[FunctionMethods.getField(x, 7) - 1];
    }

    public static Object dayOfMonth(java.util.Date x) {
        return FunctionMethods.getField(x, 5);
    }

    public static Object dayOfWeek(java.util.Date x) {
        return FunctionMethods.getField(x, 7);
    }

    public static Object dayOfYear(java.util.Date x) {
        return FunctionMethods.getField(x, 6);
    }

    public static Object hour(java.util.Date x) {
        return FunctionMethods.getField(x, 11);
    }

    public static Object minute(java.util.Date x) {
        return FunctionMethods.getField(x, 12);
    }

    public static Object month(java.util.Date x) {
        return FunctionMethods.getField(x, 2) + 1;
    }

    public static Object monthName(java.util.Date x) {
        return monthNames[FunctionMethods.getField(x, 2)];
    }

    public static Object second(java.util.Date x) {
        return FunctionMethods.getField(x, 13);
    }

    public static Object week(java.util.Date x) {
        return FunctionMethods.getField(x, 3);
    }

    public static Object year(java.util.Date x) {
        return FunctionMethods.getField(x, 1);
    }

    public static Object quarter(java.util.Date date) throws FunctionExecutionException {
        int month = FunctionMethods.getField(date, 2);
        if (month > 11) {
            throw new FunctionExecutionException("ERR.015.001.0066", QueryPlugin.Util.getString("ERR.015.001.0066", new Object[]{"quarter", date.getClass().getName()}));
        }
        return month / 3 + 1;
    }

    public static Object timestampAdd(String intervalType, Integer count, Timestamp timestamp) {
        Calendar cal = TimestampWithTimezone.getCalendar();
        int nanos = timestamp.getNanos();
        cal.setTime(timestamp);
        if (intervalType.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            int countValue = count;
            if ((nanos += countValue) > 999999999) {
                int addSecond = nanos / 999999999;
                int leftNanos = nanos % 999999999;
                cal.add(13, addSecond);
                Timestamp ts = new Timestamp(cal.getTime().getTime());
                ts.setNanos(leftNanos);
                return ts;
            }
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            ts.setNanos(nanos);
            return ts;
        }
        FunctionMethods.addField(intervalType, count, cal);
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static void addField(String interval, Integer count, Calendar cal) {
        int countValue = count;
        if (!interval.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            if (interval.equalsIgnoreCase("SQL_TSI_SECOND")) {
                cal.add(13, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                cal.add(12, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_HOUR")) {
                cal.add(11, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_DAY")) {
                cal.add(6, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_WEEK")) {
                cal.add(3, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MONTH")) {
                cal.add(2, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                cal.add(2, countValue * 3);
            } else if (interval.equalsIgnoreCase("SQL_TSI_YEAR")) {
                cal.add(1, countValue);
            }
        }
    }

    public static Object timestampDiff(String intervalType, Timestamp ts1Obj, Timestamp ts2Obj) {
        long ts1 = ts1Obj.getTime() / 1000L * 1000000000L + (long)ts1Obj.getNanos();
        long ts2 = ts2Obj.getTime() / 1000L * 1000000000L + (long)ts2Obj.getNanos();
        long tsDiff = ts2 - ts1;
        long count = 0L;
        if (intervalType.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            count = tsDiff;
        } else {
            tsDiff /= 1000000L;
            if (intervalType.equalsIgnoreCase("SQL_TSI_SECOND")) {
                count = tsDiff / 1000L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                count = tsDiff / 1000L / 60L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_HOUR")) {
                count = tsDiff / 1000L / 3600L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_DAY")) {
                count = tsDiff / 1000L / 86400L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_WEEK")) {
                count = tsDiff / 1000L / 604800L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_MONTH")) {
                count = tsDiff / 1000L / 2592000L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                count = tsDiff / 1000L / 7862400L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_YEAR")) {
                count = tsDiff / 1000L / 31536000L;
            }
        }
        return new Long(count);
    }

    public static Object timestampCreate(Date date, Time time) {
        Calendar tsCal = TimestampWithTimezone.getCalendar();
        tsCal.setTime(time);
        int hour = tsCal.get(11);
        int minute = tsCal.get(12);
        int second = tsCal.get(13);
        tsCal.setTime(date);
        tsCal.set(11, hour);
        tsCal.set(12, minute);
        tsCal.set(13, second);
        return new Timestamp(tsCal.getTime().getTime());
    }

    public static Object length(String str) {
        return new Integer(str.length());
    }

    public static Object concat(String str1, String str2) {
        return str1 + str2;
    }

    public static Object substring(String string, Integer startVal, Integer lengthVal) {
        if (startVal < 0) {
            startVal = string.length() + startVal;
        } else if (startVal > 0) {
            Integer n = startVal;
            Integer n2 = startVal = Integer.valueOf(startVal - 1);
        }
        if (startVal < 0 || startVal >= string.length()) {
            return null;
        }
        if (lengthVal < 0) {
            return null;
        }
        int endVal = Math.min(startVal + lengthVal, string.length());
        return string.substring(startVal, endVal);
    }

    public static Object substring(String string, Integer start) {
        int startVal = start;
        return FunctionMethods.substring(string, startVal, string.length());
    }

    public static Object left(String string, Integer count) throws FunctionExecutionException {
        int countValue = count;
        if (countValue < 0) {
            throw new FunctionExecutionException("ERR.015.001.0017", QueryPlugin.Util.getString("ERR.015.001.0017", new Object[]{countValue}));
        }
        if (string.length() < countValue) {
            return string;
        }
        return string.substring(0, countValue);
    }

    public static Object right(String string, Integer count) throws FunctionExecutionException {
        int countValue = count;
        if (countValue < 0) {
            throw new FunctionExecutionException("ERR.015.001.0017", QueryPlugin.Util.getString("ERR.015.001.0017", new Object[]{countValue}));
        }
        if (string.length() < countValue) {
            return string;
        }
        return string.substring(string.length() - countValue);
    }

    public static Object lowerCase(String str) {
        return str.toLowerCase();
    }

    public static Object upperCase(String str) {
        return str.toUpperCase();
    }

    public static Object locate(String sub, String str) {
        return FunctionMethods.locate(sub, str, 1);
    }

    public static Object locate(String sub, String str, Integer start) {
        if (str == null || sub == null) {
            return null;
        }
        if (start == null) {
            start = 1;
        }
        return new Integer(str.indexOf(sub, start - 1) + 1);
    }

    public static Object leftTrim(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return string.substring(i);
        }
        return "";
    }

    public static Object rightTrim(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == ' ') continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static Object replace(String string, String subString, String replaceString) {
        if (subString.length() > string.length() || string.length() == 0 || subString.length() == 0) {
            return string;
        }
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (true) {
            int newIndex;
            if ((newIndex = string.indexOf(subString, index)) < 0) break;
            result.append(string.substring(index, newIndex));
            result.append(replaceString);
            index = newIndex + subString.length();
        }
        result.append(string.substring(index));
        return result.toString();
    }

    public static Object insert(String string1, Integer start, Integer length, String str2) throws FunctionExecutionException {
        int startValue = start;
        int len = length;
        if (startValue < 1 || startValue - 1 > string1.length()) {
            throw new FunctionExecutionException("ERR.015.001.0061", QueryPlugin.Util.getString("ERR.015.001.0061", new Object[]{start, string1}));
        }
        if (len < 0) {
            throw new FunctionExecutionException("ERR.015.001.0062", QueryPlugin.Util.getString("ERR.015.001.0062", new Object[]{len}));
        }
        if (string1.length() == 0 && (startValue > 1 || len > 0)) {
            throw new FunctionExecutionException("ERR.015.001.0063", QueryPlugin.Util.getString("ERR.015.001.0063"));
        }
        StringBuffer result = new StringBuffer();
        result.append(string1.substring(0, startValue - 1));
        int endValue = startValue + len - 1;
        if (endValue > string1.length()) {
            result.append(str2);
        } else {
            result.append(str2);
            result.append(string1.substring(endValue));
        }
        return result.toString();
    }

    public static Object repeat(String str, Integer count) {
        int repeatCount = count;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < repeatCount && result.length() <= 4000; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    public static Integer ascii(String ch) {
        if (ch.length() == 0) {
            return null;
        }
        return ch.charAt(0);
    }

    public static Integer ascii(Character ch) {
        return ch.charValue();
    }

    public static Object chr(int intValue) {
        return new Character((char)intValue);
    }

    public static Object initCap(String s) {
        StringBuffer cap = new StringBuffer();
        boolean checkCap = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (checkCap) {
                cap.append(Character.toUpperCase(c));
            } else {
                cap.append(Character.toLowerCase(c));
            }
            checkCap = Character.isWhitespace(c);
        }
        return cap.toString();
    }

    public static Object lpad(String inputString, Integer padLength, String padStr) throws FunctionExecutionException {
        return FunctionMethods.pad(inputString, padLength, padStr, true);
    }

    public static Object pad(String str, Integer padLength, String padStr, boolean left) throws FunctionExecutionException {
        int length = padLength;
        if (length < 1) {
            throw new FunctionExecutionException("ERR.015.001.0025", QueryPlugin.Util.getString("ERR.015.001.0025"));
        }
        if (length < str.length()) {
            return str.substring(0, length);
        }
        if (length > 4000) {
            length = 4000;
        }
        if (padStr.length() == 0) {
            throw new FunctionExecutionException("ERR.015.001.0027", QueryPlugin.Util.getString("ERR.015.001.0027"));
        }
        StringBuffer outStr = new StringBuffer(str);
        while (outStr.length() < length) {
            if (left) {
                outStr.insert(0, padStr);
                continue;
            }
            outStr.append(padStr);
        }
        if (left) {
            return outStr.substring(outStr.length() - length);
        }
        return outStr.substring(0, length);
    }

    public static Object lpad(String inputString, Integer padLength) throws FunctionExecutionException {
        return FunctionMethods.lpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object rpad(String inputString, Integer padLength, String padStr) throws FunctionExecutionException {
        return FunctionMethods.pad(inputString, padLength, padStr, false);
    }

    public static Object rpad(String inputString, Integer padLength) throws FunctionExecutionException {
        return FunctionMethods.rpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object translate(String str, String in, String out) throws FunctionExecutionException {
        if (in.length() != out.length()) {
            throw new FunctionExecutionException("ERR.015.001.0031", QueryPlugin.Util.getString("ERR.015.001.0031"));
        }
        if (in.length() == 0 || str.length() == 0) {
            return str;
        }
        StringBuffer translated = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean matched = false;
            for (int j = 0; j < in.length(); ++j) {
                char inChar = in.charAt(j);
                if (c != inChar) continue;
                translated.append(out.charAt(j));
                matched = true;
                break;
            }
            if (matched) continue;
            translated.append(c);
        }
        return translated.toString();
    }

    public static Object convert(Object src, String type) throws FunctionExecutionException {
        try {
            return DataTypeManager.transformValue((Object)src, (Class)DataTypeManager.getDataTypeClass((String)type));
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0033", QueryPlugin.Util.getString("ERR.015.001.0033", new Object[]{src, DataTypeManager.getDataTypeName(src.getClass()), type}));
        }
    }

    public static Object context(Object context, Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035", QueryPlugin.Util.getString("ERR.015.001.0035"));
    }

    public static Object rowlimit(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", QueryPlugin.Util.getString("ERR.015.001.0035a"));
    }

    public static Object rowlimitexception(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", QueryPlugin.Util.getString("ERR.015.001.0035a"));
    }

    public static Object lookup(Object codeTable, Object returnElement, Object keyElement, Object keyValue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public static Object ifnull(Object value, Object ifNullValue) {
        return FunctionMethods.coalesce(value, ifNullValue, new Object[0]);
    }

    public static Object coalesce(Object value, Object value1, Object ... other) {
        if (value != null) {
            return value;
        }
        if (value1 != null) {
            return value1;
        }
        for (Object object : other) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static String format(java.util.Date date, String format) throws FunctionExecutionException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", new Object[]{iae.getMessage()}));
        }
    }

    private static java.util.Date parseDateHelper(String date, String format) throws FunctionExecutionException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", new Object[]{date, format}));
        }
    }

    public static Timestamp parseTimestamp(String timestamp, String format) throws FunctionExecutionException {
        return new Timestamp(FunctionMethods.parseDateHelper(timestamp, format).getTime());
    }

    public static String format(Number number, String format) throws FunctionExecutionException {
        try {
            DecimalFormat df = new DecimalFormat(format);
            return df.format(number);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", new Object[]{iae.getMessage()}));
        }
    }

    public static Object parseInteger(String number, String format) throws FunctionExecutionException {
        Number intNum = FunctionMethods.parseNumberHelper(number, format);
        return new Integer(intNum.intValue());
    }

    public static Object parseLong(String number, String format) throws FunctionExecutionException {
        Number longNum = FunctionMethods.parseNumberHelper(number, format);
        return new Long(longNum.longValue());
    }

    public static Object parseDouble(String number, String format) throws FunctionExecutionException {
        Number doubleNum = FunctionMethods.parseNumberHelper(number, format);
        return new Double(doubleNum.doubleValue());
    }

    public static Object parseFloat(String number, String format) throws FunctionExecutionException {
        Number longNum = FunctionMethods.parseNumberHelper(number, format);
        return new Float(longNum.floatValue());
    }

    public static Object parseBigInteger(String number, String format) throws FunctionExecutionException {
        Number bigIntegerNum = FunctionMethods.parseNumberHelper(number, format);
        return new BigInteger(bigIntegerNum.toString());
    }

    public static Object parseBigDecimal(String number, String format) throws FunctionExecutionException {
        Number bigDecimalNum = FunctionMethods.parseNumberHelper(number, format);
        return new BigDecimal(bigDecimalNum.toString());
    }

    private static Number parseNumberHelper(String number, String format) throws FunctionExecutionException {
        DecimalFormat df = new DecimalFormat(format);
        try {
            return df.parse(number);
        }
        catch (ParseException e) {
            throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", new Object[]{number, format}));
        }
    }

    public static Object acos(Number number) {
        return new Double(Math.acos(number.doubleValue()));
    }

    public static Object asin(Number number) {
        return new Double(Math.asin(number.doubleValue()));
    }

    public static Object atan(Number number) {
        return new Double(Math.atan(number.doubleValue()));
    }

    public static Object atan2(Number number1, Number number2) {
        return new Double(Math.atan2(number1.doubleValue(), number2.doubleValue()));
    }

    public static Object cos(Number number) {
        return new Double(Math.cos(number.doubleValue()));
    }

    public static Object cot(Number number) {
        return new Double(1.0 / Math.tan(number.doubleValue()));
    }

    public static Object degrees(Number number) {
        return new Double(Math.toDegrees(number.doubleValue()));
    }

    public static Object pi() {
        return new Double(Math.PI);
    }

    public static Object radians(Number number) {
        return new Double(Math.toRadians(number.doubleValue()));
    }

    public static Object sin(Number number) {
        return new Double(Math.sin(number.doubleValue()));
    }

    public static Object tan(Number number) {
        return new Double(Math.tan(number.doubleValue()));
    }

    public static Object bitand(int x, int y) {
        return x & y;
    }

    public static Object bitor(int x, int y) {
        return x | y;
    }

    public static Object bitxor(int x, int y) {
        return x ^ y;
    }

    public static int bitnot(int x) {
        return ~x;
    }

    public static Object user(CommandContext context) {
        return context.getUserName();
    }

    public static Object commandPayload(CommandContext context) {
        Serializable payload = context.getCommandPayload();
        if (payload == null) {
            return null;
        }
        return payload.toString();
    }

    public static Object commandPayload(CommandContext context, String param) throws ExpressionEvaluationException, FunctionExecutionException {
        Serializable payload = context.getCommandPayload();
        if (payload == null) {
            return null;
        }
        if (payload instanceof Properties) {
            return ((Properties)payload).getProperty(param);
        }
        throw new ExpressionEvaluationException(QueryPlugin.Util.getString("ExpressionEvaluator.Expected_props_for_payload_function", new Object[]{"commandPayload", payload.getClass().getName()}));
    }

    public static Object env(CommandContext context, String propertyName) {
        String propertyNameNocase = propertyName.toLowerCase();
        Properties envProps = context.getEnvironmentProperties();
        if (envProps != null && envProps.containsKey(propertyNameNocase)) {
            return envProps.getProperty(propertyNameNocase);
        }
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = System.getProperty(propertyNameNocase);
        }
        return value;
    }

    public static Object modifyTimeZone(Timestamp value, String originalTimezoneString, String targetTimezoneString) {
        TimeZone dbmsTimeZone;
        TimeZone originalTimeZone = TimeZone.getTimeZone(originalTimezoneString);
        if (originalTimeZone.equals(dbmsTimeZone = TimeZone.getTimeZone(targetTimezoneString))) {
            return value;
        }
        Calendar cal = Calendar.getInstance(dbmsTimeZone);
        return TimestampWithTimezone.createTimestamp((java.util.Date)value, (TimeZone)originalTimeZone, (Calendar)cal);
    }

    public static Object modifyTimeZone(CommandContext context, Timestamp value, String targetTimezoneString) {
        TimeZone dbmsTimeZone = TimeZone.getTimeZone(targetTimezoneString);
        Calendar cal = Calendar.getInstance(dbmsTimeZone);
        return TimestampWithTimezone.createTimestamp((java.util.Date)value, (TimeZone)context.getServerTimeZone(), (Calendar)cal);
    }

    public static Clob toChars(BlobType value, String encoding) {
        Charset cs = FunctionMethods.getCharset(encoding);
        InputStreamFactory.BlobInputStreamFactory bisf = new InputStreamFactory.BlobInputStreamFactory((Blob)value.getReference());
        ClobImpl clob = new ClobImpl((InputStreamFactory)bisf, -1L);
        clob.setCharset(cs);
        return new ClobType((Clob)clob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Blob toBytes(ClobType value, String encoding) throws IOException {
        Charset cs = FunctionMethods.getCharset(encoding);
        InputStreamFactory.ClobInputStreamFactory cisf = new InputStreamFactory.ClobInputStreamFactory((Clob)value.getReference());
        cisf.setCharset(cs);
        if ("BASE64".equalsIgnoreCase(encoding) || "HEX".equalsIgnoreCase(encoding)) {
            InputStream is = cisf.getInputStream();
            try {
                while (is.read() != -1) {
                }
            }
            finally {
                is.close();
            }
        }
        return new BlobType((Blob)new BlobImpl((InputStreamFactory)cisf));
    }

    public static Charset getCharset(String encoding) {
        if ("BASE64".equalsIgnoreCase(encoding)) {
            return CharsetUtils.BASE64;
        }
        if ("HEX".equalsIgnoreCase(encoding)) {
            return CharsetUtils.HEX;
        }
        return Charset.forName(encoding);
    }
}

