/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.teiid.internal.core.xml.JdomHelper;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;

public class FunctionMetadataReader {
    private static final String NOT_ALLOWED = "NOT_ALLOWED";
    private static final String ALLOWED = "ALLOWED";
    private static final String REQUIRED = "REQUIRED";
    private static final String RETURN_PARAMETER = "returnParameter";
    private static final String TYPE = "type";
    private static final String INPUT_PARAMETERS = "inputParameters";
    private static final String DETERMINISTIC = "deterministic";
    private static final String PUSH_DOWN = "pushDown";
    private static final String INVOCATION_METHOD = "invocationMethod";
    private static final String INVOCATION_CLASS = "invocationClass";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String SCALAR_FUNCTION = "ScalarFunction";
    private static final String NS_MMFUNCTION = "mmfunction";

    public static List<FunctionMethod> loadFunctionMethods(InputStream source) throws IOException {
        try {
            ArrayList<FunctionMethod> methods = new ArrayList<FunctionMethod>();
            Document doc = JdomHelper.buildDocument(source);
            Element rootElement = doc.getRootElement();
            Namespace ns = rootElement.getNamespace(NS_MMFUNCTION);
            List functionElements = rootElement.getChildren(SCALAR_FUNCTION, ns);
            for (Element functionElement : functionElements) {
                String name = functionElement.getAttributeValue(NAME);
                String description = functionElement.getAttributeValue(DESCRIPTION);
                String category = functionElement.getAttributeValue(CATEGORY);
                String invocationClass = functionElement.getAttributeValue(INVOCATION_CLASS);
                String invocationMethod = functionElement.getAttributeValue(INVOCATION_METHOD);
                int pushdown = FunctionMetadataReader.decodePushDownType(functionElement.getAttributeValue(PUSH_DOWN));
                boolean deterministic = Boolean.parseBoolean(functionElement.getAttributeValue(DETERMINISTIC));
                ArrayList<FunctionParameter> inParamters = new ArrayList<FunctionParameter>();
                List inputParameterElements = functionElement.getChildren(INPUT_PARAMETERS);
                for (Element inputElement : inputParameterElements) {
                    inParamters.add(new FunctionParameter(inputElement.getAttributeValue(NAME), inputElement.getAttributeValue(TYPE), inputElement.getAttributeValue(DESCRIPTION)));
                }
                FunctionParameter returnParameter = null;
                Element returnElement = functionElement.getChild(RETURN_PARAMETER);
                if (returnElement != null) {
                    returnParameter = new FunctionParameter("result", returnElement.getAttributeValue(TYPE), returnElement.getAttributeValue(DESCRIPTION));
                }
                FunctionMethod function = new FunctionMethod(name, description, category, pushdown, invocationClass, invocationMethod, inParamters.toArray(new FunctionParameter[inParamters.size()]), returnParameter, true, deterministic ? 0 : 4);
                methods.add(function);
            }
            return methods;
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }

    private static int decodePushDownType(String pushdown) {
        if (pushdown != null) {
            if (pushdown.equals(REQUIRED)) {
                return 0;
            }
            if (pushdown.equals(ALLOWED)) {
                return 2;
            }
            if (pushdown.equals(NOT_ALLOWED)) {
                return 1;
            }
        }
        return 0;
    }
}

