/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.teiid.internal.core.xml.SAXBuilderHelper;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingException;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;

public class MappingLoader {
    HashMap unresolvedNamespaces = new HashMap();

    public MappingDocument loadDocument(InputStream stream) throws MappingException {
        try {
            SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
            Document doc = builder.build(stream);
            return this.loadContents(doc);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    public MappingDocument loadDocument(String fileName) throws MappingException {
        try {
            SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
            Document doc = builder.build(new File(fileName));
            return this.loadContents(doc);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    MappingDocument loadContents(Document document) throws MappingException {
        MappingDocument doc = new MappingDocument(false);
        this.loadDocumentProperties(doc, document.getRootElement());
        List mappingChildren = document.getRootElement().getChildren("mappingNode");
        doc = (MappingDocument)this.recursiveLoadContents(mappingChildren, doc);
        return doc;
    }

    private MappingNode recursiveLoadContents(Collection mappingChildren, MappingBaseNode parent) throws MappingException {
        MappingBaseNode node = null;
        for (Element elem : mappingChildren) {
            node = this.processMappingNode(elem, parent);
            List childrenMappingNodes = elem.getChildren("mappingNode");
            this.recursiveLoadContents(childrenMappingNodes, node);
        }
        return parent;
    }

    MappingSequenceNode loadSequenceNode(Element element, MappingBaseNode parentNode) {
        MappingSequenceNode node = new MappingSequenceNode();
        node.setMinOccurrs(this.getMinOccurrences(element));
        node.setMaxOccurrs(this.getMaxOccurrences(element));
        node.setSource(this.getSource(element));
        node.setExclude(this.isExcluded(element));
        node.setStagingTables(this.getStagingTableNames(element));
        return node;
    }

    MappingElement loadElementNode(Element element, MappingBaseNode parentNode, boolean rootElement) throws MappingException {
        MappingElement node = null;
        String name = this.getName(element);
        if (name == null || name.length() == 0) {
            throw new MappingException(QueryPlugin.Util.getString("MappingLoader.invalidName"));
        }
        Namespace[] namespaces = this.getNamespaceDeclarations(element);
        Namespace namespace = this.getNamespace(element, namespaces, parentNode);
        if (this.isRecursive(element)) {
            MappingRecursiveElement elem = new MappingRecursiveElement(name, namespace, this.getRecursionMappingClass(element));
            elem.setCriteria(this.getRecursionCriteria(element));
            elem.setRecursionLimit(this.getRecursionLimit(element), this.throwExceptionOnRecursionLimit(element));
            node = elem;
        } else {
            node = new MappingElement(name, namespace);
        }
        if (rootElement) {
            node.setMinOccurrs(1);
            node.setMaxOccurrs(1);
        } else {
            node.setMinOccurrs(this.getMinOccurrences(element));
            node.setMaxOccurrs(this.getMaxOccurrences(element));
        }
        node.setNameInSource(this.getNameInSource(element));
        node.setSource(this.getSource(element));
        node.setOptional(this.isOptional(element));
        node.setDefaultValue(this.getDefaultValue(element));
        node.setValue(this.getFixedValue(element));
        node.setNillable(this.isNillable(element));
        node.setExclude(this.isExcluded(element));
        node.setType(this.getBuitInType(element));
        node.setNormalizeText(this.getNormalizeText(element));
        node.setAlwaysInclude(this.includeAlways(element));
        node.setStagingTables(this.getStagingTableNames(element));
        node.setNamespaces(namespaces);
        return node;
    }

    void loadAttributeNode(Element element, MappingElement parent) throws MappingException {
        String name = this.getName(element);
        String nsPrefix = this.getElementValue(element, "namespace");
        if (name == null || name.length() == 0) {
            throw new MappingException(QueryPlugin.Util.getString("MappingLoader.invalidName"));
        }
        Namespace namespace = null;
        boolean normalAttribute = true;
        if (name.equalsIgnoreCase("xmlns")) {
            namespace = new Namespace("", this.getFixedValue(element));
            parent.addNamespace(namespace);
            normalAttribute = false;
        } else if (nsPrefix != null && nsPrefix.equalsIgnoreCase("xmlns")) {
            namespace = (Namespace)this.unresolvedNamespaces.remove(name);
            if (namespace == null) {
                namespace = new Namespace(name);
            }
            namespace.setUri(this.getFixedValue(element));
            parent.addNamespace(namespace);
            normalAttribute = false;
        } else {
            namespace = this.getNamespace(element, null, parent);
        }
        if (normalAttribute) {
            MappingAttribute attribute = new MappingAttribute(this.getName(element), namespace);
            attribute.setNameInSource(this.getNameInSource(element));
            attribute.setDefaultValue(this.getDefaultValue(element));
            attribute.setValue(this.getFixedValue(element));
            attribute.setExclude(this.isExcluded(element));
            attribute.setNormalizeText(this.getNormalizeText(element));
            attribute.setOptional(this.isOptional(element));
            attribute.setAlwaysInclude(this.includeAlways(element));
            parent.addAttribute(attribute);
        }
    }

    MappingChoiceNode loadChoiceNode(Element element, MappingBaseNode parentNode) {
        MappingChoiceNode node = new MappingChoiceNode(this.exceptionOnDefault(element));
        node.setMinOccurrs(this.getMinOccurrences(element));
        node.setMaxOccurrs(this.getMaxOccurrences(element));
        node.setSource(this.getSource(element));
        node.setExclude(this.isExcluded(element));
        node.setStagingTables(this.getStagingTableNames(element));
        return node;
    }

    MappingAllNode loadAllNode(Element element, MappingBaseNode parentNode) {
        MappingAllNode node = new MappingAllNode();
        node.setMinOccurrs(this.getMinOccurrences(element));
        node.setMaxOccurrs(this.getMaxOccurrences(element));
        node.setSource(this.getSource(element));
        node.setExclude(this.isExcluded(element));
        node.setStagingTables(this.getStagingTableNames(element));
        return node;
    }

    void loadCommentNode(Element element, MappingElement parent) {
        MappingCommentNode comment = new MappingCommentNode(this.getCommentText(element));
        parent.addCommentNode(comment);
    }

    MappingDocument loadDocumentProperties(MappingDocument doc, Element element) {
        String encoding;
        boolean formatted = this.isFormattedDocument(element);
        if (formatted != MappingNodeConstants.Defaults.DEFAULT_FORMATTED_DOCUMENT) {
            doc.setFormatted(formatted);
        }
        if (!"UTF-8".equalsIgnoreCase(encoding = this.getDocumentEncoding(element))) {
            doc.setDocumentEncoding(encoding);
        }
        return doc;
    }

    MappingCriteriaNode loadCriteriaNode(Element element, MappingBaseNode parentNode) throws MappingException {
        if (this.getCriteria(element) != null || this.isDefaultOnChoiceNode(element)) {
            return new MappingCriteriaNode(this.getCriteria(element), this.isDefaultOnChoiceNode(element));
        }
        throw new MappingException(QueryPlugin.Util.getString("MappingLoader.invalid_criteria_node"));
    }

    MappingBaseNode processMappingNode(Element element, MappingBaseNode parentNode) throws MappingException {
        MappingBaseNode child;
        boolean isRootNode = parentNode instanceof MappingDocument;
        String nodeType = this.getElementValue(element, "nodeType");
        if (nodeType == null || nodeType.length() == 0) {
            nodeType = "element";
        }
        if (isRootNode && nodeType.equalsIgnoreCase("element")) {
            MappingDocument doc = (MappingDocument)parentNode;
            this.loadDocumentProperties(doc, element);
        }
        if (nodeType.equalsIgnoreCase("element") && (this.getCriteria(element) != null || this.isDefaultOnChoiceNode(element))) {
            MappingCriteriaNode node = new MappingCriteriaNode(this.getCriteria(element), this.isDefaultOnChoiceNode(element));
            parentNode.addCriteriaNode(node);
            parentNode = node;
        }
        if (nodeType.equalsIgnoreCase("element")) {
            child = this.loadElementNode(element, parentNode, isRootNode);
            parentNode.addChildElement((MappingElement)child);
            return child;
        }
        if (nodeType.equalsIgnoreCase("attribute")) {
            this.loadAttributeNode(element, (MappingElement)parentNode);
        } else {
            if (nodeType.equalsIgnoreCase("choice")) {
                child = this.loadChoiceNode(element, parentNode);
                parentNode.addChoiceNode((MappingChoiceNode)child);
                return child;
            }
            if (nodeType.equalsIgnoreCase("criteria")) {
                child = this.loadCriteriaNode(element, parentNode);
                parentNode.addCriteriaNode((MappingCriteriaNode)child);
                return child;
            }
            if (nodeType.equalsIgnoreCase("all")) {
                child = this.loadAllNode(element, parentNode);
                parentNode.addAllNode((MappingAllNode)child);
                return child;
            }
            if (nodeType.equalsIgnoreCase("sequence")) {
                child = this.loadSequenceNode(element, parentNode);
                parentNode.addSequenceNode((MappingSequenceNode)child);
                return child;
            }
            if (nodeType.equalsIgnoreCase("comment")) {
                this.loadCommentNode(element, (MappingElement)parentNode);
            } else {
                throw new MappingException(QueryPlugin.Util.getString("MappingLoader.unknown_node_type", new Object[]{nodeType}));
            }
        }
        return null;
    }

    private Namespace[] getNamespaceDeclarations(Element element) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (Element namespace : this.getElements(element, "namespaceDeclaration")) {
            Element prefixEl = this.getElement(namespace, "prefix");
            Element uriEl = this.getElement(namespace, "uri");
            String prefix = prefixEl != null ? prefixEl.getTextTrim() : "";
            String uri = uriEl.getTextTrim();
            namespaces.add(new Namespace(prefix, uri));
        }
        return namespaces.toArray(new Namespace[namespaces.size()]);
    }

    Element getElement(Element element, String childName) {
        return element.getChild(childName);
    }

    String getElementValue(Element element, String childName) {
        Element child = element.getChild(childName);
        if (child != null) {
            return child.getTextTrim();
        }
        return null;
    }

    String getElementValue(Element element, String childName, String defalt) {
        Element child = element.getChild(childName);
        if (child != null) {
            return child.getTextTrim();
        }
        return defalt;
    }

    int getIntElementValue(Element element, String childName, int defalt) {
        Element child = element.getChild(childName);
        if (child != null) {
            return Integer.valueOf(child.getTextTrim());
        }
        return defalt;
    }

    boolean getBooleanElementValue(Element element, String childName, boolean defalt) {
        Element child = element.getChild(childName);
        if (child != null) {
            return Boolean.valueOf(child.getTextTrim());
        }
        return defalt;
    }

    Collection getElements(Element element, String childName) {
        return element.getChildren(childName);
    }

    String getName(Element element) {
        return this.getElementValue(element, "name");
    }

    int getMinOccurrences(Element element) {
        return this.getIntElementValue(element, "minOccurs", MappingNodeConstants.Defaults.DEFAULT_CARDINALITY_MINIMUM_BOUND);
    }

    int getMaxOccurrences(Element element) {
        String maxBound = this.getElementValue(element, "maxOccurs");
        if (maxBound != null && maxBound.equals("unbounded")) {
            return MappingNodeConstants.CARDINALITY_UNBOUNDED;
        }
        if (maxBound != null) {
            return Integer.valueOf(maxBound);
        }
        return MappingNodeConstants.Defaults.DEFAULT_CARDINALITY_MAXIMUM_BOUND;
    }

    String getNameInSource(Element element) {
        return this.getElementValue(element, "symbol");
    }

    String getCommentText(Element element) {
        return this.getElementValue(element, "comment");
    }

    boolean isOptional(Element element) {
        return this.getBooleanElementValue(element, "optional", MappingNodeConstants.Defaults.DEFAULT_IS_OPTIONAL);
    }

    String getSource(Element element) {
        return this.getElementValue(element, "source");
    }

    String getCriteria(Element element) {
        return this.getElementValue(element, "criteria");
    }

    String getDefaultValue(Element element) {
        return this.getElementValue(element, "default");
    }

    String getFixedValue(Element element) {
        return this.getElementValue(element, "fixed");
    }

    boolean isNillable(Element element) {
        return this.getBooleanElementValue(element, "isNillable", MappingNodeConstants.Defaults.DEFAULT_IS_NILLABLE);
    }

    boolean isExcluded(Element element) {
        return this.getBooleanElementValue(element, "isExcluded", MappingNodeConstants.Defaults.DEFAULT_IS_EXCLUDED);
    }

    boolean isDefaultOnChoiceNode(Element element) {
        return this.getBooleanElementValue(element, "isDefaultChoice", MappingNodeConstants.Defaults.DEFAULT_IS_DEFAULT_CHOICE);
    }

    boolean exceptionOnDefault(Element element) {
        return this.getBooleanElementValue(element, "exceptionOnDefault", MappingNodeConstants.Defaults.DEFAULT_EXCEPTION_ON_DEFAULT);
    }

    String getDocumentEncoding(Element element) {
        return this.getElementValue(element, "documentEncoding", "UTF-8");
    }

    boolean isFormattedDocument(Element element) {
        return this.getBooleanElementValue(element, "formattedDocument", MappingNodeConstants.Defaults.DEFAULT_FORMATTED_DOCUMENT);
    }

    boolean isRecursive(Element element) {
        return this.getBooleanElementValue(element, "isRecursive", MappingNodeConstants.Defaults.DEFAULT_IS_RECURSIVE);
    }

    String getRecursionCriteria(Element element) {
        return this.getElementValue(element, "recursionCriteria");
    }

    String getRecursionMappingClass(Element element) {
        return this.getElementValue(element, "recursionRootMappingClass");
    }

    int getRecursionLimit(Element element) {
        return this.getIntElementValue(element, "recursionLimit", MappingNodeConstants.Defaults.DEFAULT_RECURSION_LIMIT);
    }

    boolean throwExceptionOnRecursionLimit(Element element) {
        return this.getBooleanElementValue(element, "recursionLimitException", MappingNodeConstants.Defaults.DEFAULT_EXCEPTION_ON_RECURSION_LIMIT);
    }

    List getStagingTableNames(Element element) {
        ArrayList<String> cacheGroups = new ArrayList<String>();
        Collection tempGroupElements = this.getElements(element, "tempGroup");
        for (Element tempGroup : tempGroupElements) {
            cacheGroups.add(tempGroup.getTextTrim());
        }
        return cacheGroups;
    }

    String getNormalizeText(Element element) {
        return this.getElementValue(element, "textNormalization", "preserve");
    }

    String getBuitInType(Element element) {
        return this.getElementValue(element, "builtInType");
    }

    boolean includeAlways(Element element) {
        return this.getBooleanElementValue(element, "includeAlways", false);
    }

    Namespace getNamespace(Element element, Namespace[] localNamespaces, MappingBaseNode parentNode) {
        String prefix = this.getElementValue(element, "namespace");
        if (prefix != null) {
            if (localNamespaces != null) {
                for (int i = 0; i < localNamespaces.length; ++i) {
                    if (!localNamespaces[i].getPrefix().equals(prefix)) continue;
                    return localNamespaces[i];
                }
            }
            while (parentNode != null) {
                if (parentNode instanceof MappingElement) {
                    MappingElement parentElement = (MappingElement)parentNode;
                    return this.getNamespace(element, parentElement.getNamespaces(), parentElement.getParentNode());
                }
                parentNode = parentNode.getParentNode();
            }
            Namespace unresolved = new Namespace(prefix);
            this.unresolvedNamespaces.put(prefix, unresolved);
            return unresolved;
        }
        return MappingNodeConstants.NO_NAMESPACE;
    }
}

