/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;

public abstract class MappingNode
implements Cloneable,
Serializable {
    private MappingNode parent;
    private LinkedList children = new LinkedList();
    private Map nodeProperties;
    private static final String TAB = "  ";

    public MappingNode getParent() {
        return this.parent;
    }

    public static MappingNode findNode(MappingNode root, String partialName) {
        String canonicalName = root.getName();
        if (canonicalName != null) {
            if (partialName.startsWith("@")) {
                canonicalName = "@" + canonicalName;
            }
            canonicalName = canonicalName.toUpperCase();
            boolean abort = true;
            if (partialName.startsWith(canonicalName)) {
                if (partialName.length() > canonicalName.length() + 1 && partialName.charAt(canonicalName.length()) == ".".toCharArray()[0]) {
                    partialName = partialName.substring(canonicalName.length() + 1);
                    abort = false;
                } else if (partialName.length() == canonicalName.length()) {
                    return root;
                }
            }
            if (abort) {
                return null;
            }
        }
        for (MappingNode child : root.getChildren()) {
            MappingNode found = MappingNode.findNode(child, partialName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void setParent(MappingNode parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public List getChildren(String type) {
        ArrayList<MappingNode> subset = new ArrayList<MappingNode>();
        for (MappingNode node : this.children) {
            if (!node.getProperty(MappingNodeConstants.Properties.NODE_TYPE).equals(type)) continue;
            subset.add(node);
        }
        return subset;
    }

    public List getNodeChildren() {
        ArrayList<MappingNode> subset = new ArrayList<MappingNode>();
        for (MappingNode node : this.children) {
            if (node.getProperty(MappingNodeConstants.Properties.NODE_TYPE).equals("attribute")) continue;
            subset.add(node);
        }
        return subset;
    }

    public MappingNode addChild(MappingNode node) {
        this.children.add(node);
        node.setParent(this);
        return node;
    }

    public Object getProperty(Integer propertyID) {
        Object value = null;
        if (this.nodeProperties != null) {
            value = this.nodeProperties.get(propertyID);
        }
        if (value == null) {
            value = MappingNodeConstants.Defaults.DEFAULT_VALUES.get(propertyID);
        }
        return value;
    }

    void setProperty(Integer propertyID, Object value) {
        if (value != null) {
            Object defaultValue = MappingNodeConstants.Defaults.DEFAULT_VALUES.get(propertyID);
            Map props = this.getNodeProperties();
            if (!value.equals(defaultValue)) {
                props.put(propertyID, value);
            } else {
                props.remove(propertyID);
            }
        }
    }

    void removeProperty(Integer propertyID) {
        this.getNodeProperties().remove(propertyID);
    }

    public Map getNodeProperties() {
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap();
        }
        return this.nodeProperties;
    }

    public String getFullyQualifiedName() {
        String parentName;
        String myName = this.getPathName();
        String string = parentName = this.getParent() == null ? "" : this.getParent().getFullyQualifiedName();
        if (myName == null || myName.equals("")) {
            return parentName;
        }
        if (parentName == null || parentName.equals("")) {
            return myName;
        }
        return parentName + "." + myName;
    }

    public String getName() {
        return (String)this.getProperty(MappingNodeConstants.Properties.NAME);
    }

    public String getPathName() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof MappingNode) {
            return ((Object)((MappingNode)obj).getNodeProperties()).equals(this.getNodeProperties());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getNodeProperties()).hashCode();
    }

    public String toString() {
        Object name = this.getProperty(MappingNodeConstants.Properties.NAME);
        Object criteria = this.getProperty(MappingNodeConstants.Properties.CRITERIA);
        Object prefix = this.getProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX);
        Object defaultValue = this.getProperty(MappingNodeConstants.Properties.DEFAULT_VALUE);
        Object fixedValue = this.getProperty(MappingNodeConstants.Properties.FIXED_VALUE);
        Object namespaces = this.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        return "[" + this.getProperty(MappingNodeConstants.Properties.NODE_TYPE) + "]" + " name='" + (prefix != null ? prefix + ":" : "") + (name != null ? name : "") + "'" + (defaultValue != null ? " default='" + defaultValue + "'" : "") + (fixedValue != null ? " fixed='" + fixedValue + "'" : "") + " minOccurs=" + this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND) + " maxOccurs=" + this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND) + (criteria != null ? " constraint=\"" + criteria + "\"" : "") + (namespaces != null ? " namespaces=\"" + namespaces + "\"" : "");
    }

    public static void printMappingNodeTree(MappingNode root, PrintStream output) {
        output.print(MappingNode.toStringNodeTree(root));
    }

    public static String toStringNodeTree(MappingNode root) {
        StringBuffer str = new StringBuffer();
        MappingNode.buildTreeString(root, str, 0);
        return str.toString();
    }

    private static void buildTreeString(MappingNode node, StringBuffer str, int tabLevel) {
        MappingNode.setTab(str, tabLevel++);
        str.append(node.toString());
        str.append(node.getNodeProperties());
        str.append("\n");
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            MappingNode.buildTreeString((MappingNode)i.next(), str, tabLevel);
        }
    }

    private static void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    static MappingNode findFirstNodeWithProperty(Integer propertyKey, Object value, MappingNode node, int searchDirection) {
        return MappingNode.findFirstNodeWithPropertyValue(propertyKey, value, false, node, searchDirection);
    }

    static MappingNode findFirstNodeWithPropertyString(Integer propertyKey, String value, MappingNode node, int searchDirection) {
        return MappingNode.findFirstNodeWithPropertyValue(propertyKey, value, true, node, searchDirection);
    }

    private static MappingNode findFirstNodeWithPropertyValue(Integer propertyKey, Object value, boolean isStringValue, MappingNode node, int searchDirection) {
        if (node == null || propertyKey == null) {
            return null;
        }
        if (searchDirection == 2) {
            return MappingNode.traverseUpForFirstNodeWithPropertyString(propertyKey, value, isStringValue, node);
        }
        if (searchDirection == 3) {
            return MappingNode.traverseDownForFirstNodeWithPropertyString(propertyKey, value, isStringValue, node, false);
        }
        if (searchDirection == 4) {
            if (MappingNode.checkThisNodeForPropertyValue(propertyKey, value, isStringValue, node)) {
                return node;
            }
            return MappingNode.traverseDownForFirstNodeWithPropertyString(propertyKey, value, isStringValue, node, true);
        }
        throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.002.0009", new Object[]{searchDirection}));
    }

    private static MappingNode traverseDownForFirstNodeWithPropertyString(Integer propertyKey, Object value, boolean isStringValue, MappingNode node, boolean breadthFirst) {
        if (breadthFirst) {
            for (MappingNode child : node.getChildren()) {
                if (!MappingNode.checkThisNodeForPropertyValue(propertyKey, value, isStringValue, child)) continue;
                return child;
            }
        } else if (MappingNode.checkThisNodeForPropertyValue(propertyKey, value, isStringValue, node)) {
            return node;
        }
        for (MappingNode child : node.getChildren()) {
            MappingNode result = MappingNode.traverseDownForFirstNodeWithPropertyString(propertyKey, value, isStringValue, child, breadthFirst);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean checkThisNodeForPropertyValue(Integer propertyKey, Object value, boolean isStringValue, MappingNode node) {
        Object thisValue = node.getProperty(propertyKey);
        if (thisValue != null) {
            if (value == null) {
                return true;
            }
            if (isStringValue && ((String)thisValue).equalsIgnoreCase((String)value)) {
                return true;
            }
            if (thisValue.equals(value)) {
                return true;
            }
        }
        return false;
    }

    private static MappingNode traverseUpForFirstNodeWithPropertyString(Integer propertyKey, Object value, boolean isStringValue, MappingNode node) {
        while (node != null) {
            if (MappingNode.checkThisNodeForPropertyValue(propertyKey, value, isStringValue, node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public MappingNode setExclude(boolean exclude) {
        this.setProperty(MappingNodeConstants.Properties.IS_EXCLUDED, exclude);
        return this;
    }

    public boolean isExcluded() {
        Boolean exclude = (Boolean)this.getProperty(MappingNodeConstants.Properties.IS_EXCLUDED);
        if (exclude != null) {
            return exclude;
        }
        return false;
    }

    public abstract void acceptVisitor(MappingVisitor var1);

    public MappingSourceNode getSourceNode() {
        if (this.getParent() != null) {
            return this.getParent().getSourceNode();
        }
        return null;
    }

    public String getNameInSource() {
        return null;
    }
}

