/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import org.teiid.internal.core.xml.JdomHelper;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;

public class MappingOutputter {
    private static final String NS_NAME = null;
    private static final String NS_URL = null;
    private static final String ELEM_ROOT = "xmlMapping";
    private static final String ELEM_NODE = "mappingNode";
    private Namespace namespace = Namespace.getNamespace((String)NS_NAME, (String)NS_URL);

    public void write(MappingDocument doc, PrintWriter stream) throws IOException {
        this.write(doc, stream, false, false);
    }

    public void write(MappingDocument doc, PrintWriter stream, boolean newlines, boolean indent) throws IOException {
        String indentString = "";
        if (indent) {
            indentString = "    ";
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indentString, newlines));
        outputter.output(this.loadDocument(doc), (Writer)stream);
    }

    Document loadDocument(MappingDocument mappingDoc) {
        Document xmlDoc = new Document(new Element(ELEM_ROOT, this.namespace));
        this.setDocumentProperties(mappingDoc, xmlDoc.getRootElement());
        this.loadNode(mappingDoc.getRootNode(), xmlDoc.getRootElement());
        return xmlDoc;
    }

    void setDocumentProperties(MappingDocument mappingDoc, Element rootElement) {
        rootElement.addContent((Content)new Element("documentEncoding").setText(mappingDoc.getDocumentEncoding()));
        rootElement.addContent((Content)new Element("formattedDocument").setText(Boolean.toString(mappingDoc.isFormatted())));
    }

    void loadNode(MappingNode node, Element parentElement) {
        Element element = this.processNode(node, parentElement);
        for (MappingNode child : node.getChildren()) {
            this.loadNode(child, element);
        }
    }

    Element processNode(MappingNode node, Element parentElement) {
        Element element = new Element(ELEM_NODE, this.namespace);
        parentElement.addContent((Content)element);
        Properties namespaces = (Properties)node.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        if (namespaces != null) {
            this.addNamespaceDeclarations(element, namespaces);
        }
        Map properties = node.getNodeProperties();
        this.addElementProperties(element, properties);
        return element;
    }

    private void addNamespaceDeclarations(Element element, Properties namespaces) {
        Enumeration<?> e = namespaces.propertyNames();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String uri = namespaces.getProperty(prefix);
            Element namespaceDeclaration = new Element("namespaceDeclaration", this.namespace);
            if (!prefix.equals("")) {
                namespaceDeclaration.addContent((Content)new Element("prefix").setText(prefix));
            }
            namespaceDeclaration.addContent((Content)new Element("uri").setText(uri));
            element.addContent((Content)namespaceDeclaration);
        }
    }

    void addProperty(Map map, String name, Object value) {
        if (value != null) {
            map.put(name, value);
        }
    }

    void addElementProperties(Element element, Map properties) {
        for (String propName : MappingNodeConstants.Tags.OUTPUTTER_PROPERTY_TAGS) {
            Integer propKey = MappingNodeConstants.getPropertyInteger(propName);
            if (!properties.containsKey(propKey)) continue;
            Object value = properties.get(propKey);
            this.addElementProperty(element, propName, value);
        }
    }

    void addElementProperty(Element element, String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.002.0010", new Object[]{name}));
        }
        if (value instanceof Collection) {
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                element.addContent((Content)new Element(name, this.namespace).setText(this.getXMLText(i.next())));
            }
        } else {
            element.addContent((Content)new Element(name, this.namespace).setText(this.getXMLText(value)));
        }
    }

    private String getXMLText(Object obj) {
        if (obj instanceof String) {
            return this.getXMLText((String)obj);
        }
        if (obj instanceof Integer) {
            return this.getXMLText((Integer)obj);
        }
        if (obj instanceof Boolean) {
            return this.getXMLText((Boolean)obj);
        }
        throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.002.0011", new Object[]{obj.getClass().getName()}));
    }

    private String getXMLText(String str) {
        return str != null ? str : "";
    }

    private String getXMLText(Integer value) {
        return value.toString();
    }

    private String getXMLText(Boolean value) {
        return value.toString();
    }
}

