/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.metadata.BasicQueryMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;

public class TempMetadataAdapter
extends BasicQueryMetadataWrapper {
    private static final String SEPARATOR = ".";
    private static final TempMetadataID TEMP_MODEL = new TempMetadataID("__TEMP__", Collections.EMPTY_LIST);
    private TempMetadataStore tempStore;
    private Map materializationTables;
    private Map queryNodes;

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore) {
        super(metadata);
        this.tempStore = tempStore;
    }

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore, Map materializationTables, Map queryNodes) {
        super(metadata);
        this.tempStore = tempStore;
        this.materializationTables = materializationTables;
        this.queryNodes = queryNodes;
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempStore;
    }

    public QueryMetadataInterface getMetadata() {
        return this.actualMetadata;
    }

    @Override
    public Object getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.actualMetadata.getElementID(elementName);
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempElementID(elementName);
        }
        if (tempID != null) {
            return tempID;
        }
        Object[] params = new Object[]{elementName};
        String msg = QueryPlugin.Util.getString("TempMetadataAdapter.Element_____{0}_____not_found._1", params);
        throw new QueryMetadataException(msg);
    }

    @Override
    public Object getGroupID(String groupName) throws TeiidComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.actualMetadata.getGroupID(groupName);
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempGroupID(groupName);
        }
        if (tempID != null) {
            return tempID;
        }
        Object[] params = new Object[]{groupName};
        String msg = QueryPlugin.Util.getString("TempMetadataAdapter.Group_____{0}_____not_found._1", params);
        throw new QueryMetadataException(msg);
    }

    @Override
    public Object getModelID(Object groupOrElementID) throws TeiidComponentException, QueryMetadataException {
        if (groupOrElementID instanceof TempMetadataID) {
            return TEMP_MODEL;
        }
        return this.actualMetadata.getModelID(groupOrElementID);
    }

    @Override
    public String getFullName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            return ((TempMetadataID)metadataID).getID();
        }
        return this.actualMetadata.getFullName(metadataID);
    }

    @Override
    public List getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return new ArrayList<TempMetadataID>(((TempMetadataID)groupID).getElements());
        }
        return this.actualMetadata.getElementIDsInGroupID(groupID);
    }

    @Override
    public Object getGroupIDForElementID(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            String elementName = ((TempMetadataID)elementID).getID();
            String groupName = elementName.substring(0, elementName.lastIndexOf(SEPARATOR));
            return this.tempStore.getTempGroupID(groupName);
        }
        return this.actualMetadata.getGroupIDForElementID(elementID);
    }

    @Override
    public String getElementType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID tempID = (TempMetadataID)elementID;
            if (tempID.getType() != null) {
                return DataTypeManager.getDataTypeName(tempID.getType());
            }
            TempMetadataID storedTempID = this.tempStore.getTempElementID(tempID.getID());
            return DataTypeManager.getDataTypeName(storedTempID.getType());
        }
        return this.actualMetadata.getElementType(elementID);
    }

    @Override
    public Object getDefaultValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getDefaultValue(elementID);
    }

    @Override
    public Object getMaximumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getMaximumValue(elementID);
    }

    @Override
    public Object getMinimumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getMinimumValue(elementID);
    }

    @Override
    public int getDistinctValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return -1;
        }
        return this.actualMetadata.getDistinctValues(elementID);
    }

    @Override
    public int getNullValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return -1;
        }
        return this.actualMetadata.getNullValues(elementID);
    }

    @Override
    public QueryNode getVirtualPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (this.queryNodes != null && this.queryNodes.containsKey(groupID)) {
            return (QueryNode)this.queryNodes.get(groupID);
        }
        if (groupID instanceof TempMetadataID && !(this.actualMetadata instanceof TempMetadataAdapter)) {
            return null;
        }
        return this.actualMetadata.getVirtualPlan(groupID);
    }

    @Override
    public boolean isVirtualGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isVirtual();
        }
        return this.actualMetadata.isVirtualGroup(groupID);
    }

    @Override
    public boolean hasMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (this.materializationTables != null && this.materializationTables.containsKey(groupID)) {
            return true;
        }
        if (groupID instanceof TempMetadataID) {
            return false;
        }
        return this.actualMetadata.hasMaterialization(groupID);
    }

    @Override
    public Object getMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (this.materializationTables != null && this.materializationTables.containsKey(groupID)) {
            return this.materializationTables.get(groupID);
        }
        if (groupID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getMaterialization(groupID);
    }

    @Override
    public Object getMaterializationStage(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getMaterializationStage(groupID);
    }

    @Override
    public boolean isVirtualModel(Object modelID) throws TeiidComponentException, QueryMetadataException {
        if (modelID.equals(TEMP_MODEL)) {
            return true;
        }
        return this.actualMetadata.isVirtualModel(modelID);
    }

    @Override
    public boolean elementSupports(Object elementID, int supportConstant) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            switch (supportConstant) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            elementID = id.getOriginalMetadataID();
            if (elementID == null || id.isTempTable()) {
                switch (supportConstant) {
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return true;
                    }
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.actualMetadata.elementSupports(elementID, supportConstant);
    }

    @Override
    public Collection getIndexesInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getIndexesInGroup(groupID);
    }

    @Override
    public Collection getUniqueKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getUniqueKeysInGroup(groupID);
    }

    @Override
    public Collection getForeignKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getForeignKeysInGroup(groupID);
    }

    @Override
    public List getElementIDsInIndex(Object index) throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInIndex(index);
    }

    @Override
    public List getElementIDsInKey(Object keyID) throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInKey(keyID);
    }

    @Override
    public boolean groupSupports(Object groupID, int groupConstant) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return true;
        }
        return this.actualMetadata.groupSupports(groupID, groupConstant);
    }

    @Override
    public MappingNode getMappingNode(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getMappingNode(groupID);
    }

    @Override
    public boolean isXMLGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return false;
        }
        return this.actualMetadata.isXMLGroup(groupID);
    }

    @Override
    public String getVirtualDatabaseName() throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getVirtualDatabaseName();
    }

    @Override
    public Collection getAccessPatternsInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)groupID;
            return id.getAccessPatterns();
        }
        return this.actualMetadata.getAccessPatternsInGroup(groupID);
    }

    @Override
    public List getElementIDsInAccessPattern(Object accessPattern) throws TeiidComponentException, QueryMetadataException {
        if (accessPattern instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)accessPattern;
            if (id.getElements() != null) {
                return id.getElements();
            }
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getElementIDsInAccessPattern(accessPattern);
    }

    @Override
    public Collection getXMLTempGroups(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_SET;
        }
        return this.actualMetadata.getXMLTempGroups(groupID);
    }

    @Override
    public int getCardinality(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).getCardinality();
        }
        return this.actualMetadata.getCardinality(groupID);
    }

    @Override
    public List getXMLSchemas(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getXMLSchemas(groupID);
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getExtensionProperties(metadataID);
    }

    @Override
    public int getElementLength(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            Object origElementID = id.getOriginalMetadataID();
            if (origElementID == null) {
                String type = this.getElementType(elementID);
                if (type.equals("string")) {
                    return 255;
                }
                return 10;
            }
            elementID = origElementID;
        }
        return this.actualMetadata.getElementLength(elementID);
    }

    @Override
    public int getPosition(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            String elementName = ((TempMetadataID)elementID).getID();
            String groupName = elementName.substring(0, elementName.lastIndexOf(SEPARATOR));
            TempMetadataID groupID = this.tempStore.getTempGroupID(groupName);
            List<TempMetadataID> elements = groupID.getElements();
            return elements.indexOf(elementID);
        }
        return this.actualMetadata.getPosition(elementID);
    }

    @Override
    public int getPrecision(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getPrecision(elementID);
    }

    @Override
    public int getRadix(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getRadix(elementID);
    }

    @Override
    public int getScale(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getScale(elementID);
    }

    @Override
    public String getNativeType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return "";
        }
        return this.actualMetadata.getNativeType(elementID);
    }

    @Override
    public boolean isProcedure(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            Object oid = ((TempMetadataID)elementID).getOriginalMetadataID();
            if (oid != null) {
                return this.actualMetadata.isProcedure(oid);
            }
            return false;
        }
        return this.actualMetadata.isProcedure(elementID);
    }

    @Override
    public String getModeledType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getModeledType(elementID);
    }

    @Override
    public String getModeledBaseType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getModeledBaseType(elementID);
    }

    @Override
    public String getModeledPrimitiveType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getModeledPrimitiveType(elementID);
    }

    @Override
    public boolean isTemporaryTable(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isTempTable();
        }
        return false;
    }

    @Override
    public Object addToMetadataCache(Object metadataID, String key, Object value) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)metadataID;
            return tid.setProperty(key, value);
        }
        return this.actualMetadata.addToMetadataCache(metadataID, key, value);
    }

    @Override
    public Object getFromMetadataCache(Object metadataID, String key) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)metadataID;
            return tid.getProperty(key);
        }
        return this.actualMetadata.getFromMetadataCache(metadataID, key);
    }

    @Override
    public boolean isScalarGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)groupID;
            return tid.isScalarGroup();
        }
        return this.actualMetadata.isScalarGroup(groupID);
    }
}

