/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.core.util.LRUCache;

public class TempMetadataID
implements Serializable {
    private static final int LOCAL_CACHE_SIZE = 8;
    private String ID;
    private int position = -1;
    private Class<?> type;
    private List<TempMetadataID> elements;
    private Object originalMetadataID;
    private boolean isVirtual = true;
    private boolean isTempTable;
    private Collection<TempMetadataID> accessPatterns;
    private int cardinality = 0;
    private LRUCache localCache;
    private boolean scalarGroup;

    public TempMetadataID(String ID, List<TempMetadataID> elements) {
        this.ID = ID;
        this.elements = elements;
    }

    public TempMetadataID(String ID, List<TempMetadataID> elements, boolean isVirtual, boolean isTempTable) {
        this.ID = ID;
        this.elements = elements;
        this.isVirtual = isVirtual;
        this.isTempTable = isTempTable;
    }

    public TempMetadataID(String ID, Class<?> type) {
        this.ID = ID;
        this.type = type;
    }

    public TempMetadataID(String ID, Class<?> type, Object metadataID) {
        this.ID = ID;
        this.type = type;
        this.originalMetadataID = metadataID;
    }

    public String getID() {
        return this.ID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<TempMetadataID> getElements() {
        return this.elements;
    }

    protected void addElement(TempMetadataID elem) {
        if (this.elements != null) {
            this.elements.add(elem);
        }
        if (this.localCache != null) {
            this.localCache.clear();
        }
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public String toString() {
        return this.ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TempMetadataID)) {
            return false;
        }
        return this.getID().equals(((TempMetadataID)obj).getID());
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public void setOriginalMetadataID(Object metadataId) {
        this.originalMetadataID = metadataId;
    }

    public Object getOriginalMetadataID() {
        return this.originalMetadataID;
    }

    public Collection<TempMetadataID> getAccessPatterns() {
        if (this.accessPatterns == null) {
            return Collections.emptyList();
        }
        return this.accessPatterns;
    }

    public void setAccessPatterns(Collection<TempMetadataID> accessPatterns) {
        this.accessPatterns = accessPatterns;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void setTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    Object getProperty(Object key) {
        if (this.localCache != null) {
            return this.localCache.get(key);
        }
        return null;
    }

    Object setProperty(Object key, Object value) {
        if (this.localCache == null) {
            this.localCache = new LRUCache(8);
        }
        return this.localCache.put(key, value);
    }

    public boolean isScalarGroup() {
        return this.scalarGroup;
    }

    public void setScalarGroup(boolean scalarGroup) {
        this.scalarGroup = scalarGroup;
    }
}

