/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.batch.BatchedUpdatePlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.proc.ProcedurePlanner;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.util.CommandContext;

public class QueryOptimizer {
    private static final CommandPlanner XML_PLANNER = new XMLPlanner();
    private static final CommandPlanner PROCEDURE_PLANNER = new ProcedurePlanner();
    private static final CommandPlanner BATCHED_UPDATE_PLANNER = new BatchedUpdatePlanner();

    private QueryOptimizer() {
    }

    public static ProcessorPlan optimizePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        if (analysisRecord == null) {
            analysisRecord = new AnalysisRecord(false, false);
        }
        if (context == null) {
            context = new CommandContext();
        }
        boolean debug = analysisRecord.recordDebug();
        Map tempMetadata = command.getTemporaryMetadata();
        metadata = new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata));
        if (idGenerator == null) {
            idGenerator = new IDGenerator();
            idGenerator.setDefaultFactory((ObjectIDFactory)new IntegerIDFactory());
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZE: \n" + command);
        }
        ProcessorPlan result = null;
        if (command.getType() == 7) {
            result = PROCEDURE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (command.getType() == 9) {
            result = BATCHED_UPDATE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
        } else {
            try {
                result = command.getType() == 1 && command instanceof Query && QueryResolver.isXMLQuery((Query)command, metadata) ? XML_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context) : new RelationalPlanner().optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
            }
            catch (QueryResolverException e) {
                throw new TeiidRuntimeException((Throwable)((Object)e));
            }
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZATION COMPLETE:");
            analysisRecord.println("PROCESSOR PLAN:\n" + result);
            analysisRecord.println("============================================================================");
        }
        return result;
    }
}

